/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.jsunit.ant;

import de.berlios.jsunit.JsUnitException;
import de.berlios.jsunit.JsUnitRhinoRunner;
import de.berlios.jsunit.JsUnitRuntimeException;
import de.berlios.jsunit.ant.JsUnitSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class JsUnitTask
extends Task {
    private File dir = new File(".");
    private final List sources = new ArrayList();
    private final List testSuites = new ArrayList();
    private boolean haltOnError = true;
    private boolean haltOnFailure = true;

    public void execute() throws BuildException {
        Project project = this.getProject();
        if (!this.dir.isDirectory()) {
            throw new BuildException("Source directory not found");
        }
        if (this.testSuites.isEmpty()) {
            throw new BuildException("No test suites defined");
        }
        int errors = 0;
        int failures = 0;
        Iterator iterTest = this.testSuites.iterator();
        while (iterTest.hasNext()) {
            JsUnitRhinoRunner runner = null;
            try {
                runner = new JsUnitRhinoRunner();
            }
            catch (JsUnitRuntimeException e) {
                throw new BuildException("Cannot evaluate JavaScript code of JsUnit", (Throwable)e);
            }
            Iterator iterSource = this.sources.iterator();
            while (iterSource.hasNext()) {
                SourceFile source = (SourceFile)iterSource.next();
                File file = source.getFile();
                String charSet = source.getCharacterSet();
                try {
                    FileInputStream in = new FileInputStream(file);
                    try {
                        InputStreamReader reader = charSet != null ? new InputStreamReader((InputStream)in, charSet) : new InputStreamReader(in);
                        runner.load((Reader)reader, file.getName());
                        project.log("Loaded " + file.getName(), 4);
                    }
                    catch (JsUnitException e) {
                        throw new BuildException("Cannot evaluate JavaScript code of " + file.getName(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BuildException("Cannot read complete " + file.getName(), (Throwable)e);
                    }
                    finally {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (FileNotFoundException e) {
                    throw new BuildException("Cannot find " + file.getName(), (Throwable)e);
                }
            }
            JsUnitSuite suite = (JsUnitSuite)iterTest.next();
            System.out.println("Run suite " + suite.getName());
            suite.run(project, runner);
            errors += suite.getErrors();
            failures += suite.getFailures();
        }
        if (errors + failures > 0) {
            String msg = "There have been " + errors + " errors and " + failures + " failures testing JavaScript";
            if (errors > 0 && this.isHaltOnError() || this.isHaltOnFailure()) {
                throw new BuildException(msg);
            }
            project.log(msg, 0);
        }
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public boolean isHaltOnFailure() {
        return this.haltOnFailure;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public JsUnitSuite createTestSuite() {
        JsUnitSuite suite = new JsUnitSuite();
        this.testSuites.add(suite);
        return suite;
    }

    public SourceFile createSource() {
        SourceFile source = new SourceFile();
        this.sources.add(source);
        return source;
    }

    public final class SourceFile {
        private File file;
        private String charSet;

        public void setFile(String name) {
            this.file = new File(JsUnitTask.this.dir, name);
        }

        public File getFile() {
            return this.file;
        }

        public void setCharacterSet(String characterSet) {
            this.charSet = characterSet;
        }

        public String getCharacterSet() {
            return this.charSet;
        }
    }
}

