/*
 * Decompiled with CFR 0.152.
 */
package de.berlios.jsunit.ant;

import de.berlios.jsunit.JsUnitException;
import de.berlios.jsunit.JsUnitRhinoRunner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class JsUnitSuite {
    private String name;
    private File toDir;
    private TestRunType type = new TestRunType("TESTCASES");
    private final Vector fileSets = new Vector();
    private int errors;
    private int failures;
    private String charSet;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(TestRunType type) {
        this.type = type;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void addFileSet(FileSet fileSet) {
        this.fileSets.addElement(fileSet);
    }

    public void setCharacterSet(String characterSet) {
        this.charSet = characterSet;
    }

    public String getCharacterSet() {
        return this.charSet;
    }

    public void run(Project project, JsUnitRhinoRunner runner) throws BuildException {
        OutputStreamWriter writer;
        if (!this.toDir.isDirectory()) {
            this.toDir.mkdirs();
        }
        Iterator iter = ((AbstractList)this.fileSets).iterator();
        while (iter.hasNext()) {
            FileSet fileSet = (FileSet)iter.next();
            DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(scanner.getBasedir(), files[i]);
                try {
                    FileInputStream in = new FileInputStream(file);
                    try {
                        InputStreamReader reader = this.charSet != null ? new InputStreamReader((InputStream)in, this.charSet) : new InputStreamReader(in);
                        runner.load((Reader)reader, files[i]);
                        project.log("Loaded " + file.getPath(), 4);
                        continue;
                    }
                    catch (JsUnitException e) {
                        throw new BuildException("Cannot evaluate JavaScript code of " + file.getPath(), (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new BuildException("Cannot read complete " + file.getPath(), (Throwable)e);
                    }
                    finally {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (FileNotFoundException e) {
                    throw new BuildException("Cannot find " + file.getPath(), (Throwable)e);
                }
            }
        }
        File file = new File(this.toDir, "TEST-" + this.name + ".xml");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            writer = new OutputStreamWriter(new TeeOutputStream(new FileOutputStream(file), baos));
        }
        catch (IOException e) {
            throw new BuildException("Cannot create file " + file.getName(), (Throwable)e);
        }
        try {
            switch (this.type.getIndex()) {
                case 0: {
                    runner.runAllTests((Writer)writer);
                    break;
                }
                case 1: {
                    runner.runTestSuites((Writer)writer, this.name);
                    break;
                }
                case 2: {
                    runner.runTestCases((Writer)writer, this.name);
                }
            }
            project.log("Created test report " + file.getName(), 4);
        }
        catch (JsUnitException e) {
            throw new BuildException("Cannot run JavaScript code of test suite " + this.name, (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Cannot write to file " + file.getName(), (Throwable)e);
        }
        finally {
            FileUtils.close((Writer)writer);
        }
        String[] lines = StringUtils.lineSplit((String)baos.toString()).toArray(new String[0]);
        int idx = lines[1].indexOf("errors=\"") + 8;
        this.errors = Integer.parseInt(lines[1].substring(idx, lines[1].indexOf(34, idx)));
        idx = lines[1].indexOf("failures=\"") + 10;
        this.failures = Integer.parseInt(lines[1].substring(idx, lines[1].indexOf(34, idx)));
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFailures() {
        return this.failures;
    }

    private static class TeeOutputStream
    extends FilterOutputStream {
        private final OutputStream tee;

        TeeOutputStream(OutputStream out, OutputStream tee) {
            super(out);
            this.tee = tee;
        }

        public void close() throws IOException {
            super.close();
            this.tee.close();
        }

        public void flush() throws IOException {
            super.flush();
            this.tee.flush();
        }

        public void write(int b) throws IOException {
            super.write(b);
            this.tee.write(b);
        }
    }

    public static final class TestRunType
    extends EnumeratedAttribute {
        public TestRunType() {
        }

        TestRunType(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{"ALLTESTS", "TESTSUITES", "TESTCASES"};
        }
    }
}

