/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.statements.builder;

import de.bechte.junit.runners.context.statements.builder.MethodStatementBuilder;
import de.bechte.junit.runners.context.statements.builder.rules.TestRuleDefinitions;
import de.bechte.junit.runners.model.TestClassPool;
import de.bechte.junit.runners.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.Rule;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalRunRulesStatementBuilder
implements MethodStatementBuilder {
    @Override
    public Statement createStatement(TestClass testClass, FrameworkMethod method, Object target, Statement next, Description description, RunNotifier notifier) {
        try {
            TestRuleDefinitions testRules = new TestRuleDefinitions(this.hierarchyOfTestsFromLowestToHighest(target));
            Object instance = target;
            while (instance != null) {
                TestClass instanceTestClass = TestClassPool.forClass(instance.getClass());
                testRules.addTestRules(instanceTestClass.getAnnotatedMethodValues(instance, Rule.class, TestRule.class), instance);
                testRules.addTestRules(instanceTestClass.getAnnotatedFieldValues(instance, Rule.class, TestRule.class), instance);
                testRules.addMethodRules(instanceTestClass.getAnnotatedFieldValues(instance, Rule.class, MethodRule.class), instance);
                instance = ReflectionUtil.getEnclosingInstance(instance);
            }
            Statement statement = next;
            Object hierarchyContext = target;
            while (hierarchyContext != null) {
                for (MethodRule methodRule : testRules.getMethodRulesDefinedForThisHierarchyLevel(hierarchyContext)) {
                    if (testRules.contains(methodRule)) continue;
                    statement = methodRule.apply(statement, method, hierarchyContext);
                }
                if (testRules.testRulesPresent()) {
                    statement = new RunRules(statement, testRules.getTestRulesDefinedForThisHierarchyLevel(hierarchyContext), description);
                }
                hierarchyContext = ReflectionUtil.getEnclosingInstance(hierarchyContext);
            }
            return statement;
        }
        catch (IllegalAccessException e) {
            return new Fail((Throwable)e);
        }
    }

    private List<Object> hierarchyOfTestsFromLowestToHighest(Object target) throws IllegalAccessException {
        ArrayList<Object> result = new ArrayList<Object>();
        Object instance = target;
        while (instance != null) {
            result.add(instance);
            instance = ReflectionUtil.getEnclosingInstance(instance);
        }
        return result;
    }
}

