/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.statements.builder;

import de.bechte.junit.runners.context.statements.builder.MethodStatementBuilder;
import de.bechte.junit.runners.model.TestClassPool;
import de.bechte.junit.runners.util.ReflectionUtil;
import java.util.List;
import org.junit.Before;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class HierarchicalRunBeforeStatementBuilder
implements MethodStatementBuilder {
    public Statement createStatement(TestClass testClass, FrameworkMethod method, Object target, Statement next, Description description, RunNotifier notifier) {
        Statement statement = next;
        try {
            Object instance = target;
            while (instance != null) {
                TestClass instanceTestClass = TestClassPool.forClass(instance.getClass());
                List beforeMethods = instanceTestClass.getAnnotatedMethods(Before.class);
                statement = beforeMethods.isEmpty() ? statement : new RunBefores(statement, beforeMethods, instance);
                instance = ReflectionUtil.getEnclosingInstance(instance);
            }
        }
        catch (IllegalAccessException e) {
            statement = new Fail((Throwable)e);
        }
        return statement;
    }
}

