/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.util.uunecode;

import de.audioattack.util.uunecode.AsciiConverter;
import de.audioattack.util.uunecode.EncodingBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UUEncoderStream
extends OutputStream {
    private static final int LENGTH = 45;
    private static final Charset ASCII = StandardCharsets.US_ASCII;
    private static final byte[] NEWLINE = System.lineSeparator().getBytes(ASCII);
    private static final String HEADER = "begin %d %s" + System.lineSeparator();
    private static final byte[] END = ("`" + System.lineSeparator() + "end" + System.lineSeparator()).getBytes(ASCII);
    private final EncodingBuffer encodingBuffer = new EncodingBuffer();
    private final OutputStream outputStream;
    private final char[] outputBuffer = new char[60];
    private int countEncBytes;
    private int countRawBytes;

    public UUEncoderStream(OutputStream outputStream, int mode, String filename) throws IOException {
        this.outputStream = outputStream;
        outputStream.write(this.createHeader(mode, filename));
    }

    private byte[] createHeader(int mode, String filename) {
        return String.format(HEADER, mode, filename).getBytes(ASCII);
    }

    @Override
    public void write(int i) throws IOException {
        ++this.countRawBytes;
        if (this.encodingBuffer.add((byte)i)) {
            this.copyEncodedBytesToOutputBuffer();
            if (this.countRawBytes == 45) {
                this.write();
                this.countEncBytes = 0;
                this.countRawBytes = 0;
            }
        }
    }

    private void copyEncodedBytesToOutputBuffer() {
        for (byte b : this.encodingBuffer.getResult()) {
            this.outputBuffer[this.countEncBytes++] = AsciiConverter.toChar(b);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.encodingBuffer.flush()) {
            this.copyEncodedBytesToOutputBuffer();
            this.write();
        }
        this.countEncBytes = 0;
        this.countRawBytes = 0;
        this.writeFooter();
        this.outputStream.flush();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.outputStream.close();
        super.close();
    }

    private void writeFooter() throws IOException {
        this.outputStream.write(END);
    }

    private void write() throws IOException {
        this.outputStream.write((byte)AsciiConverter.toChar((byte)this.countRawBytes));
        this.outputStream.write(new String(this.outputBuffer).getBytes(ASCII), 0, this.countEncBytes);
        this.outputStream.write(NEWLINE);
    }
}

