/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.util.uunecode;

import de.audioattack.util.uunecode.AsciiConverter;
import de.audioattack.util.uunecode.DecodingBuffer;
import de.audioattack.util.uunecode.LineBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class UUDecoderStream
extends OutputStream {
    private byte length;
    private static final char[] LINE_END_CHARS = "\n\r".toCharArray();
    private static final char[] MARKER_START = "begin".toCharArray();
    private static final String MARKER_END = "end";
    private final LineBuffer lineBuffer = new LineBuffer(255);
    private final DecodingBuffer decodingBuffer = new DecodingBuffer();
    private final OutputStream outputStream;
    private Integer mode;
    private String filename;
    private byte lineLength;
    private State state = State.WAIT_FOR_HEADER;

    public UUDecoderStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(int i) throws IOException {
        char c = (char)i;
        if (UUDecoderStream.isEndCharacter(c) && this.state == State.WAIT_FOR_HEADER && this.lineBuffer.startsWith(MARKER_START)) {
            String[] h = this.lineBuffer.toString().split("\\s+");
            if (h.length != 3) throw new IllegalArgumentException("No valid header.");
            this.mode = Integer.parseInt(h[1].trim());
            this.filename = h[2].trim();
            this.state = State.IN_BODY;
            this.lineBuffer.clear();
        } else if (this.state == State.IN_BODY && this.lineBuffer.length() == this.lineLength) {
            for (int j = 0; j < this.lineBuffer.length(); ++j) {
                if (!this.decodingBuffer.add(AsciiConverter.toByte(this.lineBuffer.charAt(j)))) continue;
                this.length = (byte)(this.length - 3);
                if (this.length < 0) {
                    this.outputStream.write(this.decodingBuffer.getResult(), 0, 3 + this.length);
                    continue;
                }
                this.outputStream.write(this.decodingBuffer.getResult());
            }
            this.lineLength = 0;
            this.lineBuffer.clear();
        } else if (this.state == State.END && this.lineBuffer.toString().trim().equals(MARKER_END)) {
            this.close();
        }
        if (this.state == State.WAIT_FOR_HEADER || this.state == State.END) {
            this.lineBuffer.append(c);
            return;
        } else {
            if (this.state != State.IN_BODY || !UUDecoderStream.isLegalCharacter(c)) return;
            if (this.lineLength == 0) {
                this.length = AsciiConverter.toByte(c);
                this.lineLength = (byte)(this.length / 3 * 4 + (this.length % 3 == 0 ? 0 : 4));
                if (this.lineLength != 0) return;
                this.state = State.END;
                return;
            } else {
                this.lineBuffer.append(c);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.decodingBuffer.flush()) {
            this.outputStream.write(this.decodingBuffer.getResult());
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.outputStream.close();
        super.close();
    }

    public Integer getMode() {
        return this.mode;
    }

    public String getFilename() {
        return this.filename;
    }

    private static boolean isEndCharacter(char c) {
        return Arrays.binarySearch(LINE_END_CHARS, c) >= 0;
    }

    private static boolean isLegalCharacter(char c) {
        return c >= '!' && c <= 'a';
    }

    static {
        Arrays.sort(LINE_END_CHARS);
    }

    private static enum State {
        WAIT_FOR_HEADER,
        IN_BODY,
        END;

    }
}

