/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.util.uunecode;

import java.util.Arrays;

class LineBuffer {
    private final char[] buffer;
    private int pointer = -1;

    public LineBuffer(int size) {
        this.buffer = new char[size];
    }

    public void append(char c) {
        this.buffer[++this.pointer] = c;
    }

    public int length() {
        return this.pointer + 1;
    }

    public boolean isEmpty() {
        return this.pointer == -1;
    }

    public void clear() {
        this.pointer = -1;
    }

    public char charAt(int i) {
        if (i > this.pointer) {
            throw new IndexOutOfBoundsException("Index must be lower than length: " + i + " " + this.length());
        }
        return this.buffer[i];
    }

    public boolean startsWith(char[] chars) {
        return this.indexOf(chars) == 0;
    }

    public int indexOf(char[] chars) {
        if (chars.length > this.length()) {
            return -1;
        }
        int result = -1;
        for (int i = 0; i < this.length(); ++i) {
            if (this.buffer[i] != chars[0]) continue;
            for (int j = 0; j < chars.length; ++j) {
                if (this.buffer[i + j] != chars[j]) {
                    result = -1;
                    break;
                }
                result = i;
            }
            return result;
        }
        return result;
    }

    public String toString() {
        return new String(Arrays.copyOfRange(this.buffer, 0, this.pointer + 1));
    }
}

