/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.util.uunecode;

import java.util.Arrays;

class EncodingBuffer {
    private final byte[] inBuffer = new byte[3];
    private final byte[] outBuffer = new byte[4];
    private int count;

    EncodingBuffer() {
    }

    boolean add(byte b) {
        this.inBuffer[this.count++] = b;
        if (this.count == this.inBuffer.length) {
            this.count = 0;
            this.encode();
        }
        return this.count == 0;
    }

    private void encode() {
        int val = this.inBuffer[0] << 16 | this.inBuffer[1] << 8 | this.inBuffer[2];
        this.outBuffer[0] = (byte)(val >> 18 & 0x3F);
        this.outBuffer[1] = (byte)(val >> 12 & 0x3F);
        this.outBuffer[2] = (byte)(val >> 6 & 0x3F);
        this.outBuffer[3] = (byte)(val & 0x3F);
    }

    byte[] getResult() {
        return Arrays.copyOf(this.outBuffer, this.outBuffer.length);
    }

    boolean flush() {
        if (this.count == 0) {
            return false;
        }
        while (!this.add((byte)0)) {
        }
        return true;
    }
}

