/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.util.uunecode;

import java.util.Arrays;

class DecodingBuffer {
    private final byte[] inBuffer = new byte[4];
    private final byte[] outBuffer = new byte[3];
    private int count;

    DecodingBuffer() {
    }

    boolean add(byte character) {
        this.inBuffer[this.count++] = character;
        if (this.count == this.inBuffer.length) {
            this.count = 0;
            this.decode();
        }
        return this.count == 0;
    }

    private void decode() {
        int val = this.inBuffer[0] << 18 | this.inBuffer[1] << 12 | this.inBuffer[2] << 6 | this.inBuffer[3];
        this.outBuffer[0] = (byte)(val >> 16 & 0xFF);
        this.outBuffer[1] = (byte)(val >> 8 & 0xFF);
        this.outBuffer[2] = (byte)(val & 0xFF);
    }

    byte[] getResult() {
        return Arrays.copyOf(this.outBuffer, this.outBuffer.length);
    }

    boolean flush() {
        if (this.count == 0) {
            return false;
        }
        while (!this.add((byte)0)) {
        }
        return true;
    }
}

