/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.io;

import de.audioattack.io.CharacterDevice;
import de.audioattack.io.Console;
import de.audioattack.io.ConsoleDevice;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public final class ConsoleCreator {
    private static final Console CONSOLE = System.console() == null ? ConsoleCreator.createCharacterDevice() : new ConsoleDevice(System.console());

    private ConsoleCreator() {
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="This seems to be a false positive in Spotbugs, see: https://github.com/spotbugs/spotbugs/issues/1747")
    public static Console console() {
        return CONSOLE;
    }

    private static Console createCharacterDevice() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), true);
        return new CharacterDevice(reader, writer);
    }
}

