/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.io;

import de.audioattack.io.Console;
import java.io.Flushable;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Locale;
import java.util.Objects;

public class ConsolePrintDecorator
implements Console,
Flushable,
Appendable {
    private final Console console;
    private final PrintWriter writer;

    public ConsolePrintDecorator(Console console) {
        this.console = Objects.requireNonNull(console, "console must not be <null>");
        this.writer = console.writer();
    }

    @Override
    public Reader reader() {
        return this.console.reader();
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public ConsolePrintDecorator format(String fmt, Object ... args) {
        this.console.format(fmt, args);
        return this;
    }

    public ConsolePrintDecorator format(Locale locale, String fmt, Object ... args) {
        this.writer.format(locale, fmt, args);
        return this;
    }

    public void print(boolean b) {
        this.print(Boolean.toString(b));
    }

    public void print(char c) {
        this.print(Character.toString(c));
    }

    public void print(char[] s) {
        this.print(new String(s));
    }

    public void print(double d) {
        this.print(Double.toString(d));
    }

    public void print(float f) {
        this.print(Float.toString(f));
    }

    public void print(int i) {
        this.print(Integer.toString(i));
    }

    public void print(long l) {
        this.print(Long.toString(l));
    }

    public void print(Object o) {
        this.print(Objects.toString(o));
    }

    public void print(String s) {
        this.writer.print(s);
        this.writer.flush();
    }

    public ConsolePrintDecorator printf(Locale locale, String fmt, Object ... args) {
        this.format(locale, fmt, args);
        return this;
    }

    @Override
    public ConsolePrintDecorator printf(String fmt, Object ... args) {
        this.console.printf(fmt, args);
        return this;
    }

    public void println() {
        this.writer.println();
    }

    public void println(boolean b) {
        this.println(Boolean.toString(b));
    }

    public void println(char c) {
        this.println(Character.toString(c));
    }

    public void println(char[] s) {
        this.println(new String(s));
    }

    public void println(double d) {
        this.println(Double.toString(d));
    }

    public void println(float f) {
        this.println(Float.toString(f));
    }

    public void println(int i) {
        this.println(Integer.toString(i));
    }

    public void println(long l) {
        this.println(Long.toString(l));
    }

    public void println(Object o) {
        this.println(Objects.toString(o));
    }

    public void println(String s) {
        this.writer.println(s);
    }

    @Override
    public String readLine(String fmt, Object ... args) {
        return this.console.readLine(fmt, args);
    }

    @Override
    public String readLine() {
        return this.console.readLine();
    }

    @Override
    public char[] readPassword(String fmt, Object ... args) {
        return this.console.readPassword(fmt, args);
    }

    @Override
    public char[] readPassword() {
        return this.console.readPassword();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public ConsolePrintDecorator append(CharSequence charSequence) {
        this.writer.append(charSequence);
        return this;
    }

    @Override
    public ConsolePrintDecorator append(CharSequence charSequence, int start, int end) {
        this.writer.append(charSequence, start, end);
        return this;
    }

    @Override
    public ConsolePrintDecorator append(char c) {
        this.writer.append(c);
        return this;
    }

    public boolean checkError() {
        return this.writer.checkError();
    }
}

