/*
 * Decompiled with CFR 0.152.
 */
package de.audioattack.io;

import de.audioattack.io.Console;
import de.audioattack.io.UncloseablePrintWriter;
import de.audioattack.io.UncloseableReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Objects;

class CharacterDevice
implements Console {
    private final BufferedReader reader;
    private final UncloseableReader uncloseableReader;
    private final PrintWriter writer;
    private final UncloseablePrintWriter uncloseableWriter;

    CharacterDevice(BufferedReader reader, PrintWriter writer) {
        this.reader = Objects.requireNonNull(reader, "reader must not be <null>");
        this.writer = Objects.requireNonNull(writer, "writer must not be <null>");
        this.uncloseableReader = new UncloseableReader(reader);
        this.uncloseableWriter = new UncloseablePrintWriter(writer);
    }

    @Override
    public Reader reader() {
        return this.uncloseableReader;
    }

    @Override
    public PrintWriter writer() {
        return this.uncloseableWriter;
    }

    @Override
    public Console format(String fmt, Object ... args) {
        this.writer.format(fmt, args);
        this.flush();
        return this;
    }

    @Override
    public Console printf(String fmt, Object ... args) {
        return this.format(fmt, args);
    }

    @Override
    public String readLine(String fmt, Object ... args) {
        this.format(fmt, args);
        return this.readLine();
    }

    @Override
    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public char[] readPassword(String fmt, Object ... args) {
        this.format("WARNING! Password will be visible in the command line!%n", new Object[0]);
        return CharacterDevice.toCharArray(this.readLine(fmt, args));
    }

    @Override
    public char[] readPassword() {
        return this.readPassword("", new Object[0]);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    private static char[] toCharArray(String readLine) {
        return readLine == null ? null : readLine.toCharArray();
    }
}

