/*
 * SPDX-FileCopyrightText: 2018 Marc Nause <marc.nause@gmx.de>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

package de.audioattack.io;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;

/**
 * Creates an implementation of {@link Console} which is based on
 * {@link java.io.Console} or which provides a fallback implementation if no
 * Console is available.
 */
public final class ConsoleCreator {

    private static final Console CONSOLE = System.console() == null ? createCharacterDevice()
            : new ConsoleDevice(System.console());

    private ConsoleCreator() {
    }

    /**
     * Gets an implementation of {@link Console}. Implementation based on
     * {@link java.io.Console} is preferred.
     *
     * @return the console
     */
    public static Console console() {
        return CONSOLE;
    }

    @SuppressWarnings("squid:S106")
    private static Console createCharacterDevice() {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        final PrintWriter writer = new PrintWriter(new OutputStreamWriter(System.out, Charset.defaultCharset()));
        return new CharacterDevice(reader, writer);
    }
}
