/*
 * Decompiled with CFR 0.152.
 */
package de.atextor.turtle.formatter;

import de.atextor.turtle.formatter.FormattingStyle;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleFormatter
implements Function<Model, String>,
BiConsumer<Model, OutputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(TurtleFormatter.class);
    public static final String OUTPUT_ERROR_MESSAGE = "Could not write to stream";
    private final FormattingStyle style;
    private final String beforeDot;
    private final String endOfLine;
    private final Charset encoding;
    private final Comparator<Tuple2<String, String>> prefixOrder;
    private final Comparator<RDFNode> objectOrder;

    public TurtleFormatter(FormattingStyle style) {
        Charset charset;
        String string;
        String string2;
        this.style = style;
        switch (style.endOfLine) {
            case CR: {
                string2 = "\r";
                break;
            }
            case LF: {
                string2 = "\n";
                break;
            }
            case CRLF: {
                string2 = "\r\n";
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        this.endOfLine = string2;
        switch (style.beforeDot) {
            case SPACE: {
                string = " ";
                break;
            }
            case NOTHING: {
                string = "";
                break;
            }
            case NEWLINE: {
                string = this.endOfLine;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        this.beforeDot = string;
        switch (style.charset) {
            case UTF_8: 
            case UTF_8_BOM: {
                charset = StandardCharsets.UTF_8;
                break;
            }
            case LATIN1: {
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            case UTF_16_BE: {
                charset = StandardCharsets.UTF_16BE;
                break;
            }
            case UTF_16_LE: {
                charset = StandardCharsets.UTF_16LE;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        this.encoding = charset;
        this.prefixOrder = Comparator.comparingInt(entry -> style.prefixOrder.contains(entry._1()) ? style.prefixOrder.indexOf(entry._1()) : Integer.MAX_VALUE).thenComparing(Tuple2::_1);
        this.objectOrder = Comparator.comparingInt(object -> style.objectOrder.contains(object) ? style.objectOrder.indexOf(object) : Integer.MAX_VALUE).thenComparing(RDFNode::toString);
    }

    private static io.vavr.collection.List<Statement> statements(Model model) {
        return io.vavr.collection.List.ofAll((Iterable)model.listStatements().toList());
    }

    private static io.vavr.collection.List<Statement> statements(Model model, Property predicate, RDFNode object) {
        return io.vavr.collection.List.ofAll((Iterable)model.listStatements(null, predicate, object).toList());
    }

    @Override
    public String apply(Model model) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.accept(model, outputStream);
        return outputStream.toString();
    }

    private void writeByteOrderMark(OutputStream outputStream) {
        try {
            outputStream.write(new byte[]{-17, -69, -65});
        }
        catch (IOException exception) {
            LOG.error(OUTPUT_ERROR_MESSAGE, (Throwable)exception);
        }
    }

    @Override
    public void accept(Model model, OutputStream outputStream) {
        if (this.style.charset == FormattingStyle.Charset.UTF_8_BOM) {
            this.writeByteOrderMark(outputStream);
        }
        PrefixMapping prefixMapping = this.buildPrefixMapping(model);
        Comparator<Property> predicateOrder = Comparator.comparingInt(property -> this.style.predicateOrder.contains(property) ? this.style.predicateOrder.indexOf(property) : Integer.MAX_VALUE).thenComparing(property -> prefixMapping.shortForm(property.getURI()));
        State initialState = (State)Stream.ofAll(this.anonymousResourcesThatNeedAnId(model)).zipWithIndex().map(entry -> new Tuple2((Object)((Resource)entry._1()), (Object)this.style.anonymousNodeIdGenerator.apply((Resource)entry._1(), (Integer)entry._2()))).foldLeft((Object)new State(outputStream, model, predicateOrder, prefixMapping), (state, entry) -> state.withIdentifiedAnonymousResource((Resource)entry._1(), (String)entry._2()));
        State prefixesWritten = this.writePrefixes(initialState);
        Comparator<Statement> subjectComparator = Comparator.comparing(statement -> statement.getSubject().isURIResource() ? prefixMapping.shortForm(statement.getSubject().getURI()) : statement.getSubject().toString());
        io.vavr.collection.List wellKnownSubjects = io.vavr.collection.List.ofAll(this.style.subjectOrder).flatMap(subjectType -> TurtleFormatter.statements(model, RDF.type, (RDFNode)subjectType).sorted(subjectComparator));
        io.vavr.collection.List otherSubjects = TurtleFormatter.statements(model).filter(statement -> !statement.getPredicate().equals(RDF.type) || !statement.getObject().isResource() || !this.style.subjectOrder.contains(statement.getObject().asResource())).sorted(subjectComparator);
        io.vavr.collection.List statements = wellKnownSubjects.appendAll((Iterable)otherSubjects).filter(statement -> !statement.getSubject().isAnon() || !model.contains(null, null, (RDFNode)statement.getSubject()));
        State namedResourcesWritten = (State)statements.map(Statement::getSubject).foldLeft((Object)prefixesWritten, (state, resource) -> {
            if (!resource.listProperties().hasNext() || state.visitedResources.contains(resource)) {
                return state;
            }
            if (resource.isURIResource()) {
                return this.writeSubject((Resource)resource, state.withIndentationLevel(0));
            }
            State resourceWritten = this.writeAnonymousResource((Resource)resource, state.withIndentationLevel(0));
            boolean omitSpaceBeforeDelimiter = !state.identifiedAnonymousResources.keySet().contains(resource);
            return this.writeDot(resourceWritten, omitSpaceBeforeDelimiter).newLine();
        });
        State allResourcesWritten = (State)io.vavr.collection.List.ofAll((Iterable)namedResourcesWritten.identifiedAnonymousResources.keySet()).foldLeft((Object)namedResourcesWritten, (state, resource) -> {
            if (!resource.listProperties().hasNext()) {
                return state;
            }
            return this.writeSubject((Resource)resource, state.withIndentationLevel(0));
        });
        State finalState = this.style.insertFinalNewline ? allResourcesWritten.newLine() : allResourcesWritten;
        LOG.debug("Written {} resources, with {} named anonymous resources", (Object)finalState.visitedResources.size(), (Object)finalState.identifiedAnonymousResources.size());
    }

    private Set<Resource> anonymousResourcesThatNeedAnId(Model model) {
        return io.vavr.collection.List.ofAll(() -> ((Model)model).listObjects()).filter(RDFNode::isResource).map(RDFNode::asResource).filter(RDFNode::isAnon).filter(object -> TurtleFormatter.statements(model, null, (RDFNode)object).toList().size() > 1).toSet();
    }

    private PrefixMapping buildPrefixMapping(Model model) {
        Map prefixMap = Stream.ofAll(this.style.knownPrefixes).filter(knownPrefix -> model.getNsPrefixURI(knownPrefix.getPrefix()) == null).toMap(FormattingStyle.KnownPrefix::getPrefix, knownPrefix -> knownPrefix.getIri().toString());
        return PrefixMapping.Factory.create().setNsPrefixes(model.getNsPrefixMap()).setNsPrefixes(prefixMap.toJavaMap());
    }

    private State writePrefixes(State state) {
        String string;
        HashMap prefixes = HashMap.ofAll((java.util.Map)state.prefixMapping.getNsPrefixMap());
        int maxPrefixLength = (Integer)prefixes.keySet().map(String::length).max().getOrElse((Object)0);
        switch (this.style.alignPrefixes) {
            case OFF: {
                string = "@prefix %s: <%s>" + this.beforeDot + ".%n";
                break;
            }
            case LEFT: {
                string = "@prefix %-" + maxPrefixLength + "s: <%s>" + this.beforeDot + ".%n";
                break;
            }
            case RIGHT: {
                string = "@prefix %" + maxPrefixLength + "s: <%s>" + this.beforeDot + ".%n";
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        String prefixFormat = string;
        io.vavr.collection.List<String> urisInModel = this.allUsedUris(state.model);
        State prefixesWritten = (State)prefixes.toStream().sorted(this.prefixOrder).filter(entry -> this.style.keepUnusedPrefixes || urisInModel.find(resource -> resource.startsWith((String)entry._2())).isDefined()).foldLeft((Object)state, (newState, entry) -> newState.write(String.format(prefixFormat, entry._1(), entry._2())));
        return prefixesWritten.newLine();
    }

    private io.vavr.collection.List<String> allUsedUris(Model model) {
        return io.vavr.collection.List.ofAll(() -> ((Model)model).listStatements()).flatMap(statement -> io.vavr.collection.List.of((Object[])new RDFNode[]{statement.getSubject(), statement.getPredicate(), statement.getObject()})).map(rdfNode -> {
            if (rdfNode.isURIResource()) {
                return Option.of((Object)rdfNode.asResource().getURI());
            }
            if (rdfNode.isLiteral()) {
                return Option.of((Object)rdfNode.asLiteral().getDatatypeURI());
            }
            return Option.none();
        }).filter(Option::isDefined).map(Option::get);
    }

    private String indent(int level) {
        String string;
        switch (this.style.indentStyle) {
            case SPACE: {
                string = " ".repeat(this.style.indentSize);
                break;
            }
            case TAB: {
                string = "\t";
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        String singleIndent = string;
        return singleIndent.repeat(Math.max(level, 0));
    }

    private String continuationIndent(int level) {
        String string;
        switch (this.style.indentStyle) {
            case SPACE: {
                string = " ".repeat(this.style.continuationIndentSize);
                break;
            }
            case TAB: {
                string = "\t".repeat(2);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        String continuation = string;
        return this.indent(level - 1) + continuation;
    }

    private State writeDelimiter(String delimiter, FormattingStyle.GapStyle before, FormattingStyle.GapStyle after, String indentation, State state) {
        State state2;
        State state3;
        switch (before) {
            case SPACE: {
                state3 = state.write(" ");
                break;
            }
            case NOTHING: {
                state3 = state;
                break;
            }
            case NEWLINE: {
                state3 = state.newLine().write(indentation);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        State beforeState = state3;
        switch (after) {
            case SPACE: {
                state2 = beforeState.write(delimiter + " ");
                break;
            }
            case NOTHING: {
                state2 = beforeState.write(delimiter);
                break;
            }
            case NEWLINE: {
                state2 = beforeState.write(delimiter).newLine().write(indentation);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return state2;
    }

    private State writeComma(State state) {
        return this.writeDelimiter(",", this.style.beforeComma, this.style.afterComma, this.continuationIndent(state.indentationLevel), state);
    }

    private State writeSemicolon(State state, boolean omitLineBreak, boolean omitSpaceBeforeSemicolon, String nextLineIndentation) {
        FormattingStyle.GapStyle beforeSemicolon = omitSpaceBeforeSemicolon ? FormattingStyle.GapStyle.NOTHING : this.style.beforeSemicolon;
        FormattingStyle.GapStyle afterSemicolon = omitLineBreak ? FormattingStyle.GapStyle.NOTHING : this.style.afterSemicolon;
        return this.writeDelimiter(";", beforeSemicolon, afterSemicolon, nextLineIndentation, state);
    }

    private State writeDot(State state, boolean omitSpaceBeforeDot) {
        FormattingStyle.GapStyle beforeDot = omitSpaceBeforeDot ? FormattingStyle.GapStyle.NOTHING : this.style.beforeDot;
        return this.writeDelimiter(".", beforeDot, this.style.afterDot, "", state);
    }

    private State writeOpeningSquareBracket(State state) {
        FormattingStyle.GapStyle beforeBracket = state.indentationLevel > 0 ? this.style.beforeOpeningSquareBracket : FormattingStyle.GapStyle.NOTHING;
        return this.writeDelimiter("[", beforeBracket, this.style.afterOpeningSquareBracket, this.indent(state.indentationLevel), state);
    }

    private State writeClosingSquareBracket(State state) {
        return this.writeDelimiter("]", this.style.beforeClosingSquareBracket, this.style.afterClosingSquareBracket, this.indent(state.indentationLevel), state);
    }

    private boolean isList(RDFNode node, State state) {
        return node.equals(RDF.nil) || node.isResource() && state.model.contains(node.asResource(), RDF.rest, (RDFNode)null);
    }

    private State writeResource(Resource resource, State state) {
        if (this.isList((RDFNode)resource, state)) {
            return this.writeList(resource, state);
        }
        if (resource.isURIResource()) {
            return this.writeUriResource(resource, state);
        }
        return this.writeAnonymousResource(resource, state);
    }

    private State writeList(Resource resource, State state) {
        State opened = this.writeDelimiter("(", this.style.beforeOpeningParenthesis, this.style.afterOpeningParenthesis, this.continuationIndent(state.indentationLevel), state);
        List elementList = ((RDFList)resource.as(RDFList.class)).asJavaList();
        State elementsWritten = (State)io.vavr.collection.List.ofAll((Iterable)elementList).zipWithIndex().foldLeft((Object)opened, (currentState, indexedElement) -> {
            RDFNode element = (RDFNode)indexedElement._1();
            int index = (Integer)indexedElement._2();
            boolean firstElement = index == 0;
            State spaceWritten = firstElement ? currentState : currentState.write(" ");
            return this.writeRdfNode(element, spaceWritten);
        });
        return this.writeDelimiter(")", this.style.beforeClosingParenthesis, this.style.afterClosingParenthesis, this.continuationIndent(state.indentationLevel), elementsWritten);
    }

    private State writeAnonymousResource(Resource resource, State state) {
        if (state.identifiedAnonymousResources.keySet().contains((Object)resource)) {
            return state.write((String)state.identifiedAnonymousResources.getOrElse((Object)resource, (Object)""));
        }
        if (!state.model.contains(resource, null, (RDFNode)null)) {
            return state.write(" []");
        }
        if (state.visitedResources.contains((Object)resource)) {
            return state;
        }
        State afterOpeningSquareBracket = this.writeOpeningSquareBracket(state);
        State afterContent = this.writeSubject(resource, afterOpeningSquareBracket);
        return this.writeClosingSquareBracket(afterContent).withVisitedResource(resource);
    }

    private String uriResource(Resource resource, State state) {
        if (resource.getURI().equals(RDF.type.getURI()) && this.style.useAForRdfType) {
            return "a";
        }
        String uri = resource.getURI();
        String shortForm = state.prefixMapping.shortForm(uri);
        return shortForm.equals(uri) ? "<" + uri + ">" : shortForm;
    }

    private State writeUriResource(Resource resource, State state) {
        return state.write(this.uriResource(resource, state));
    }

    private State writeLiteral(Literal literal, State state) {
        if (literal.getDatatypeURI().equals(XSD.xboolean.getURI())) {
            return state.write(literal.getBoolean() ? "true" : "false");
        }
        if (literal.getDatatypeURI().equals(XSD.xstring.getURI())) {
            return state.write("\"" + literal.getValue().toString() + "\"");
        }
        if (literal.getDatatypeURI().equals(XSD.decimal.getURI())) {
            return state.write(literal.getLexicalForm());
        }
        if (literal.getDatatypeURI().equals(XSD.integer.getURI())) {
            return state.write(literal.getValue().toString());
        }
        if (literal.getDatatypeURI().equals(XSD.xdouble.getURI())) {
            return state.write(this.style.doubleFormat.format(literal.getDouble()));
        }
        if (literal.getDatatypeURI().equals(RDF.langString.getURI())) {
            return state.write("\"" + literal.getLexicalForm() + "\"@" + literal.getLanguage());
        }
        Resource typeResource = ResourceFactory.createResource((String)literal.getDatatypeURI());
        State literalWritten = state.write("\"" + literal.getLexicalForm() + "\"^^");
        return this.writeUriResource(typeResource, literalWritten);
    }

    private State writeRdfNode(RDFNode node, State state) {
        if (node.isResource()) {
            return this.writeResource(node.asResource(), state);
        }
        if (node.isLiteral()) {
            return this.writeLiteral(node.asLiteral(), state);
        }
        return state;
    }

    private State writeProperty(Property property, State state) {
        return this.writeUriResource((Resource)property, state);
    }

    private State writeSubject(Resource resource, State state) {
        if (state.visitedResources.contains((Object)resource)) {
            return state;
        }
        State indentedSubject = state.write(this.indent(state.indentationLevel));
        boolean isIdentifiedAnon = state.identifiedAnonymousResources.keySet().contains((Object)resource);
        State stateWithSubject = resource.isURIResource() || isIdentifiedAnon ? this.writeResource(resource, indentedSubject).withVisitedResource(resource) : indentedSubject.withVisitedResource(resource);
        State gapAfterSubject = this.style.firstPredicateInNewLine || resource.isAnon() && !isIdentifiedAnon ? stateWithSubject : stateWithSubject.write(" ");
        int predicateAlignment = this.style.firstPredicateInNewLine ? this.style.indentSize : gapAfterSubject.alignment;
        Set properties = Stream.ofAll(() -> ((Resource)resource).listProperties()).map(Statement::getPredicate).toSet();
        int maxPropertyWidth = (Integer)properties.map(property -> this.uriResource((Resource)property, state)).map(String::length).max().getOrElse((Object)0);
        return (State)Stream.ofAll((Iterable)properties).sorted(state.predicateOrder).zipWithIndex().foldLeft((Object)gapAfterSubject.addIndentationLevel(), (currentState, indexedProperty) -> {
            Property property = (Property)indexedProperty._1();
            int index = (Integer)indexedProperty._2();
            boolean firstProperty = index == 0;
            boolean lastProperty = index == properties.size() - 1;
            int propertyWidth = this.uriResource((Resource)property, (State)currentState).length();
            String gapAfterPredicate = this.style.alignObjects ? " ".repeat(maxPropertyWidth - propertyWidth + 1) : " ";
            return this.writeProperty(resource, property, firstProperty, lastProperty, predicateAlignment, gapAfterPredicate, (State)currentState);
        });
    }

    private State writeProperty(Resource subject, Property predicate, boolean firstProperty, boolean lastProperty, int alignment, String gapAfterPredicate, State state) {
        Set objects = Stream.ofAll(() -> subject.listProperties(predicate)).map(Statement::getObject).toSet();
        boolean useComma = this.style.useCommaByDefault && !this.style.noCommaForPredicate.contains(predicate) || !this.style.useCommaByDefault && this.style.commaForPredicate.contains(predicate);
        State wrappedPredicate = firstProperty && this.style.firstPredicateInNewLine && !subject.isAnon() ? state.newLine() : state;
        boolean inBrackets = subject.isAnon() && !state.identifiedAnonymousResources.keySet().contains((Object)subject);
        boolean shouldIndentFirstProperty = firstProperty && (this.style.firstPredicateInNewLine && !inBrackets || inBrackets && state.indentationLevel <= 1);
        boolean shouldIndentOtherProperty = !firstProperty && inBrackets;
        State indentedPredicate = shouldIndentFirstProperty || shouldIndentOtherProperty ? wrappedPredicate.write(this.indent(state.indentationLevel)) : wrappedPredicate;
        State predicateAlignment = !firstProperty && this.style.alignPredicates && !subject.isAnon() ? indentedPredicate.write(" ".repeat(alignment)) : indentedPredicate;
        State predicateWrittenOnce = useComma ? this.writeProperty(predicate, predicateAlignment).write(gapAfterPredicate) : predicateAlignment;
        return (State)Stream.ofAll((Iterable)objects).sorted(this.objectOrder).zipWithIndex().foldLeft((Object)predicateWrittenOnce, (currentState, indexedObject) -> {
            boolean omitSpaceBeforeDelimiter;
            RDFNode object = (RDFNode)indexedObject._1();
            int index = (Integer)indexedObject._2();
            boolean lastObject = index == objects.size() - 1;
            State predicateWritten = useComma ? currentState : this.writeProperty(predicate, (State)currentState);
            boolean isAnonWithBrackets = object.isAnon() && !predicateWritten.identifiedAnonymousResources.keySet().contains((Object)object.asResource());
            boolean isList = this.isList(object, predicateWritten);
            State spaceWritten = !isAnonWithBrackets && !isList && !useComma ? predicateWritten.write(gapAfterPredicate) : predicateWritten;
            State objectWritten = this.writeRdfNode(object, spaceWritten);
            if (useComma && !lastObject) {
                return this.writeComma(objectWritten);
            }
            boolean listWritten = isList && this.style.afterClosingParenthesis == FormattingStyle.GapStyle.NOTHING;
            boolean bl = omitSpaceBeforeDelimiter = object.isResource() && object.isAnon() && !listWritten && !currentState.identifiedAnonymousResources.keySet().contains((Object)object.asResource());
            if (lastProperty && lastObject && objectWritten.indentationLevel == 1 && !inBrackets) {
                return this.writeDot(objectWritten, omitSpaceBeforeDelimiter).newLine();
            }
            String nextLineIndentation = !(!this.style.alignPredicates && !subject.isAnon() || !subject.isAnon() && !lastObject) ? "" : this.indent(objectWritten.indentationLevel);
            State semicolonWritten = this.writeSemicolon(objectWritten, lastProperty && lastObject, omitSpaceBeforeDelimiter, nextLineIndentation);
            return subject.isAnon() && lastProperty ? semicolonWritten.removeIndentationLevel() : semicolonWritten;
        });
    }

    private final class State {
        private final OutputStream outputStream;
        private final Model model;
        private final Set<Resource> visitedResources;
        private final Map<Resource, String> identifiedAnonymousResources;
        private final Comparator<Property> predicateOrder;
        private final PrefixMapping prefixMapping;
        private final int indentationLevel;
        private final int alignment;

        public State(OutputStream outputStream, Model model, Comparator<Property> predicateOrder, PrefixMapping prefixMapping) {
            this(outputStream, model, (Set<Resource>)HashSet.empty(), (Map<Resource, String>)HashMap.empty(), predicateOrder, prefixMapping, 0, 0);
        }

        public State withIdentifiedAnonymousResource(Resource anonymousResource, String id) {
            return this.withIdentifiedAnonymousResources((Map<Resource, String>)this.identifiedAnonymousResources.put((Object)anonymousResource, (Object)id));
        }

        public State withVisitedResource(Resource visitedResource) {
            return this.withVisitedResources((Set<Resource>)this.visitedResources.add((Object)visitedResource));
        }

        public State addIndentationLevel() {
            return this.withIndentationLevel(this.indentationLevel + 1);
        }

        public State removeIndentationLevel() {
            return this.withIndentationLevel(this.indentationLevel - 1);
        }

        public State newLine() {
            return this.write(TurtleFormatter.this.endOfLine).withAlignment(0);
        }

        public State write(String content) {
            try {
                this.outputStream.write(content.getBytes(TurtleFormatter.this.encoding));
            }
            catch (IOException e) {
                LOG.error(TurtleFormatter.OUTPUT_ERROR_MESSAGE, (Throwable)e);
            }
            return this.withAlignment(this.alignment + content.length());
        }

        @Generated
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Generated
        public Model getModel() {
            return this.model;
        }

        @Generated
        public Set<Resource> getVisitedResources() {
            return this.visitedResources;
        }

        @Generated
        public Map<Resource, String> getIdentifiedAnonymousResources() {
            return this.identifiedAnonymousResources;
        }

        @Generated
        public Comparator<Property> getPredicateOrder() {
            return this.predicateOrder;
        }

        @Generated
        public PrefixMapping getPrefixMapping() {
            return this.prefixMapping;
        }

        @Generated
        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        @Generated
        public int getAlignment() {
            return this.alignment;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            OutputStream this$outputStream = this.getOutputStream();
            OutputStream other$outputStream = other.getOutputStream();
            if (this$outputStream == null ? other$outputStream != null : !this$outputStream.equals(other$outputStream)) {
                return false;
            }
            Model this$model = this.getModel();
            Model other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            Set<Resource> this$visitedResources = this.getVisitedResources();
            Set<Resource> other$visitedResources = other.getVisitedResources();
            if (this$visitedResources == null ? other$visitedResources != null : !this$visitedResources.equals(other$visitedResources)) {
                return false;
            }
            Map<Resource, String> this$identifiedAnonymousResources = this.getIdentifiedAnonymousResources();
            Map<Resource, String> other$identifiedAnonymousResources = other.getIdentifiedAnonymousResources();
            if (this$identifiedAnonymousResources == null ? other$identifiedAnonymousResources != null : !this$identifiedAnonymousResources.equals(other$identifiedAnonymousResources)) {
                return false;
            }
            Comparator<Property> this$predicateOrder = this.getPredicateOrder();
            Comparator<Property> other$predicateOrder = other.getPredicateOrder();
            if (this$predicateOrder == null ? other$predicateOrder != null : !((Object)this$predicateOrder).equals(other$predicateOrder)) {
                return false;
            }
            PrefixMapping this$prefixMapping = this.getPrefixMapping();
            PrefixMapping other$prefixMapping = other.getPrefixMapping();
            if (this$prefixMapping == null ? other$prefixMapping != null : !this$prefixMapping.equals(other$prefixMapping)) {
                return false;
            }
            if (this.getIndentationLevel() != other.getIndentationLevel()) {
                return false;
            }
            return this.getAlignment() == other.getAlignment();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OutputStream $outputStream = this.getOutputStream();
            result = result * 59 + ($outputStream == null ? 43 : $outputStream.hashCode());
            Model $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            Set<Resource> $visitedResources = this.getVisitedResources();
            result = result * 59 + ($visitedResources == null ? 43 : $visitedResources.hashCode());
            Map<Resource, String> $identifiedAnonymousResources = this.getIdentifiedAnonymousResources();
            result = result * 59 + ($identifiedAnonymousResources == null ? 43 : $identifiedAnonymousResources.hashCode());
            Comparator<Property> $predicateOrder = this.getPredicateOrder();
            result = result * 59 + ($predicateOrder == null ? 43 : $predicateOrder.hashCode());
            PrefixMapping $prefixMapping = this.getPrefixMapping();
            result = result * 59 + ($prefixMapping == null ? 43 : $prefixMapping.hashCode());
            result = result * 59 + this.getIndentationLevel();
            result = result * 59 + this.getAlignment();
            return result;
        }

        @Generated
        public String toString() {
            return "TurtleFormatter.State(outputStream=" + this.getOutputStream() + ", model=" + this.getModel() + ", visitedResources=" + this.getVisitedResources() + ", identifiedAnonymousResources=" + this.getIdentifiedAnonymousResources() + ", predicateOrder=" + this.getPredicateOrder() + ", prefixMapping=" + this.getPrefixMapping() + ", indentationLevel=" + this.getIndentationLevel() + ", alignment=" + this.getAlignment() + ")";
        }

        @Generated
        public State withOutputStream(OutputStream outputStream) {
            return this.outputStream == outputStream ? this : new State(outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.indentationLevel, this.alignment);
        }

        @Generated
        public State withModel(Model model) {
            return this.model == model ? this : new State(this.outputStream, model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.indentationLevel, this.alignment);
        }

        @Generated
        public State withVisitedResources(Set<Resource> visitedResources) {
            return this.visitedResources == visitedResources ? this : new State(this.outputStream, this.model, visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.indentationLevel, this.alignment);
        }

        @Generated
        public State withIdentifiedAnonymousResources(Map<Resource, String> identifiedAnonymousResources) {
            return this.identifiedAnonymousResources == identifiedAnonymousResources ? this : new State(this.outputStream, this.model, this.visitedResources, identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.indentationLevel, this.alignment);
        }

        @Generated
        public State withPredicateOrder(Comparator<Property> predicateOrder) {
            return this.predicateOrder == predicateOrder ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, predicateOrder, this.prefixMapping, this.indentationLevel, this.alignment);
        }

        @Generated
        public State withPrefixMapping(PrefixMapping prefixMapping) {
            return this.prefixMapping == prefixMapping ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, prefixMapping, this.indentationLevel, this.alignment);
        }

        @Generated
        public State withIndentationLevel(int indentationLevel) {
            return this.indentationLevel == indentationLevel ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, indentationLevel, this.alignment);
        }

        @Generated
        public State withAlignment(int alignment) {
            return this.alignment == alignment ? this : new State(this.outputStream, this.model, this.visitedResources, this.identifiedAnonymousResources, this.predicateOrder, this.prefixMapping, this.indentationLevel, alignment);
        }

        @Generated
        public State(OutputStream outputStream, Model model, Set<Resource> visitedResources, Map<Resource, String> identifiedAnonymousResources, Comparator<Property> predicateOrder, PrefixMapping prefixMapping, int indentationLevel, int alignment) {
            this.outputStream = outputStream;
            this.model = model;
            this.visitedResources = visitedResources;
            this.identifiedAnonymousResources = identifiedAnonymousResources;
            this.predicateOrder = predicateOrder;
            this.prefixMapping = prefixMapping;
            this.indentationLevel = indentationLevel;
            this.alignment = alignment;
        }
    }
}

