/*
 * Decompiled with CFR 0.152.
 */
package de.atextor.turtle.formatter;

import java.net.URI;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.SKOS;

public class FormattingStyle {
    public static final KnownPrefix PREFIX_FMT = new KnownPrefix("fmt", URI.create("http://purl.org/atextor/ontology/turtle-formatting#"));
    public static final KnownPrefix PREFIX_RDF = new KnownPrefix("rdf", URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    public static final KnownPrefix PREFIX_RDFS = new KnownPrefix("rdfs", URI.create("http://www.w3.org/2000/01/rdf-schema#"));
    public static final KnownPrefix PREFIX_XSD = new KnownPrefix("xsd", URI.create("http://www.w3.org/2001/XMLSchema#"));
    public static final KnownPrefix PREFIX_OWL = new KnownPrefix("owl", URI.create("http://www.w3.org/2002/07/owl#"));
    public static final KnownPrefix PREFIX_DCTERMS = new KnownPrefix("dcterms", URI.create("http://purl.org/dc/terms/"));
    public static final FormattingStyle DEFAULT = FormattingStyle.builder().build();
    public static final KnownPrefix PREFIX_VANN = new KnownPrefix("vann", URI.create("http://purl.org/vocab/vann/"));
    public static final KnownPrefix PREFIX_SKOS = new KnownPrefix("skos", URI.create(SKOS.getURI()));
    public static final KnownPrefix PREFIX_EX = new KnownPrefix("ex", URI.create("http://example.org/"));
    Set<KnownPrefix> knownPrefixes;
    GapStyle afterClosingParenthesis;
    GapStyle afterClosingSquareBracket;
    GapStyle afterComma;
    GapStyle afterDot;
    GapStyle afterOpeningParenthesis;
    GapStyle afterOpeningSquareBracket;
    GapStyle afterSemicolon;
    Alignment alignPrefixes;
    GapStyle beforeClosingParenthesis;
    GapStyle beforeClosingSquareBracket;
    GapStyle beforeComma;
    GapStyle beforeDot;
    GapStyle beforeOpeningParenthesis;
    GapStyle beforeOpeningSquareBracket;
    GapStyle beforeSemicolon;
    Charset charset;
    NumberFormat doubleFormat;
    EndOfLineStyle endOfLine;
    IndentStyle indentStyle;
    WrappingStyle wrapListItems;
    boolean firstPredicateInNewLine;
    boolean useAForRdfType;
    boolean useCommaByDefault;
    Set<Property> commaForPredicate;
    Set<Property> noCommaForPredicate;
    boolean useShortLiterals;
    boolean alignBaseIRI;
    boolean alignObjects;
    boolean alignPredicates;
    int continuationIndentSize;
    boolean indentPrediates;
    boolean insertFinalNewline;
    int indentSize;
    int maxLineLength;
    boolean trimTrailingWhitespace;
    List<String> prefixOrder;
    List<Resource> subjectOrder;
    List<Property> predicateOrder;
    List<RDFNode> objectOrder;
    BiFunction<Resource, Integer, String> anonymousNodeIdGenerator;

    private static Set<KnownPrefix> $default$knownPrefixes() {
        return Set.of(PREFIX_RDF, PREFIX_RDFS, PREFIX_XSD, PREFIX_OWL, PREFIX_DCTERMS, PREFIX_FMT);
    }

    private static GapStyle $default$afterClosingParenthesis() {
        return GapStyle.NOTHING;
    }

    private static GapStyle $default$afterClosingSquareBracket() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$afterComma() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$afterDot() {
        return GapStyle.NEWLINE;
    }

    private static GapStyle $default$afterOpeningParenthesis() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$afterOpeningSquareBracket() {
        return GapStyle.NEWLINE;
    }

    private static GapStyle $default$afterSemicolon() {
        return GapStyle.NEWLINE;
    }

    private static Alignment $default$alignPrefixes() {
        return Alignment.OFF;
    }

    private static GapStyle $default$beforeClosingParenthesis() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$beforeClosingSquareBracket() {
        return GapStyle.NEWLINE;
    }

    private static GapStyle $default$beforeComma() {
        return GapStyle.NOTHING;
    }

    private static GapStyle $default$beforeDot() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$beforeOpeningParenthesis() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$beforeOpeningSquareBracket() {
        return GapStyle.SPACE;
    }

    private static GapStyle $default$beforeSemicolon() {
        return GapStyle.SPACE;
    }

    private static Charset $default$charset() {
        return Charset.UTF_8;
    }

    private static NumberFormat $default$doubleFormat() {
        return new DecimalFormat("0.####E0");
    }

    private static EndOfLineStyle $default$endOfLine() {
        return EndOfLineStyle.LF;
    }

    private static IndentStyle $default$indentStyle() {
        return IndentStyle.SPACE;
    }

    private static WrappingStyle $default$wrapListItems() {
        return WrappingStyle.FOR_LONG_LINES;
    }

    private static boolean $default$firstPredicateInNewLine() {
        return false;
    }

    private static boolean $default$useAForRdfType() {
        return true;
    }

    private static boolean $default$useCommaByDefault() {
        return false;
    }

    private static Set<Property> $default$commaForPredicate() {
        return Set.of(RDF.type);
    }

    private static Set<Property> $default$noCommaForPredicate() {
        return Set.of();
    }

    private static boolean $default$useShortLiterals() {
        return true;
    }

    private static boolean $default$alignBaseIRI() {
        return false;
    }

    private static boolean $default$alignObjects() {
        return false;
    }

    private static boolean $default$alignPredicates() {
        return false;
    }

    private static int $default$continuationIndentSize() {
        return 4;
    }

    private static boolean $default$indentPrediates() {
        return true;
    }

    private static boolean $default$insertFinalNewline() {
        return true;
    }

    private static int $default$indentSize() {
        return 2;
    }

    private static int $default$maxLineLength() {
        return 100;
    }

    private static boolean $default$trimTrailingWhitespace() {
        return true;
    }

    private static List<String> $default$prefixOrder() {
        return List.of("rdf", "rdfs", "xsd", "owl");
    }

    private static List<Resource> $default$subjectOrder() {
        return List.of(OWL2.Ontology, OWL2.Class, OWL2.ObjectProperty, OWL2.DatatypeProperty, OWL2.AnnotationProperty, OWL2.NamedIndividual, OWL2.AllDifferent, OWL2.Axiom);
    }

    private static List<Property> $default$predicateOrder() {
        return List.of(RDF.type);
    }

    private static List<RDFNode> $default$objectOrder() {
        return List.of(OWL2.NamedIndividual, OWL2.ObjectProperty, OWL2.DatatypeProperty, OWL2.AnnotationProperty, OWL2.FunctionalProperty, OWL2.InverseFunctionalProperty, OWL2.TransitiveProperty, OWL2.SymmetricProperty, OWL2.AsymmetricProperty, OWL2.ReflexiveProperty, OWL2.IrreflexiveProperty);
    }

    private static BiFunction<Resource, Integer, String> $default$anonymousNodeIdGenerator() {
        return (resource, integer) -> "_:gen" + integer;
    }

    FormattingStyle(Set<KnownPrefix> knownPrefixes, GapStyle afterClosingParenthesis, GapStyle afterClosingSquareBracket, GapStyle afterComma, GapStyle afterDot, GapStyle afterOpeningParenthesis, GapStyle afterOpeningSquareBracket, GapStyle afterSemicolon, Alignment alignPrefixes, GapStyle beforeClosingParenthesis, GapStyle beforeClosingSquareBracket, GapStyle beforeComma, GapStyle beforeDot, GapStyle beforeOpeningParenthesis, GapStyle beforeOpeningSquareBracket, GapStyle beforeSemicolon, Charset charset, NumberFormat doubleFormat, EndOfLineStyle endOfLine, IndentStyle indentStyle, WrappingStyle wrapListItems, boolean firstPredicateInNewLine, boolean useAForRdfType, boolean useCommaByDefault, Set<Property> commaForPredicate, Set<Property> noCommaForPredicate, boolean useShortLiterals, boolean alignBaseIRI, boolean alignObjects, boolean alignPredicates, int continuationIndentSize, boolean indentPrediates, boolean insertFinalNewline, int indentSize, int maxLineLength, boolean trimTrailingWhitespace, List<String> prefixOrder, List<Resource> subjectOrder, List<Property> predicateOrder, List<RDFNode> objectOrder, BiFunction<Resource, Integer, String> anonymousNodeIdGenerator) {
        this.knownPrefixes = knownPrefixes;
        this.afterClosingParenthesis = afterClosingParenthesis;
        this.afterClosingSquareBracket = afterClosingSquareBracket;
        this.afterComma = afterComma;
        this.afterDot = afterDot;
        this.afterOpeningParenthesis = afterOpeningParenthesis;
        this.afterOpeningSquareBracket = afterOpeningSquareBracket;
        this.afterSemicolon = afterSemicolon;
        this.alignPrefixes = alignPrefixes;
        this.beforeClosingParenthesis = beforeClosingParenthesis;
        this.beforeClosingSquareBracket = beforeClosingSquareBracket;
        this.beforeComma = beforeComma;
        this.beforeDot = beforeDot;
        this.beforeOpeningParenthesis = beforeOpeningParenthesis;
        this.beforeOpeningSquareBracket = beforeOpeningSquareBracket;
        this.beforeSemicolon = beforeSemicolon;
        this.charset = charset;
        this.doubleFormat = doubleFormat;
        this.endOfLine = endOfLine;
        this.indentStyle = indentStyle;
        this.wrapListItems = wrapListItems;
        this.firstPredicateInNewLine = firstPredicateInNewLine;
        this.useAForRdfType = useAForRdfType;
        this.useCommaByDefault = useCommaByDefault;
        this.commaForPredicate = commaForPredicate;
        this.noCommaForPredicate = noCommaForPredicate;
        this.useShortLiterals = useShortLiterals;
        this.alignBaseIRI = alignBaseIRI;
        this.alignObjects = alignObjects;
        this.alignPredicates = alignPredicates;
        this.continuationIndentSize = continuationIndentSize;
        this.indentPrediates = indentPrediates;
        this.insertFinalNewline = insertFinalNewline;
        this.indentSize = indentSize;
        this.maxLineLength = maxLineLength;
        this.trimTrailingWhitespace = trimTrailingWhitespace;
        this.prefixOrder = prefixOrder;
        this.subjectOrder = subjectOrder;
        this.predicateOrder = predicateOrder;
        this.objectOrder = objectOrder;
        this.anonymousNodeIdGenerator = anonymousNodeIdGenerator;
    }

    public static FormattingStyleBuilder builder() {
        return new FormattingStyleBuilder();
    }

    public static final class KnownPrefix {
        private final String prefix;
        private final URI iri;

        public KnownPrefix(String prefix, URI iri) {
            this.prefix = prefix;
            this.iri = iri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public URI getIri() {
            return this.iri;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KnownPrefix)) {
                return false;
            }
            KnownPrefix other = (KnownPrefix)o;
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            URI this$iri = this.getIri();
            URI other$iri = other.getIri();
            return !(this$iri == null ? other$iri != null : !((Object)this$iri).equals(other$iri));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            URI $iri = this.getIri();
            result = result * 59 + ($iri == null ? 43 : ((Object)$iri).hashCode());
            return result;
        }

        public String toString() {
            return "FormattingStyle.KnownPrefix(prefix=" + this.getPrefix() + ", iri=" + this.getIri() + ")";
        }
    }

    public static enum GapStyle {
        NEWLINE,
        NOTHING,
        SPACE;

    }

    public static enum Alignment {
        LEFT,
        OFF,
        RIGHT;

    }

    public static enum Charset {
        LATIN1,
        UTF_16_BE,
        UTF_16_LE,
        UTF_8,
        UTF_8_BOM;

    }

    public static enum EndOfLineStyle {
        CR,
        CRLF,
        LF;

    }

    public static enum IndentStyle {
        SPACE,
        TAB;

    }

    public static enum WrappingStyle {
        ALWAYS,
        FOR_LONG_LINES,
        NEVER;

    }

    public static class FormattingStyleBuilder {
        private boolean knownPrefixes$set;
        private Set<KnownPrefix> knownPrefixes$value;
        private boolean afterClosingParenthesis$set;
        private GapStyle afterClosingParenthesis$value;
        private boolean afterClosingSquareBracket$set;
        private GapStyle afterClosingSquareBracket$value;
        private boolean afterComma$set;
        private GapStyle afterComma$value;
        private boolean afterDot$set;
        private GapStyle afterDot$value;
        private boolean afterOpeningParenthesis$set;
        private GapStyle afterOpeningParenthesis$value;
        private boolean afterOpeningSquareBracket$set;
        private GapStyle afterOpeningSquareBracket$value;
        private boolean afterSemicolon$set;
        private GapStyle afterSemicolon$value;
        private boolean alignPrefixes$set;
        private Alignment alignPrefixes$value;
        private boolean beforeClosingParenthesis$set;
        private GapStyle beforeClosingParenthesis$value;
        private boolean beforeClosingSquareBracket$set;
        private GapStyle beforeClosingSquareBracket$value;
        private boolean beforeComma$set;
        private GapStyle beforeComma$value;
        private boolean beforeDot$set;
        private GapStyle beforeDot$value;
        private boolean beforeOpeningParenthesis$set;
        private GapStyle beforeOpeningParenthesis$value;
        private boolean beforeOpeningSquareBracket$set;
        private GapStyle beforeOpeningSquareBracket$value;
        private boolean beforeSemicolon$set;
        private GapStyle beforeSemicolon$value;
        private boolean charset$set;
        private Charset charset$value;
        private boolean doubleFormat$set;
        private NumberFormat doubleFormat$value;
        private boolean endOfLine$set;
        private EndOfLineStyle endOfLine$value;
        private boolean indentStyle$set;
        private IndentStyle indentStyle$value;
        private boolean wrapListItems$set;
        private WrappingStyle wrapListItems$value;
        private boolean firstPredicateInNewLine$set;
        private boolean firstPredicateInNewLine$value;
        private boolean useAForRdfType$set;
        private boolean useAForRdfType$value;
        private boolean useCommaByDefault$set;
        private boolean useCommaByDefault$value;
        private boolean commaForPredicate$set;
        private Set<Property> commaForPredicate$value;
        private boolean noCommaForPredicate$set;
        private Set<Property> noCommaForPredicate$value;
        private boolean useShortLiterals$set;
        private boolean useShortLiterals$value;
        private boolean alignBaseIRI$set;
        private boolean alignBaseIRI$value;
        private boolean alignObjects$set;
        private boolean alignObjects$value;
        private boolean alignPredicates$set;
        private boolean alignPredicates$value;
        private boolean continuationIndentSize$set;
        private int continuationIndentSize$value;
        private boolean indentPrediates$set;
        private boolean indentPrediates$value;
        private boolean insertFinalNewline$set;
        private boolean insertFinalNewline$value;
        private boolean indentSize$set;
        private int indentSize$value;
        private boolean maxLineLength$set;
        private int maxLineLength$value;
        private boolean trimTrailingWhitespace$set;
        private boolean trimTrailingWhitespace$value;
        private boolean prefixOrder$set;
        private List<String> prefixOrder$value;
        private boolean subjectOrder$set;
        private List<Resource> subjectOrder$value;
        private boolean predicateOrder$set;
        private List<Property> predicateOrder$value;
        private boolean objectOrder$set;
        private List<RDFNode> objectOrder$value;
        private boolean anonymousNodeIdGenerator$set;
        private BiFunction<Resource, Integer, String> anonymousNodeIdGenerator$value;

        FormattingStyleBuilder() {
        }

        public FormattingStyleBuilder knownPrefixes(Set<KnownPrefix> knownPrefixes) {
            this.knownPrefixes$value = knownPrefixes;
            this.knownPrefixes$set = true;
            return this;
        }

        public FormattingStyleBuilder afterClosingParenthesis(GapStyle afterClosingParenthesis) {
            this.afterClosingParenthesis$value = afterClosingParenthesis;
            this.afterClosingParenthesis$set = true;
            return this;
        }

        public FormattingStyleBuilder afterClosingSquareBracket(GapStyle afterClosingSquareBracket) {
            this.afterClosingSquareBracket$value = afterClosingSquareBracket;
            this.afterClosingSquareBracket$set = true;
            return this;
        }

        public FormattingStyleBuilder afterComma(GapStyle afterComma) {
            this.afterComma$value = afterComma;
            this.afterComma$set = true;
            return this;
        }

        public FormattingStyleBuilder afterDot(GapStyle afterDot) {
            this.afterDot$value = afterDot;
            this.afterDot$set = true;
            return this;
        }

        public FormattingStyleBuilder afterOpeningParenthesis(GapStyle afterOpeningParenthesis) {
            this.afterOpeningParenthesis$value = afterOpeningParenthesis;
            this.afterOpeningParenthesis$set = true;
            return this;
        }

        public FormattingStyleBuilder afterOpeningSquareBracket(GapStyle afterOpeningSquareBracket) {
            this.afterOpeningSquareBracket$value = afterOpeningSquareBracket;
            this.afterOpeningSquareBracket$set = true;
            return this;
        }

        public FormattingStyleBuilder afterSemicolon(GapStyle afterSemicolon) {
            this.afterSemicolon$value = afterSemicolon;
            this.afterSemicolon$set = true;
            return this;
        }

        public FormattingStyleBuilder alignPrefixes(Alignment alignPrefixes) {
            this.alignPrefixes$value = alignPrefixes;
            this.alignPrefixes$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeClosingParenthesis(GapStyle beforeClosingParenthesis) {
            this.beforeClosingParenthesis$value = beforeClosingParenthesis;
            this.beforeClosingParenthesis$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeClosingSquareBracket(GapStyle beforeClosingSquareBracket) {
            this.beforeClosingSquareBracket$value = beforeClosingSquareBracket;
            this.beforeClosingSquareBracket$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeComma(GapStyle beforeComma) {
            this.beforeComma$value = beforeComma;
            this.beforeComma$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeDot(GapStyle beforeDot) {
            this.beforeDot$value = beforeDot;
            this.beforeDot$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeOpeningParenthesis(GapStyle beforeOpeningParenthesis) {
            this.beforeOpeningParenthesis$value = beforeOpeningParenthesis;
            this.beforeOpeningParenthesis$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeOpeningSquareBracket(GapStyle beforeOpeningSquareBracket) {
            this.beforeOpeningSquareBracket$value = beforeOpeningSquareBracket;
            this.beforeOpeningSquareBracket$set = true;
            return this;
        }

        public FormattingStyleBuilder beforeSemicolon(GapStyle beforeSemicolon) {
            this.beforeSemicolon$value = beforeSemicolon;
            this.beforeSemicolon$set = true;
            return this;
        }

        public FormattingStyleBuilder charset(Charset charset) {
            this.charset$value = charset;
            this.charset$set = true;
            return this;
        }

        public FormattingStyleBuilder doubleFormat(NumberFormat doubleFormat) {
            this.doubleFormat$value = doubleFormat;
            this.doubleFormat$set = true;
            return this;
        }

        public FormattingStyleBuilder endOfLine(EndOfLineStyle endOfLine) {
            this.endOfLine$value = endOfLine;
            this.endOfLine$set = true;
            return this;
        }

        public FormattingStyleBuilder indentStyle(IndentStyle indentStyle) {
            this.indentStyle$value = indentStyle;
            this.indentStyle$set = true;
            return this;
        }

        public FormattingStyleBuilder wrapListItems(WrappingStyle wrapListItems) {
            this.wrapListItems$value = wrapListItems;
            this.wrapListItems$set = true;
            return this;
        }

        public FormattingStyleBuilder firstPredicateInNewLine(boolean firstPredicateInNewLine) {
            this.firstPredicateInNewLine$value = firstPredicateInNewLine;
            this.firstPredicateInNewLine$set = true;
            return this;
        }

        public FormattingStyleBuilder useAForRdfType(boolean useAForRdfType) {
            this.useAForRdfType$value = useAForRdfType;
            this.useAForRdfType$set = true;
            return this;
        }

        public FormattingStyleBuilder useCommaByDefault(boolean useCommaByDefault) {
            this.useCommaByDefault$value = useCommaByDefault;
            this.useCommaByDefault$set = true;
            return this;
        }

        public FormattingStyleBuilder commaForPredicate(Set<Property> commaForPredicate) {
            this.commaForPredicate$value = commaForPredicate;
            this.commaForPredicate$set = true;
            return this;
        }

        public FormattingStyleBuilder noCommaForPredicate(Set<Property> noCommaForPredicate) {
            this.noCommaForPredicate$value = noCommaForPredicate;
            this.noCommaForPredicate$set = true;
            return this;
        }

        public FormattingStyleBuilder useShortLiterals(boolean useShortLiterals) {
            this.useShortLiterals$value = useShortLiterals;
            this.useShortLiterals$set = true;
            return this;
        }

        public FormattingStyleBuilder alignBaseIRI(boolean alignBaseIRI) {
            this.alignBaseIRI$value = alignBaseIRI;
            this.alignBaseIRI$set = true;
            return this;
        }

        public FormattingStyleBuilder alignObjects(boolean alignObjects) {
            this.alignObjects$value = alignObjects;
            this.alignObjects$set = true;
            return this;
        }

        public FormattingStyleBuilder alignPredicates(boolean alignPredicates) {
            this.alignPredicates$value = alignPredicates;
            this.alignPredicates$set = true;
            return this;
        }

        public FormattingStyleBuilder continuationIndentSize(int continuationIndentSize) {
            this.continuationIndentSize$value = continuationIndentSize;
            this.continuationIndentSize$set = true;
            return this;
        }

        public FormattingStyleBuilder indentPrediates(boolean indentPrediates) {
            this.indentPrediates$value = indentPrediates;
            this.indentPrediates$set = true;
            return this;
        }

        public FormattingStyleBuilder insertFinalNewline(boolean insertFinalNewline) {
            this.insertFinalNewline$value = insertFinalNewline;
            this.insertFinalNewline$set = true;
            return this;
        }

        public FormattingStyleBuilder indentSize(int indentSize) {
            this.indentSize$value = indentSize;
            this.indentSize$set = true;
            return this;
        }

        public FormattingStyleBuilder maxLineLength(int maxLineLength) {
            this.maxLineLength$value = maxLineLength;
            this.maxLineLength$set = true;
            return this;
        }

        public FormattingStyleBuilder trimTrailingWhitespace(boolean trimTrailingWhitespace) {
            this.trimTrailingWhitespace$value = trimTrailingWhitespace;
            this.trimTrailingWhitespace$set = true;
            return this;
        }

        public FormattingStyleBuilder prefixOrder(List<String> prefixOrder) {
            this.prefixOrder$value = prefixOrder;
            this.prefixOrder$set = true;
            return this;
        }

        public FormattingStyleBuilder subjectOrder(List<Resource> subjectOrder) {
            this.subjectOrder$value = subjectOrder;
            this.subjectOrder$set = true;
            return this;
        }

        public FormattingStyleBuilder predicateOrder(List<Property> predicateOrder) {
            this.predicateOrder$value = predicateOrder;
            this.predicateOrder$set = true;
            return this;
        }

        public FormattingStyleBuilder objectOrder(List<RDFNode> objectOrder) {
            this.objectOrder$value = objectOrder;
            this.objectOrder$set = true;
            return this;
        }

        public FormattingStyleBuilder anonymousNodeIdGenerator(BiFunction<Resource, Integer, String> anonymousNodeIdGenerator) {
            this.anonymousNodeIdGenerator$value = anonymousNodeIdGenerator;
            this.anonymousNodeIdGenerator$set = true;
            return this;
        }

        public FormattingStyle build() {
            Set<KnownPrefix> knownPrefixes$value = this.knownPrefixes$value;
            if (!this.knownPrefixes$set) {
                knownPrefixes$value = FormattingStyle.$default$knownPrefixes();
            }
            GapStyle afterClosingParenthesis$value = this.afterClosingParenthesis$value;
            if (!this.afterClosingParenthesis$set) {
                afterClosingParenthesis$value = FormattingStyle.$default$afterClosingParenthesis();
            }
            GapStyle afterClosingSquareBracket$value = this.afterClosingSquareBracket$value;
            if (!this.afterClosingSquareBracket$set) {
                afterClosingSquareBracket$value = FormattingStyle.$default$afterClosingSquareBracket();
            }
            GapStyle afterComma$value = this.afterComma$value;
            if (!this.afterComma$set) {
                afterComma$value = FormattingStyle.$default$afterComma();
            }
            GapStyle afterDot$value = this.afterDot$value;
            if (!this.afterDot$set) {
                afterDot$value = FormattingStyle.$default$afterDot();
            }
            GapStyle afterOpeningParenthesis$value = this.afterOpeningParenthesis$value;
            if (!this.afterOpeningParenthesis$set) {
                afterOpeningParenthesis$value = FormattingStyle.$default$afterOpeningParenthesis();
            }
            GapStyle afterOpeningSquareBracket$value = this.afterOpeningSquareBracket$value;
            if (!this.afterOpeningSquareBracket$set) {
                afterOpeningSquareBracket$value = FormattingStyle.$default$afterOpeningSquareBracket();
            }
            GapStyle afterSemicolon$value = this.afterSemicolon$value;
            if (!this.afterSemicolon$set) {
                afterSemicolon$value = FormattingStyle.$default$afterSemicolon();
            }
            Alignment alignPrefixes$value = this.alignPrefixes$value;
            if (!this.alignPrefixes$set) {
                alignPrefixes$value = FormattingStyle.$default$alignPrefixes();
            }
            GapStyle beforeClosingParenthesis$value = this.beforeClosingParenthesis$value;
            if (!this.beforeClosingParenthesis$set) {
                beforeClosingParenthesis$value = FormattingStyle.$default$beforeClosingParenthesis();
            }
            GapStyle beforeClosingSquareBracket$value = this.beforeClosingSquareBracket$value;
            if (!this.beforeClosingSquareBracket$set) {
                beforeClosingSquareBracket$value = FormattingStyle.$default$beforeClosingSquareBracket();
            }
            GapStyle beforeComma$value = this.beforeComma$value;
            if (!this.beforeComma$set) {
                beforeComma$value = FormattingStyle.$default$beforeComma();
            }
            GapStyle beforeDot$value = this.beforeDot$value;
            if (!this.beforeDot$set) {
                beforeDot$value = FormattingStyle.$default$beforeDot();
            }
            GapStyle beforeOpeningParenthesis$value = this.beforeOpeningParenthesis$value;
            if (!this.beforeOpeningParenthesis$set) {
                beforeOpeningParenthesis$value = FormattingStyle.$default$beforeOpeningParenthesis();
            }
            GapStyle beforeOpeningSquareBracket$value = this.beforeOpeningSquareBracket$value;
            if (!this.beforeOpeningSquareBracket$set) {
                beforeOpeningSquareBracket$value = FormattingStyle.$default$beforeOpeningSquareBracket();
            }
            GapStyle beforeSemicolon$value = this.beforeSemicolon$value;
            if (!this.beforeSemicolon$set) {
                beforeSemicolon$value = FormattingStyle.$default$beforeSemicolon();
            }
            Charset charset$value = this.charset$value;
            if (!this.charset$set) {
                charset$value = FormattingStyle.$default$charset();
            }
            NumberFormat doubleFormat$value = this.doubleFormat$value;
            if (!this.doubleFormat$set) {
                doubleFormat$value = FormattingStyle.$default$doubleFormat();
            }
            EndOfLineStyle endOfLine$value = this.endOfLine$value;
            if (!this.endOfLine$set) {
                endOfLine$value = FormattingStyle.$default$endOfLine();
            }
            IndentStyle indentStyle$value = this.indentStyle$value;
            if (!this.indentStyle$set) {
                indentStyle$value = FormattingStyle.$default$indentStyle();
            }
            WrappingStyle wrapListItems$value = this.wrapListItems$value;
            if (!this.wrapListItems$set) {
                wrapListItems$value = FormattingStyle.$default$wrapListItems();
            }
            boolean firstPredicateInNewLine$value = this.firstPredicateInNewLine$value;
            if (!this.firstPredicateInNewLine$set) {
                firstPredicateInNewLine$value = FormattingStyle.$default$firstPredicateInNewLine();
            }
            boolean useAForRdfType$value = this.useAForRdfType$value;
            if (!this.useAForRdfType$set) {
                useAForRdfType$value = FormattingStyle.$default$useAForRdfType();
            }
            boolean useCommaByDefault$value = this.useCommaByDefault$value;
            if (!this.useCommaByDefault$set) {
                useCommaByDefault$value = FormattingStyle.$default$useCommaByDefault();
            }
            Set<Property> commaForPredicate$value = this.commaForPredicate$value;
            if (!this.commaForPredicate$set) {
                commaForPredicate$value = FormattingStyle.$default$commaForPredicate();
            }
            Set<Property> noCommaForPredicate$value = this.noCommaForPredicate$value;
            if (!this.noCommaForPredicate$set) {
                noCommaForPredicate$value = FormattingStyle.$default$noCommaForPredicate();
            }
            boolean useShortLiterals$value = this.useShortLiterals$value;
            if (!this.useShortLiterals$set) {
                useShortLiterals$value = FormattingStyle.$default$useShortLiterals();
            }
            boolean alignBaseIRI$value = this.alignBaseIRI$value;
            if (!this.alignBaseIRI$set) {
                alignBaseIRI$value = FormattingStyle.$default$alignBaseIRI();
            }
            boolean alignObjects$value = this.alignObjects$value;
            if (!this.alignObjects$set) {
                alignObjects$value = FormattingStyle.$default$alignObjects();
            }
            boolean alignPredicates$value = this.alignPredicates$value;
            if (!this.alignPredicates$set) {
                alignPredicates$value = FormattingStyle.$default$alignPredicates();
            }
            int continuationIndentSize$value = this.continuationIndentSize$value;
            if (!this.continuationIndentSize$set) {
                continuationIndentSize$value = FormattingStyle.$default$continuationIndentSize();
            }
            boolean indentPrediates$value = this.indentPrediates$value;
            if (!this.indentPrediates$set) {
                indentPrediates$value = FormattingStyle.$default$indentPrediates();
            }
            boolean insertFinalNewline$value = this.insertFinalNewline$value;
            if (!this.insertFinalNewline$set) {
                insertFinalNewline$value = FormattingStyle.$default$insertFinalNewline();
            }
            int indentSize$value = this.indentSize$value;
            if (!this.indentSize$set) {
                indentSize$value = FormattingStyle.$default$indentSize();
            }
            int maxLineLength$value = this.maxLineLength$value;
            if (!this.maxLineLength$set) {
                maxLineLength$value = FormattingStyle.$default$maxLineLength();
            }
            boolean trimTrailingWhitespace$value = this.trimTrailingWhitespace$value;
            if (!this.trimTrailingWhitespace$set) {
                trimTrailingWhitespace$value = FormattingStyle.$default$trimTrailingWhitespace();
            }
            List<String> prefixOrder$value = this.prefixOrder$value;
            if (!this.prefixOrder$set) {
                prefixOrder$value = FormattingStyle.$default$prefixOrder();
            }
            List<Resource> subjectOrder$value = this.subjectOrder$value;
            if (!this.subjectOrder$set) {
                subjectOrder$value = FormattingStyle.$default$subjectOrder();
            }
            List<Property> predicateOrder$value = this.predicateOrder$value;
            if (!this.predicateOrder$set) {
                predicateOrder$value = FormattingStyle.$default$predicateOrder();
            }
            List<RDFNode> objectOrder$value = this.objectOrder$value;
            if (!this.objectOrder$set) {
                objectOrder$value = FormattingStyle.$default$objectOrder();
            }
            BiFunction<Resource, Integer, String> anonymousNodeIdGenerator$value = this.anonymousNodeIdGenerator$value;
            if (!this.anonymousNodeIdGenerator$set) {
                anonymousNodeIdGenerator$value = FormattingStyle.$default$anonymousNodeIdGenerator();
            }
            return new FormattingStyle(knownPrefixes$value, afterClosingParenthesis$value, afterClosingSquareBracket$value, afterComma$value, afterDot$value, afterOpeningParenthesis$value, afterOpeningSquareBracket$value, afterSemicolon$value, alignPrefixes$value, beforeClosingParenthesis$value, beforeClosingSquareBracket$value, beforeComma$value, beforeDot$value, beforeOpeningParenthesis$value, beforeOpeningSquareBracket$value, beforeSemicolon$value, charset$value, doubleFormat$value, endOfLine$value, indentStyle$value, wrapListItems$value, firstPredicateInNewLine$value, useAForRdfType$value, useCommaByDefault$value, commaForPredicate$value, noCommaForPredicate$value, useShortLiterals$value, alignBaseIRI$value, alignObjects$value, alignPredicates$value, continuationIndentSize$value, indentPrediates$value, insertFinalNewline$value, indentSize$value, maxLineLength$value, trimTrailingWhitespace$value, prefixOrder$value, subjectOrder$value, predicateOrder$value, objectOrder$value, anonymousNodeIdGenerator$value);
        }

        public String toString() {
            return "FormattingStyle.FormattingStyleBuilder(knownPrefixes$value=" + this.knownPrefixes$value + ", afterClosingParenthesis$value=" + this.afterClosingParenthesis$value + ", afterClosingSquareBracket$value=" + this.afterClosingSquareBracket$value + ", afterComma$value=" + this.afterComma$value + ", afterDot$value=" + this.afterDot$value + ", afterOpeningParenthesis$value=" + this.afterOpeningParenthesis$value + ", afterOpeningSquareBracket$value=" + this.afterOpeningSquareBracket$value + ", afterSemicolon$value=" + this.afterSemicolon$value + ", alignPrefixes$value=" + this.alignPrefixes$value + ", beforeClosingParenthesis$value=" + this.beforeClosingParenthesis$value + ", beforeClosingSquareBracket$value=" + this.beforeClosingSquareBracket$value + ", beforeComma$value=" + this.beforeComma$value + ", beforeDot$value=" + this.beforeDot$value + ", beforeOpeningParenthesis$value=" + this.beforeOpeningParenthesis$value + ", beforeOpeningSquareBracket$value=" + this.beforeOpeningSquareBracket$value + ", beforeSemicolon$value=" + this.beforeSemicolon$value + ", charset$value=" + this.charset$value + ", doubleFormat$value=" + this.doubleFormat$value + ", endOfLine$value=" + this.endOfLine$value + ", indentStyle$value=" + this.indentStyle$value + ", wrapListItems$value=" + this.wrapListItems$value + ", firstPredicateInNewLine$value=" + this.firstPredicateInNewLine$value + ", useAForRdfType$value=" + this.useAForRdfType$value + ", useCommaByDefault$value=" + this.useCommaByDefault$value + ", commaForPredicate$value=" + this.commaForPredicate$value + ", noCommaForPredicate$value=" + this.noCommaForPredicate$value + ", useShortLiterals$value=" + this.useShortLiterals$value + ", alignBaseIRI$value=" + this.alignBaseIRI$value + ", alignObjects$value=" + this.alignObjects$value + ", alignPredicates$value=" + this.alignPredicates$value + ", continuationIndentSize$value=" + this.continuationIndentSize$value + ", indentPrediates$value=" + this.indentPrediates$value + ", insertFinalNewline$value=" + this.insertFinalNewline$value + ", indentSize$value=" + this.indentSize$value + ", maxLineLength$value=" + this.maxLineLength$value + ", trimTrailingWhitespace$value=" + this.trimTrailingWhitespace$value + ", prefixOrder$value=" + this.prefixOrder$value + ", subjectOrder$value=" + this.subjectOrder$value + ", predicateOrder$value=" + this.predicateOrder$value + ", objectOrder$value=" + this.objectOrder$value + ", anonymousNodeIdGenerator$value=" + this.anonymousNodeIdGenerator$value + ")";
        }
    }
}

