/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.util.LinkedList;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.update.UpdateAction;
import thewebsemantic.RDF2Bean;

public class Sparql {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> LinkedList<T> exec(Model m, Class<T> c, String query) {
        RDF2Bean reader = new RDF2Bean(m);
        QueryExecution qexec = Sparql.getQueryExec(m, query);
        LinkedList<T> beans = new LinkedList<T>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                beans.add(reader.load(c, Sparql.resource(results)));
            }
            LinkedList<T> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> LinkedList<T> exec(Model m, Class<T> c, String query, QuerySolution initialBindings) {
        RDF2Bean reader = new RDF2Bean(m);
        QueryExecution qexec = Sparql.getQueryExec(m, query, initialBindings);
        LinkedList<T> beans = new LinkedList<T>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                beans.add(reader.load(c, Sparql.resource(results)));
            }
            LinkedList<T> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> LinkedList<T> exec(RDF2Bean reader, Class<T> c, String query, QuerySolution initialBindings, int start, int max) {
        Model m = reader.getModel();
        QueryExecution qexec = Sparql.getQueryExec(m, query, initialBindings);
        LinkedList<T> beans = new LinkedList<T>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            for (int pos = 0; pos < start && results.hasNext(); ++pos) {
                results.next();
            }
            while (results.hasNext() && max != 0) {
                beans.add(reader.load(c, Sparql.resource(results)));
                --max;
            }
            LinkedList<T> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> LinkedList<Resource> exec2(Model m, String query, QuerySolution initialBindings) {
        QueryExecution qexec = Sparql.getQueryExec(m, query, initialBindings);
        LinkedList<Resource> beans = new LinkedList<Resource>();
        try {
            m.enterCriticalSection(true);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                beans.add(Sparql.resource(results));
            }
            LinkedList<Resource> linkedList = beans;
            return linkedList;
        }
        finally {
            m.leaveCriticalSection();
            qexec.close();
        }
    }

    public static void update(Model m, String query, QuerySolution i) {
        UpdateAction.parseExecute((String)query, (Model)m);
    }

    private static QueryExecution getQueryExec(Model m, String query) {
        Query q = QueryFactory.create((String)query);
        return QueryExecutionFactory.create((Query)q, (Model)m);
    }

    private static QueryExecution getQueryExec(Model m, String query, QuerySolution i) {
        Query q = QueryFactory.create((String)query);
        return QueryExecutionFactory.create((Query)q, (Model)m, (QuerySolution)i);
    }

    private static Resource resource(ResultSet results) {
        return results.nextSolution().getResource("s");
    }
}

