/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import thewebsemantic.AnnotationHelper;
import thewebsemantic.Base;
import thewebsemantic.JenaHelper;
import thewebsemantic.NullJPAHelper;
import thewebsemantic.PrimitiveWrapper;
import thewebsemantic.Resource;
import thewebsemantic.Saver;
import thewebsemantic.TypeWrapper;
import thewebsemantic.ValuesContext;

public class Bean2RDF
extends Base {
    private static final String UNSUPPORTED_TYPE = "UNSUPPORTED_TYPE";
    private ArrayList<Object> cycle;
    private boolean forceDeep = false;
    public static Logger logger = Logger.getLogger("com.thewebsemantic");
    ResourceBundle bundle = ResourceBundle.getBundle("thewebsemantic.messages");
    private AnnotationHelper jpa;

    public Bean2RDF(Model m) {
        super(m);
        this.jpa = new NullJPAHelper();
    }

    public Bean2RDF(Model m, AnnotationHelper jpa) {
        super(m);
        this.jpa = jpa;
    }

    public org.apache.jena.rdf.model.Resource save(Object bean) {
        return this.write(bean, false);
    }

    public void delete(Object bean) {
        org.apache.jena.rdf.model.Resource i = this.m.getResource(TypeWrapper.instanceURI(bean));
        this.m.removeAll(null, null, (RDFNode)i).removeAll(i, null, null);
    }

    public org.apache.jena.rdf.model.Resource saveDeep(Object bean) {
        return this.write(bean, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized org.apache.jena.rdf.model.Resource write(Object bean, boolean forceDeep) {
        try {
            this.m.enterCriticalSection(false);
            this.forceDeep = forceDeep;
            this.cycle = new ArrayList();
            org.apache.jena.rdf.model.Resource resource = this._write(bean, false);
            return resource;
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    private org.apache.jena.rdf.model.Resource _write(Object bean, boolean shallow) {
        return this.cycle.contains(bean) ? this.existing(bean) : this.write(bean, this.toResource(bean), shallow);
    }

    private org.apache.jena.rdf.model.Resource toResource(Object bean) {
        String uri = TypeWrapper.instanceURI(bean);
        org.apache.jena.rdf.model.Resource type = this.getRDFSClass(bean);
        if (this.jpa.isEmbedded(bean) || uri == null) {
            return this.m.createResource(type);
        }
        return this.m.createResource(uri, type);
    }

    private org.apache.jena.rdf.model.Resource existing(Object bean) {
        return this.m.createResource(TypeWrapper.instanceURI(bean));
    }

    private org.apache.jena.rdf.model.Resource getRDFSClass(Object bean) {
        return this.m.getResource(this.getURI(bean)).addProperty(RDF.type, (RDFNode)RDFS.Class).addProperty(this.javaclass, bean.getClass().getName());
    }

    private String getURI(Object bean) {
        return this.isBound(bean) ? this.binder.getUri(bean) : TypeWrapper.type(bean).typeUri();
    }

    private org.apache.jena.rdf.model.Resource write(Object bean, org.apache.jena.rdf.model.Resource subject, boolean shallow) {
        this.cycle.add(bean);
        for (ValuesContext p : TypeWrapper.valueContexts(bean)) {
            if (shallow && p.type().isAssignableFrom(Collection.class) && !this.forceDeep) continue;
            this.saveOrUpdate(subject, p);
        }
        return subject;
    }

    private void saveOrUpdate(org.apache.jena.rdf.model.Resource subject, ValuesContext pc) {
        Object o = pc.invokeGetter();
        Property property = this.toRdfProperty(pc);
        if (Saver.supports(pc.type())) {
            Saver.of(pc.type()).save(this, subject, property, o);
        } else if (o == null) {
            subject.removeAll(property);
        } else if (pc.isPrimitive()) {
            subject.removeAll(property).addProperty(property, (RDFNode)JenaHelper.toLiteral(this.m, o));
        } else if (this.isNormalObject(o)) {
            this.setPropertyValue(subject, property, o);
        } else {
            logger.log(Level.WARNING, MessageFormat.format(this.bundle.getString(UNSUPPORTED_TYPE), pc.type(), pc.subject.getClass()));
        }
    }

    private boolean isNormalObject(Object o) {
        return !o.getClass().isArray() && !(o instanceof Collection) && !(o instanceof Map);
    }

    protected RDFNode toRDFNode(Object o) {
        if (PrimitiveWrapper.isPrimitive(o)) {
            return JenaHelper.toLiteral(this.m, o);
        }
        if (o instanceof URI || o instanceof Resource) {
            return this.m.createResource(o.toString());
        }
        return this._write(o, true);
    }

    private void setPropertyValue(org.apache.jena.rdf.model.Resource subject, Property property, Object o) {
        Statement s = subject.getProperty(property);
        org.apache.jena.rdf.model.Resource existing = null;
        if (s != null && (existing = s.getResource()).isAnon()) {
            existing.removeProperties();
        }
        subject.removeAll(property).addProperty(property, (RDFNode)this._write(o, true));
    }

    public void n3() {
        this.m.write((OutputStream)System.out, "N3");
    }
}

