/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.lang.reflect.Array;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.shared.PropertyNotFoundException;
import thewebsemantic.Bean2RDF;
import thewebsemantic.Saver;

public class ArraySaver
extends Saver {
    @Override
    public void save(Bean2RDF writer, Resource subject, Property property, Object array) {
        if (array == null) {
            return;
        }
        Seq s = this.getSeq(subject, property);
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object o = Array.get(array, i);
            if (o == null) continue;
            s.add(writer.toRDFNode(o));
        }
    }

    protected Seq getSeq(Resource subject, Property property) {
        try {
            Seq s = subject.getRequiredProperty(property).getSeq();
            NodeIterator it = s.iterator();
            while (it.hasNext()) {
                RDFNode node = it.nextNode();
                if (!node.isAnon()) continue;
                ((Resource)node.as(Resource.class)).removeProperties();
            }
            it.close();
            s.removeProperties();
            subject.removeAll(property);
        }
        catch (PropertyNotFoundException s) {
            // empty catch block
        }
        Seq seq = subject.getModel().createSeq();
        subject.addProperty(property, (RDFNode)seq);
        return seq;
    }
}

