/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import thewebsemantic.Base;
import thewebsemantic.TypeWrapper;

public abstract class ValuesContext {
    protected Object subject;

    public abstract AccessibleObject getAccessibleObject();

    public abstract String uri();

    public abstract boolean isId();

    public abstract boolean isSymmetric();

    public abstract boolean isTransitive();

    public abstract boolean isInverse();

    public abstract String inverseOf();

    public abstract boolean existsInModel(Model var1);

    public abstract Object invokeGetter();

    public abstract void setProperty(Object var1);

    public abstract boolean isPrimitive();

    public boolean isCollection() {
        return this.type().equals(Collection.class);
    }

    public boolean isCollectionOrSet() {
        return this.isCollection() || this.isSet();
    }

    public boolean isSet() {
        return this.type().equals(Set.class);
    }

    public boolean isCollectionType() {
        return Collection.class.isAssignableFrom(this.type());
    }

    public boolean isURI() {
        return this.type().equals(URI.class);
    }

    public abstract String getName();

    public abstract Class<?> type();

    public abstract Class<?> t();

    public Class<?> getGenericType(ParameterizedType type) {
        return type == null ? Base.NullType.class : (Class)type.getActualTypeArguments()[0];
    }

    public boolean isTransitive(AccessibleObject o) {
        return TypeWrapper.getRDFAnnotation(o).transitive();
    }

    public boolean isInverse(AccessibleObject o) {
        String inverseProperty = TypeWrapper.getRDFAnnotation(o).inverseOf();
        return !"".equals(inverseProperty);
    }

    public String inverseOf(AccessibleObject o) {
        return TypeWrapper.getRDFAnnotation(o).inverseOf();
    }

    public Property property(Model m) {
        return m.getProperty(this.uri());
    }

    public boolean isList() {
        return this.type().equals(List.class);
    }

    public boolean isAggregateType() {
        return this.isCollectionType() || this.isArray();
    }

    public boolean isArray() {
        return this.type().isArray();
    }

    public String toString() {
        return this.getName();
    }
}

