/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.beans.BeanInfo;
import java.beans.MethodDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import thewebsemantic.DefaultTypeWrapper;
import thewebsemantic.EnumTypeWrapper;
import thewebsemantic.IdFieldTypeWrapper;
import thewebsemantic.IdMethodTypeWrapper;
import thewebsemantic.TypeWrapper;
import thewebsemantic.Uri;
import thewebsemantic.UriMethodTypeWrapper;
import thewebsemantic.Util;

public class TypeWrapperFactory {
    public static Logger logger = Logger.getLogger("com.thewebsemantic");

    public static TypeWrapper newwrapper(Class<?> c) {
        Field[] fields;
        BeanInfo info = TypeWrapper.beanInfo(c);
        if (c.isEnum()) {
            return new EnumTypeWrapper(c);
        }
        for (MethodDescriptor md : info.getMethodDescriptors()) {
            if (TypeWrapperFactory.isId(md)) {
                return new IdMethodTypeWrapper(c, md.getMethod());
            }
            if (!TypeWrapperFactory.isUri(md)) continue;
            return new UriMethodTypeWrapper(c, md.getMethod());
        }
        for (Field f : fields = Util.getDeclaredFields(c)) {
            if (!TypeWrapperFactory.isId(f)) continue;
            return new IdFieldTypeWrapper(c, f, fields);
        }
        return new DefaultTypeWrapper(c);
    }

    private static boolean isId(AccessibleObject m) {
        for (Annotation a : m.getAnnotations()) {
            if (!"Id".equals(a.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isId(MethodDescriptor md) {
        return TypeWrapperFactory.isId(md.getMethod());
    }

    private static boolean isUri(Method m) {
        return m.isAnnotationPresent(Uri.class);
    }

    private static boolean isUri(MethodDescriptor md) {
        return TypeWrapperFactory.isUri(md.getMethod());
    }
}

