/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import thewebsemantic.As;
import thewebsemantic.Base;
import thewebsemantic.Bean2RDF;
import thewebsemantic.Functional;
import thewebsemantic.JenaHelper;
import thewebsemantic.Namespace;
import thewebsemantic.PrimitiveWrapper;
import thewebsemantic.RdfType;
import thewebsemantic.TypeWrapper;
import thewebsemantic.Util;

public class Thing
implements InvocationHandler,
As {
    private Model model;
    private Resource r;
    private static Method as;
    private static Method isa;
    private static Method asResource;

    public Thing(Resource resource, Model m) {
        this.model = m;
        this.r = resource;
    }

    public Thing(String resource, Model m) {
        this(m.getResource(resource), m);
    }

    public Thing(Model m) {
        this(m.createResource(), m);
    }

    public Thing at(String uri) {
        return new Thing(uri, this.model);
    }

    public Resource getResource() {
        return this.r;
    }

    public OntResource getOntResource() {
        return (OntResource)this.r.as(OntResource.class);
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public <T> T as(Class<T> c) {
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
    }

    @Override
    public <T> T isa(Class<T> c) {
        String ns = c.getEnclosingClass().getAnnotation(Namespace.class).value();
        RdfType rdfType = c.getEnclosingClass().getAnnotation(RdfType.class);
        this.r.addProperty(RDF.type, (RDFNode)this.model.getResource(ns + Util.getRdfType(c)));
        return this.as(c);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType = method.getReturnType();
        if (method.equals(as)) {
            return this.as((Class)args[0]);
        }
        if (method.equals(isa)) {
            return this.isa((Class)args[0]);
        }
        if (method.equals(asResource)) {
            return this.asResource();
        }
        if (method.getParameterTypes().length == 0) {
            return this.get(method);
        }
        if (method.isAnnotationPresent(Functional.class)) {
            this.set(method, args);
            return proxy;
        }
        this.add(method, args);
        return proxy;
    }

    @Override
    public Resource asResource() {
        return this.r;
    }

    private Object get(Method m) {
        String methodName = this.trim(m.getName());
        Class genericType = Object.class;
        if (m.getGenericReturnType() instanceof ParameterizedType) {
            genericType = this.getGenericType((ParameterizedType)m.getGenericReturnType());
        }
        Class<?> returnType = m.getReturnType();
        Class<?> c = m.getDeclaringClass();
        String ns = TypeWrapper.wrap(c).namespace();
        Property p = this.model.getProperty(ns + methodName);
        StmtIterator it = this.r.listProperties(p);
        return it.hasNext() ? this.convertToObject(genericType, returnType, it) : null;
    }

    private Object convertToObject(Class<?> genericType, Class<?> returnType, StmtIterator it) {
        if (PrimitiveWrapper.isPrimitive(returnType)) {
            return this.primitive(returnType, it);
        }
        if (returnType == Literal.class) {
            return this.literal(it);
        }
        if (returnType == Thing.class) {
            return this.thing(it);
        }
        if (As.class.isAssignableFrom(returnType)) {
            return this.thing(it, returnType);
        }
        if (returnType == Collection.class && genericType == Literal.class) {
            return this.literalCollection(it);
        }
        if (returnType == Collection.class && PrimitiveWrapper.isPrimitive(genericType)) {
            return this.primitiveCollection(it, returnType);
        }
        if (returnType == Collection.class && genericType.equals(Thing.class)) {
            return this.thingCollection(it);
        }
        return null;
    }

    private Object thing(StmtIterator it, Class<?> as) {
        Statement s = it.nextStatement();
        if (s.getObject().isLiteral()) {
            return s.getLiteral();
        }
        return new Thing(s.getResource(), s.getModel()).as(as);
    }

    private Object thing(StmtIterator it) {
        Statement s = it.nextStatement();
        if (s.getObject().isLiteral()) {
            return s.getLiteral();
        }
        return new Thing(s.getResource(), s.getModel());
    }

    private Object literal(StmtIterator it) {
        return it.nextStatement().getLiteral();
    }

    private Object primitive(Class<?> returnType, StmtIterator it) {
        return JenaHelper.convertLiteral(it.nextStatement().getLiteral(), returnType);
    }

    private Object thingCollection(StmtIterator it) {
        ArrayList<Thing> list = new ArrayList<Thing>();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (s.getObject().isLiteral()) continue;
            list.add(new Thing(s.getResource(), s.getModel()));
        }
        return list;
    }

    public Class<?> getGenericType(ParameterizedType type) {
        return type == null ? Base.NullType.class : (Class)type.getActualTypeArguments()[0];
    }

    private Object literalCollection(StmtIterator it) {
        ArrayList<Literal> list = new ArrayList<Literal>();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getObject().isLiteral()) continue;
            list.add(s.getLiteral());
        }
        return list;
    }

    private Object primitiveCollection(StmtIterator it, Class t) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getObject().isLiteral()) continue;
            list.add(JenaHelper.convertLiteral(s.getLiteral(), t));
        }
        return list;
    }

    private void set(Method m, Object[] arg) {
        Property p = this.getProperty(m);
        this.r.removeAll(p);
        this.apply(arg, p, m.getParameterTypes()[0] == Object.class);
    }

    private Property getProperty(Method m) {
        String methodName = this.trim(m.getName());
        Class<?> c = m.getDeclaringClass();
        String ns = TypeWrapper.wrap(c).namespace();
        Property p = this.model.getProperty(ns + methodName);
        return p;
    }

    private void add(Method m, Object[] arg) {
        Property p = this.getProperty(m);
        this.apply(arg, p, m.getParameterTypes()[0] == Object.class);
    }

    private void apply(Object[] arg, Property p, boolean rawLiteral) {
        if (PrimitiveWrapper.isPrimitive(arg[0])) {
            if (arg.length < 2) {
                if (rawLiteral) {
                    this.r.addProperty(p, arg[0].toString());
                } else {
                    this.r.addProperty(p, (RDFNode)JenaHelper.toLiteral(this.model, arg[0]));
                }
            } else {
                this.r.addProperty(p, arg[0].toString(), arg[1].toString());
            }
        } else if (arg[0] instanceof Thing) {
            this.set(p, (Thing)arg[0]);
        } else if (arg[0] instanceof As) {
            this.set(p, ((As)arg[0]).asResource());
        } else if (arg[0] instanceof URI) {
            this.set(p, ((URI)arg[0]).toString());
        } else if (arg[0] instanceof Resource) {
            this.set(p, (Resource)arg[0]);
        }
    }

    private void set(Property p, Thing arg) {
        this.set(p, arg.getResource());
    }

    private void set(Property p, String arg) {
        this.set(p, this.model.getResource(arg));
    }

    private void set(Property p, Resource object) {
        this.r.addProperty(p, (RDFNode)object);
    }

    private String trim(String s) {
        if (s.endsWith("_")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String toString() {
        return this.r.getURI();
    }

    static {
        try {
            as = As.class.getMethod("as", Class.class);
            isa = As.class.getMethod("isa", Class.class);
            asResource = As.class.getMethod("asResource", new Class[0]);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Could not access methods on As interface.", e);
        }
    }
}

