/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.vocabulary.RDF;
import thewebsemantic.AnnotationHelper;
import thewebsemantic.Base;
import thewebsemantic.Filler;
import thewebsemantic.JenaHelper;
import thewebsemantic.Namespace;
import thewebsemantic.NoBinding;
import thewebsemantic.NotBoundException;
import thewebsemantic.NotFoundException;
import thewebsemantic.NullJPAHelper;
import thewebsemantic.ResolverUtil;
import thewebsemantic.Resource;
import thewebsemantic.TypeWrapper;
import thewebsemantic.Util;
import thewebsemantic.ValuesContext;
import thewebsemantic.binding.Persistable;
import thewebsemantic.lazy.LazyList;
import thewebsemantic.lazy.LazySet;
import thewebsemantic.lazy.Provider;

public class RDF2Bean
extends Base
implements Provider {
    private HashMap<String, Object> cycle;
    private boolean shallow = false;
    private Set<String> myIncludes = new HashSet<String>();
    private static final String[] none = new String[0];
    private AnnotationHelper jpa;

    public RDF2Bean(Model model) {
        super(model);
        this.jpa = new NullJPAHelper();
    }

    public RDF2Bean(Model model, AnnotationHelper h) {
        super(model);
        this.jpa = h;
    }

    public <T> Collection<T> loadDeep(Class<T> c) {
        return this.load(c, false, none);
    }

    public <T> Collection<T> load(Class<T> c) {
        return this.load(c, true, none);
    }

    public <T> Collection<T> load(Class<T> c, String ... includes) {
        return this.load(c, true, includes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized <T> Collection<T> load(Class<T> c, boolean shallow, String ... includes) {
        this.init(shallow, includes);
        try {
            Collection<T> collection = this.loadAll(c);
            return collection;
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    private void init(boolean shallow, String[] includes) {
        this.cycle = new HashMap();
        this.m.enterCriticalSection(true);
        this.shallow = shallow;
        this.myIncludes.clear();
        for (String s : includes) {
            this.myIncludes.add(s);
        }
    }

    private <T> Collection<T> loadAll(Class<T> c) {
        return this.loadIndividuals(c, this.m.listSubjectsWithProperty(RDF.type, (RDFNode)this.rdfType(c)));
    }

    private <T> Collection<T> loadIndividuals(Class<T> c, ResIterator it) {
        LinkedList<T> list = new LinkedList<T>();
        while (it.hasNext()) {
            list.add(this.toObject(c, it.nextResource()));
        }
        it.close();
        return list;
    }

    public <T> T loadDeep(Class<T> c, Object id) throws NotFoundException {
        return this.load(c, id.toString(), false);
    }

    public <T> T load(Class<T> c, String id, String[] includes) throws NotFoundException {
        return this.load(c, id, true, includes);
    }

    public <T> T load(Class<T> c, Object id) throws NotFoundException {
        return this.load(c, id.toString(), true);
    }

    public <T> T load(Class<T> c, org.apache.jena.rdf.model.Resource r) {
        return this.load(c, r, true, new String[0]);
    }

    protected <T> T load(Class<T> c, String id, boolean shallow) throws NotFoundException {
        return this.load(c, id, shallow, new String[0]);
    }

    private synchronized <T> T load(Class<T> c, String id, boolean shallow, String[] includes) throws NotFoundException {
        this.init(shallow, includes);
        try {
            if (this.exists(c, id)) {
                T t = this.toObject(c, id);
                return t;
            }
            throw new NotFoundException();
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T> T load(Class<T> c, org.apache.jena.rdf.model.Resource r, boolean shallow, String[] includes) {
        this.init(shallow, includes);
        try {
            T t = this.toObject(c, r);
            return t;
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <A> A load(A target) {
        this.init(this.shallow, none);
        try {
            org.apache.jena.rdf.model.Resource source = this.m.getResource(TypeWrapper.instanceURI(target));
            Object object = this.applyProperties(source, target);
            return (A)object;
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    public synchronized boolean exists(Object target) {
        this.init(this.shallow, none);
        try {
            boolean bl = this.exists(TypeWrapper.instanceURI(target));
            return bl;
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    @Deprecated
    public Filler fill(Object o) {
        return new Filler(this, o);
    }

    @Deprecated
    public synchronized void fill(Object o, String propertyName) {
        this.init(this.shallow, none);
        try {
            this.fillWithChildren(o, propertyName);
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    public boolean exists(Class<?> c, String id) {
        return this.exists(TypeWrapper.wrap(c).uri(id));
    }

    public boolean exists(String uri) {
        return this.m.getGraph().contains(NodeFactory.createURI((String)uri), Node.ANY, Node.ANY);
    }

    private <T> T toObject(Class<T> c, String id) {
        return this.toObject(c, this.m.getResource(TypeWrapper.wrap(c).uri(id)));
    }

    public Object load(String uri) throws NotFoundException {
        this.init(this.shallow, none);
        try {
            if (this.exists(uri)) {
                Object object = this.toObject(Object.class, this.m.getResource(uri));
                return object;
            }
            throw new NotFoundException();
        }
        finally {
            this.m.leaveCriticalSection();
        }
    }

    private <T> T toObject(Class<T> c, org.apache.jena.rdf.model.Resource i) {
        if (c == Resource.class) {
            return (T)new Resource(i.getURI());
        }
        if (c == URI.class) {
            return (T)URI.create(i.getURI());
        }
        return (T)(i != null ? this.testCycle(i, c) : null);
    }

    private Object testCycle(org.apache.jena.rdf.model.Resource i, Class<?> c) {
        return this.isCycle(i) ? this.cachedObject(i) : this.applyProperties(i, c);
    }

    private Object cachedObject(org.apache.jena.rdf.model.Resource i) {
        return this.cycle.get(this.key(i));
    }

    private <T> T toObject(Class<T> c, RDFNode node) {
        if (node.isLiteral()) {
            return (T)JenaHelper.convertLiteral(node, c);
        }
        return this.toObject(c, (org.apache.jena.rdf.model.Resource)node.as(org.apache.jena.rdf.model.Resource.class));
    }

    private boolean isCycle(org.apache.jena.rdf.model.Resource i) {
        return this.cycle.containsKey(this.key(i));
    }

    private String key(org.apache.jena.rdf.model.Resource i) {
        return i.isAnon() ? i.getId().toString() : i.getURI();
    }

    private Object fillWithChildren(Object target, String propertyName) {
        org.apache.jena.rdf.model.Resource source = this.m.getResource(TypeWrapper.instanceURI(target));
        for (ValuesContext p : TypeWrapper.valueContexts(target)) {
            if (!this.match(propertyName, p)) continue;
            this.fill(source, p);
        }
        return target;
    }

    private boolean match(String propertyName, ValuesContext p) {
        return p.getName().equals(propertyName) && p.isAggregateType();
    }

    private Object applyProperties(org.apache.jena.rdf.model.Resource source, Class c) {
        return this.applyProperties(source, this.newInstance(source, c));
    }

    private Object applyProperties(org.apache.jena.rdf.model.Resource source, Object target) {
        this.cycle.put(source.getURI(), target);
        for (ValuesContext ctx : TypeWrapper.valueContexts(target)) {
            if (ctx.isAggregateType()) continue;
            this.apply(source, ctx);
        }
        for (ValuesContext ctx : TypeWrapper.valueContexts(target)) {
            if (!ctx.isAggregateType()) continue;
            this.apply(source, ctx);
        }
        if (target instanceof Persistable) {
            ((Persistable)target).activate();
        }
        return target;
    }

    public void init(Object target) {
        org.apache.jena.rdf.model.Resource node = this.m.getResource(TypeWrapper.instanceURI(target));
        for (ValuesContext ctx : TypeWrapper.valueContexts(target)) {
            if (ctx.isCollectionOrSet() && ctx.invokeGetter() == null) {
                ctx.setProperty(new LazySet(node, ctx.uri(), ctx.t(), this));
                continue;
            }
            if (ctx.isList() && ctx.invokeGetter() == null) {
                ctx.setProperty(new LazyList(node, ctx.uri(), ctx.t(), this));
                continue;
            }
            if (!ctx.isId() || !this.jpa.isGenerated(ctx)) continue;
            this.generateid(target, ctx);
        }
    }

    private void generateid(Object target, ValuesContext ctx) {
        String uri = TypeWrapper.type(target).typeUri();
        org.apache.jena.rdf.model.Resource r = this.m.createResource(uri);
        int idx = 0;
        try {
            Statement s = r.getRequiredProperty(this.sequence);
            idx = s.getInt();
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        ctx.setProperty(idx);
        r.removeAll(this.sequence).addProperty(this.sequence, (RDFNode)this.m.createTypedLiteral(idx + 1));
    }

    private Object newInstance(org.apache.jena.rdf.model.Resource source, Class c) {
        try {
            TypeWrapper t = TypeWrapper.wrap(this.javaclass(source, c));
            return this.jpa.proxyRequired() ? t.toProxyBean(source, this.jpa) : t.toBean(source);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class<?> javaclass(org.apache.jena.rdf.model.Resource source, Class<?> c) throws ClassNotFoundException {
        StmtIterator it = source.listProperties(RDF.type);
        org.apache.jena.rdf.model.Resource oc = null;
        while (it.hasNext()) {
            oc = it.nextStatement().getResource();
            Class<?> declared = this.declaredClass(oc);
            if (!c.isAssignableFrom(declared)) continue;
            it.close();
            return declared;
        }
        it.close();
        throw new NotBoundException(source.getURI() + " exists but is not bound to or able to coerce as " + c);
    }

    private Class<?> declaredClass(org.apache.jena.rdf.model.Resource oc) throws ClassNotFoundException {
        Class result = NoBinding.class;
        if (this.binder.getClass(oc.getURI()) != null) {
            result = this.binder.getClass(oc.getURI());
        } else if (oc.getProperty(this.javaclass) != null) {
            Statement node = oc.getProperty(this.javaclass);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> klass = cl.loadClass(node.getLiteral().getString());
            this.binder.save(klass, oc.getURI());
            result = klass;
        }
        return result;
    }

    private org.apache.jena.rdf.model.Resource rdfType(Class<?> c) {
        return this.m.getResource(this.binder.isBound(c) ? this.binder.getUri(c) : TypeWrapper.typeUri(c));
    }

    private void apply(org.apache.jena.rdf.model.Resource i, ValuesContext ctx) {
        if ((ctx.isCollection() || ctx.isSet()) && this.shallow && !this.included(ctx.getName())) {
            ctx.setProperty(new LazySet(i, ctx.uri(), ctx.t(), this));
            return;
        }
        if (ctx.isList() && this.shallow && !this.included(ctx.getName())) {
            ctx.setProperty(new LazyList(i, ctx.uri(), ctx.t(), this));
            return;
        }
        StmtIterator it = i.listProperties(this.m.getProperty(ctx.uri()));
        this.apply(ctx, it);
        it.close();
    }

    private void fill(org.apache.jena.rdf.model.Resource i, ValuesContext ctx) {
        Property p = this.m.createProperty(ctx.uri());
        StmtIterator values = i.listProperties(p);
        if (ctx.isArray()) {
            Seq s = values.nextStatement().getSeq();
            Class<?> type = ctx.type().getComponentType();
            ctx.setProperty(this.fillArray(type, s));
        } else if (ctx.isList()) {
            Seq s = values.nextStatement().getSeq();
            ctx.setProperty(this.fillList(ctx.t(), s));
        } else if (ctx.isCollectionType()) {
            ctx.setProperty(this.fillCollection(ctx.t(), values));
        }
        values.close();
    }

    @Override
    public Set lazySet(org.apache.jena.rdf.model.Resource i, String propertyUri, Class type) {
        Property p = this.m.createProperty(propertyUri);
        StmtIterator values = i.listProperties(p);
        Set l = this.fillCollection(type, values);
        values.close();
        return l;
    }

    @Override
    public List lazyList(org.apache.jena.rdf.model.Resource i, String propertyUri, Class type) {
        Property p = this.m.createProperty(propertyUri);
        List<Object> l = null;
        StmtIterator values = i.listProperties(p);
        if (values.hasNext()) {
            Seq s = values.nextStatement().getSeq();
            l = this.fillList(type, s);
        } else {
            l = new ArrayList();
        }
        values.close();
        return l;
    }

    private void apply(ValuesContext ctx, StmtIterator nodes) {
        if (ctx.isCollection()) {
            this.collection(ctx, nodes);
        } else {
            if (!nodes.hasNext()) {
                return;
            }
            if (ctx.isPrimitive()) {
                this.applyLiteral(ctx, nodes.nextStatement().getLiteral());
            } else if (ctx.isArray()) {
                this.array(ctx, nodes.nextStatement().getSeq());
            } else if (ctx.isList()) {
                this.list(ctx, nodes.nextStatement().getSeq());
            } else if (ctx.isURI()) {
                this.applyURI(ctx, nodes.nextStatement().getResource());
            } else {
                this.applyIndividual(ctx, nodes.nextStatement().getResource());
            }
        }
    }

    private void list(ValuesContext ctx, Seq s) {
        ctx.setProperty(this.fillList(ctx.t(), s));
    }

    private List<Object> fillList(Class<?> type, Seq s) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < s.size(); ++i) {
            list.add(this.toObject(type, s.getObject(i + 1)));
        }
        return list;
    }

    private void applyURI(ValuesContext ctx, org.apache.jena.rdf.model.Resource resource) {
        ctx.setProperty(URI.create(resource.getURI()));
    }

    private void array(ValuesContext ctx, Seq s) {
        Class<?> type = ctx.type().getComponentType();
        ctx.setProperty(this.fillArray(type, s));
    }

    private Object fillArray(Class<?> type, Seq s) {
        Object array = Array.newInstance(type, s.size());
        for (int i = 0; i < Array.getLength(array); ++i) {
            Array.set(array, i, this.toObject(type, s.getObject(i + 1)));
        }
        return array;
    }

    private void collection(ValuesContext ctx, StmtIterator nodes) {
        ctx.setProperty(this.fillCollection(ctx.t(), nodes));
    }

    private boolean included(String property) {
        return this.myIncludes.contains(property);
    }

    protected <T> Set<T> fillCollection(Class<T> c, StmtIterator nodes) {
        HashSet<T> results = new HashSet<T>();
        while (nodes.hasNext()) {
            results.add(this.toObject(c, nodes.nextStatement().getObject()));
        }
        return results;
    }

    private void applyIndividual(ValuesContext ctx, org.apache.jena.rdf.model.Resource i) {
        ctx.setProperty(this.toObject(ctx.type(), i));
    }

    private void applyLiteral(ValuesContext ctx, Literal l) {
        ctx.setProperty(JenaHelper.convertLiteral(l, ctx.type()));
    }

    public void bindAll(String ... pkg) {
        ResolverUtil resolver = new ResolverUtil();
        resolver.findAnnotated(Namespace.class, pkg);
        Set classes = resolver.getClasses();
        for (Class class1 : classes) {
            this.bind(class1);
        }
    }

    public void bind(Class<? extends Object> class1) {
        Namespace ns = class1.getAnnotation(Namespace.class);
        this.m.getResource(ns.value() + Util.getRdfType(class1)).addProperty(this.javaclass, class1.getName());
    }

    public void bind(Package ... packages) {
        for (Package p : packages) {
            this.bindAll(p.getName());
        }
    }
}

