/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ParameterizedType;
import java.util.logging.Level;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import thewebsemantic.Bean2RDF;
import thewebsemantic.PrimitiveWrapper;
import thewebsemantic.Symmetric;
import thewebsemantic.TypeWrapper;
import thewebsemantic.ValuesContext;

class PropertyContext
extends ValuesContext {
    PropertyDescriptor property;
    TypeWrapper type;
    boolean idmethod = false;

    public PropertyContext(Object bean, PropertyDescriptor p) {
        this.subject = bean;
        this.property = p;
        this.type = TypeWrapper.type(bean);
    }

    public PropertyContext(Object bean, PropertyDescriptor p, boolean b) {
        this(bean, p);
        this.idmethod = b;
    }

    @Override
    public String uri() {
        return this.type.uri(this.property.getReadMethod(), this.property.getName());
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric(this.property);
    }

    private boolean isSymmetric(PropertyDescriptor p) {
        return p.getReadMethod().isAnnotationPresent(Symmetric.class) ? true : TypeWrapper.getRDFAnnotation(p.getReadMethod()).symmetric();
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive(this.property.getReadMethod());
    }

    @Override
    public boolean existsInModel(Model m) {
        return m.getGraph().contains(NodeFactory.createURI((String)this.uri()), Node.ANY, Node.ANY);
    }

    @Override
    public Object invokeGetter() {
        Object result = null;
        try {
            result = this.property.getReadMethod().invoke(this.subject, new Object[0]);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Error calling read method.", e);
        }
        return result;
    }

    @Override
    public void setProperty(Object v) {
        try {
            this.property.getWriteMethod().invoke(this.subject, v);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Error calling write method.", e);
        }
    }

    @Override
    public boolean isPrimitive() {
        return PrimitiveWrapper.isPrimitive(this.property.getPropertyType());
    }

    @Override
    public Class<?> type() {
        return this.property.getPropertyType();
    }

    public TypeWrapper tw() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.property.getName();
    }

    @Override
    public Class<?> t() {
        ParameterizedType type = (ParameterizedType)this.property.getReadMethod().getGenericReturnType();
        return this.getGenericType(type);
    }

    @Override
    public boolean isInverse() {
        return this.isInverse(this.property.getReadMethod());
    }

    @Override
    public String inverseOf() {
        return this.inverseOf(this.property.getReadMethod());
    }

    @Override
    public boolean isId() {
        return this.idmethod;
    }

    @Override
    public AccessibleObject getAccessibleObject() {
        return this.property.getReadMethod();
    }
}

