/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.jena.rdf.model.Resource;
import thewebsemantic.AnnotationHelper;
import thewebsemantic.Bean2RDF;
import thewebsemantic.PropertyContext;
import thewebsemantic.Transient;
import thewebsemantic.TypeWrapper;
import thewebsemantic.ValuesContext;

public class IdMethodTypeWrapper
extends TypeWrapper {
    private Method idReadMethod;
    private Method idWriteMethod;
    private boolean uriid = false;
    private Constructor<?> uriConstructor;

    public IdMethodTypeWrapper(Class<?> c, Method m) {
        super(c);
        PropertyDescriptor[] props;
        this.idReadMethod = m;
        this.uriid = URI.class.equals(this.idReadMethod.getReturnType());
        if (this.uriid) {
            try {
                this.uriConstructor = c.getConstructor(URI.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (PropertyDescriptor propertyDescriptor : props = this.descriptors()) {
            if (!this.idReadMethod.equals(propertyDescriptor.getReadMethod())) continue;
            this.idWriteMethod = propertyDescriptor.getWriteMethod();
        }
    }

    @Override
    public String uri(String id) {
        if (this.uriid) {
            return id;
        }
        return this.typeUri() + "/" + this.urlencode(id);
    }

    private String urlencode(String id) {
        try {
            return URLEncoder.encode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String id(Object bean) {
        return this.invokeMethod(bean, this.idReadMethod);
    }

    @Override
    public ValuesContext[] getValueContexts(Object o) {
        ArrayList<PropertyContext> values = new ArrayList<PropertyContext>();
        for (PropertyDescriptor property : this.descriptors()) {
            if (this.uriid && this.idReadMethod.equals(property.getReadMethod()) || property.getReadMethod().isAnnotationPresent(Transient.class)) continue;
            boolean idmethod = this.idReadMethod.equals(property.getReadMethod());
            values.add(new PropertyContext(o, property, idmethod));
        }
        return values.toArray(new ValuesContext[0]);
    }

    @Override
    public Object toBean(String uri) {
        try {
            if (this.uriid && this.uriConstructor != null) {
                return this.uriConstructor.newInstance(URI.create(uri));
            }
            if (this.uriid && this.idWriteMethod != null) {
                Object obj = this.c.newInstance();
                this.idWriteMethod.invoke(obj, URI.create(uri));
                return obj;
            }
            return super.toBean(uri);
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Error instantiating bean.", e);
            return null;
        }
    }

    @Override
    public Object toProxyBean(Resource source, AnnotationHelper jpa) {
        try {
            Class cls = jpa.getProxy(this.c);
            Object obj = cls.newInstance();
            if (this.uriid && this.idWriteMethod != null) {
                this.idWriteMethod.invoke(obj, URI.create(source.getURI()));
            }
            return obj;
        }
        catch (Exception e) {
            Bean2RDF.logger.log(Level.WARNING, "Exception caught while invoking default constructor on " + this.c, e);
            return null;
        }
    }
}

