/*
 * Decompiled with CFR 0.152.
 */
package thewebsemantic;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import thewebsemantic.Bean2RDF;
import thewebsemantic.Saver;
import thewebsemantic.lazy.Lazy;

public class CollectionSaver
extends Saver {
    @Override
    public void save(Bean2RDF writer, Resource subject, Property property, Object o) {
        Lazy lazy;
        Collection c = (Collection)o;
        if (c == null) {
            return;
        }
        if (!(!(o instanceof Lazy) || (lazy = (Lazy)o).isConnected() && lazy.modified())) {
            return;
        }
        this.removeAnonymousNodes(subject, property);
        subject.removeAll(property);
        for (Object obj : c) {
            subject.addProperty(property, writer.toRDFNode(obj));
        }
    }

    private void removeAnonymousNodes(Resource subject, Property property) {
        ArrayList<Resource> anonNodes = new ArrayList<Resource>();
        StmtIterator it = subject.listProperties(property);
        while (it.hasNext()) {
            RDFNode n = it.nextStatement().getObject();
            if (!n.isAnon()) continue;
            anonNodes.add((Resource)n.as(Resource.class));
        }
        it.close();
        for (Resource resource : anonNodes) {
            resource.removeProperties();
        }
    }
}

