/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.backend;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.aservo.ldap.adapter.ServerConfiguration;
import de.aservo.ldap.adapter.api.cursor.MappableCursor;
import de.aservo.ldap.adapter.api.database.Row;
import de.aservo.ldap.adapter.api.directory.NestedDirectoryBackend;
import de.aservo.ldap.adapter.api.directory.exception.DirectoryAccessFailureException;
import de.aservo.ldap.adapter.api.directory.exception.EntityNotFoundException;
import de.aservo.ldap.adapter.api.directory.exception.SecurityProblemException;
import de.aservo.ldap.adapter.api.entity.EntityType;
import de.aservo.ldap.adapter.api.entity.GroupEntity;
import de.aservo.ldap.adapter.api.entity.MembershipEntity;
import de.aservo.ldap.adapter.api.entity.UserEntity;
import de.aservo.ldap.adapter.api.query.QueryExpression;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDirectoryBackend
implements NestedDirectoryBackend {
    private final Logger logger = LoggerFactory.getLogger(JsonDirectoryBackend.class);
    private final Set<Group> groupSet = new HashSet<Group>();
    private final Set<User> userSet = new HashSet<User>();
    private final File dbFile;

    public JsonDirectoryBackend(ServerConfiguration config) {
        try {
            URL url;
            String urlString = config.getBackendProperties().getProperty("db-uri");
            if (urlString == null) {
                throw new IllegalArgumentException("Missing value for db-uri");
            }
            if (urlString.startsWith("classpath:")) {
                url = this.getClass().getClassLoader().getResource(urlString.substring(10));
                if (url == null) {
                    throw new IllegalArgumentException("Cannot get resource from URL: " + urlString);
                }
            } else {
                url = new URL(urlString);
            }
            this.dbFile = new File(url.getFile());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getId() {
        return "json";
    }

    @Override
    public void startup() {
        try {
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(this.dbFile), StandardCharsets.UTF_8), JsonObject.class);
            JsonArray groupNode = jsonObject.getAsJsonArray("groups");
            JsonArray userNode = jsonObject.getAsJsonArray("users");
            for (JsonElement element : userNode) {
                this.userSet.add(new User(element.getAsJsonObject().get("username").getAsString(), element.getAsJsonObject().get("last_name").getAsString(), element.getAsJsonObject().get("first_name").getAsString(), element.getAsJsonObject().get("display_name").getAsString(), element.getAsJsonObject().get("email").getAsString(), element.getAsJsonObject().get("password").getAsString(), element.getAsJsonObject().get("active").getAsBoolean()));
            }
            for (JsonElement x : groupNode) {
                this.groupSet.add(new Group(x.getAsJsonObject().get("name").getAsString(), x.getAsJsonObject().get("description").getAsString()));
            }
            for (JsonElement x : groupNode) {
                String groupId = x.getAsJsonObject().get("name").getAsString();
                JsonArray groupMemberNode = x.getAsJsonObject().getAsJsonArray("group_members");
                JsonArray userMemberNode = x.getAsJsonObject().getAsJsonArray("user_members");
                Group group = this.groupSet.stream().filter(z -> z.getId().equalsIgnoreCase(groupId)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown error."));
                for (JsonElement y : groupMemberNode) {
                    group.addGroup(this.groupSet.stream().filter(z -> z.getId().equalsIgnoreCase(y.getAsString())).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot find group member with id " + y.getAsString())));
                }
                for (JsonElement y : userMemberNode) {
                    group.addUser(this.userSet.stream().filter(z -> z.getId().equalsIgnoreCase(y.getAsString())).findAny().orElseThrow(() -> new IllegalArgumentException("Cannot find user member with id " + y.getAsString())));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void shutdown() {
        this.groupSet.clear();
        this.userSet.clear();
    }

    @Override
    public MappableCursor<Row> runQueryExpression(String txId, SchemaManager schemaManager, QueryExpression expression, EntityType entityType) {
        throw new UnsupportedOperationException("Query generation not supported for JSON directory backend.");
    }

    @Override
    public GroupEntity getGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getGroup; id={}", (Object)id);
        return this.findGroupById(id);
    }

    @Override
    public UserEntity getUser(String id) throws EntityNotFoundException {
        this.logger.info("Call: getUser; id={}", (Object)id);
        return this.findUserById(id);
    }

    @Override
    public UserEntity getAuthenticatedUser(String id, String password) throws EntityNotFoundException {
        this.logger.info("Call: getAuthenticatedUser; id={}", (Object)id);
        User user = this.findUserById(id);
        if (!user.getPassword().equals(password)) {
            throw new SecurityProblemException("Could not authenticate user with id " + id);
        }
        return user;
    }

    @Override
    public Set<GroupEntity> getAllGroups() {
        this.logger.info("Call: getGroups");
        return new HashSet<GroupEntity>(this.groupSet);
    }

    @Override
    public Set<GroupEntity> getAllGroups(int startIndex, int maxResults) {
        return new HashSet<GroupEntity>(new ArrayList<Group>(this.groupSet).subList(startIndex, startIndex + maxResults));
    }

    @Override
    public Set<UserEntity> getAllUsers() {
        this.logger.info("Call: getUsers");
        return new HashSet<UserEntity>(this.userSet);
    }

    @Override
    public Set<UserEntity> getAllUsers(int startIndex, int maxResults) {
        return new HashSet<UserEntity>(new ArrayList<User>(this.userSet).subList(startIndex, startIndex + maxResults));
    }

    @Override
    public Set<UserEntity> getDirectUsersOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getDirectUsersOfGroup; id={}", (Object)id);
        Group group = this.findGroupById(id);
        return group.getUserMembers().stream().map(x -> x).collect(Collectors.toSet());
    }

    @Override
    public Set<GroupEntity> getDirectGroupsOfUser(String id) throws EntityNotFoundException {
        this.logger.info("Call: getDirectGroupsOfUser; id={}", (Object)id);
        User user = this.findUserById(id);
        return this.groupSet.stream().filter(x -> x.getUserMembers().contains(user)).collect(Collectors.toSet());
    }

    @Override
    public Set<UserEntity> getTransitiveUsersOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getTransitiveUsersOfGroup; id={}", (Object)id);
        Set<UserEntity> users = this.getDirectUsersOfGroup(id);
        for (GroupEntity group : this.getTransitiveChildGroupsOfGroup(id)) {
            users.addAll(this.getDirectUsersOfGroup(group.getId()));
        }
        return users;
    }

    @Override
    public Set<GroupEntity> getTransitiveGroupsOfUser(String id) throws EntityNotFoundException {
        this.logger.info("Call: getTransitiveGroupsOfUser; id={}", (Object)id);
        Set<GroupEntity> groups = this.getDirectGroupsOfUser(id);
        for (GroupEntity group : new ArrayList<GroupEntity>(groups)) {
            groups.addAll(this.getTransitiveParentGroupsOfGroup(group.getId()));
        }
        return groups;
    }

    @Override
    public Set<GroupEntity> getDirectChildGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getDirectChildGroupsOfGroup; id={}", (Object)id);
        Group group = this.findGroupById(id);
        return group.getGroupMembers().stream().filter(x -> !x.equals(group)).collect(Collectors.toSet());
    }

    @Override
    public Set<GroupEntity> getDirectParentGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getDirectParentGroupsOfGroup; id={}", (Object)id);
        Group group = this.findGroupById(id);
        return this.groupSet.stream().filter(x -> x.getGroupMembers().contains(group)).filter(x -> !x.equals(group)).collect(Collectors.toSet());
    }

    @Override
    public Set<GroupEntity> getTransitiveChildGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getTransitiveChildGroupsOfGroup; id={}", (Object)id);
        HashSet<Group> groups = new HashSet<Group>();
        Group group = this.findGroupById(id);
        groups.add(group);
        this.resolveGroupsDownwards(group, groups);
        groups.remove(group);
        return new HashSet<GroupEntity>(groups);
    }

    @Override
    public Set<GroupEntity> getTransitiveParentGroupsOfGroup(String id) throws EntityNotFoundException {
        this.logger.info("Call: getTransitiveParentGroupsOfGroup; id={}", (Object)id);
        HashSet<Group> groups = new HashSet<Group>();
        Group group = this.findGroupById(id);
        groups.add(group);
        this.resolveGroupsUpwards(group, groups);
        groups.remove(group);
        return new HashSet<GroupEntity>(groups);
    }

    @Override
    public MappableCursor<MembershipEntity> getMemberships() {
        this.logger.info("Backend call: getMemberships");
        return MappableCursor.fromIterable(this.groupSet).map(group -> new MembershipEntity(group.getName(), this.getDirectChildGroupsOfGroup(group.getId()).stream().map(GroupEntity::getName).collect(Collectors.toSet()), this.getDirectUsersOfGroup(group.getId()).stream().map(UserEntity::getUsername).collect(Collectors.toSet())));
    }

    private Group findGroupById(String id) throws EntityNotFoundException {
        return this.groupSet.stream().filter(x -> x.getId().equalsIgnoreCase(id)).findAny().orElseThrow(() -> new EntityNotFoundException("Cannot find group with id " + id));
    }

    private User findUserById(String id) throws EntityNotFoundException {
        return this.userSet.stream().filter(x -> x.getId().equalsIgnoreCase(id)).findAny().orElseThrow(() -> new EntityNotFoundException("Cannot find user with id " + id));
    }

    private void resolveGroupsDownwards(Group group, Set<Group> acc) throws DirectoryAccessFailureException, SecurityProblemException, EntityNotFoundException {
        Set<Group> result = group.getGroupMembers();
        result.removeAll(acc);
        acc.addAll(result);
        for (Group x : result) {
            this.resolveGroupsDownwards(x, acc);
        }
    }

    private void resolveGroupsUpwards(Group group, Set<Group> acc) throws DirectoryAccessFailureException, SecurityProblemException, EntityNotFoundException {
        Set result = this.groupSet.stream().filter(x -> x.getGroupMembers().contains(group)).collect(Collectors.toSet());
        result.removeAll(acc);
        acc.addAll(result);
        for (Group x2 : result) {
            this.resolveGroupsUpwards(x2, acc);
        }
    }

    private static class User
    extends UserEntity {
        private final String password;

        public User(String username, String lastName, String firstName, String displayName, String email, String password, boolean active) {
            super(username, lastName, firstName, displayName, email, active);
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }
    }

    private static class Group
    extends GroupEntity {
        private final Set<Group> groupMembers = new HashSet<Group>();
        private final Set<User> userMembers = new HashSet<User>();

        public Group(String name, String description) {
            super(name, description);
        }

        public void addGroup(Group group) {
            this.groupMembers.add(group);
        }

        public void addUser(User user) {
            this.userMembers.add(user);
        }

        public Set<Group> getGroupMembers() {
            return new HashSet<Group>(this.groupMembers);
        }

        public Set<User> getUserMembers() {
            return new HashSet<User>(this.userMembers);
        }
    }
}

