/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.api.query;

import de.aservo.ldap.adapter.api.query.BinaryOperator;

public final class EqualOperator
extends BinaryOperator<EqualOperator> {
    private final String value;

    public EqualOperator(String attribute, String value, boolean negated, boolean ignoreCase) {
        super(attribute, negated, ignoreCase);
        this.value = value;
    }

    public EqualOperator(String attribute, String value) {
        this(attribute, value, false, true);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public EqualOperator negate() {
        return new EqualOperator(this.getAttribute(), this.getValue(), !this.isNegated(), this.isIgnoreCase());
    }

    @Override
    public boolean check(String value) {
        if (this.isIgnoreCase()) {
            return this.getValue().equalsIgnoreCase(value) != this.isNegated();
        }
        return this.getValue().equals(value) != this.isNegated();
    }
}

