/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.api.entity;

import de.aservo.ldap.adapter.api.database.Row;
import de.aservo.ldap.adapter.api.entity.EntityType;
import java.util.Objects;

public abstract class Entity
implements Row {
    private final String id;

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.id.equalsIgnoreCase(((Entity)that).id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Entity(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public <T> T apply(String columnName, Class<T> clazz) {
        try {
            return (T)this.findColumn(columnName);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot perform a cast for column " + columnName + " and with type [" + clazz.getName() + "].", e);
        }
    }

    protected abstract Object findColumn(String var1);

    public abstract EntityType getEntityType();
}

