/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.api.directory;

import de.aservo.ldap.adapter.api.cursor.MappableCursor;
import de.aservo.ldap.adapter.api.database.Row;
import de.aservo.ldap.adapter.api.directory.exception.EntityNotFoundException;
import de.aservo.ldap.adapter.api.entity.EntityType;
import de.aservo.ldap.adapter.api.entity.GroupEntity;
import de.aservo.ldap.adapter.api.entity.UserEntity;
import de.aservo.ldap.adapter.api.query.QueryExpression;
import java.util.Set;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public interface DirectoryBackend {
    public String getId();

    public void startup();

    public void shutdown();

    public MappableCursor<Row> runQueryExpression(String var1, SchemaManager var2, QueryExpression var3, EntityType var4);

    public GroupEntity getGroup(String var1) throws EntityNotFoundException;

    public UserEntity getUser(String var1) throws EntityNotFoundException;

    public UserEntity getAuthenticatedUser(String var1, String var2) throws EntityNotFoundException;

    public Set<GroupEntity> getAllGroups();

    public Set<GroupEntity> getAllGroups(int var1, int var2);

    public Set<UserEntity> getAllUsers();

    public Set<UserEntity> getAllUsers(int var1, int var2);

    public Set<UserEntity> getDirectUsersOfGroup(String var1) throws EntityNotFoundException;

    public Set<GroupEntity> getDirectGroupsOfUser(String var1) throws EntityNotFoundException;

    public Set<UserEntity> getTransitiveUsersOfGroup(String var1) throws EntityNotFoundException;

    public Set<GroupEntity> getTransitiveGroupsOfUser(String var1) throws EntityNotFoundException;

    public Set<GroupEntity> getDirectChildGroupsOfGroup(String var1) throws EntityNotFoundException;

    public Set<GroupEntity> getDirectParentGroupsOfGroup(String var1) throws EntityNotFoundException;

    public Set<GroupEntity> getTransitiveChildGroupsOfGroup(String var1) throws EntityNotFoundException;

    public Set<GroupEntity> getTransitiveParentGroupsOfGroup(String var1) throws EntityNotFoundException;
}

