/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter;

import de.aservo.ldap.adapter.CommonLdapServer;
import de.aservo.ldap.adapter.ServerConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger((String)"Bootloader");
        ServerConfiguration config = Main.createConfiguration();
        CommonLdapServer server = Main.createServerInstance(config);
        server.startup();
        logger.info("Starting directory listener...");
    }

    public static ServerConfiguration createConfiguration() {
        return Main.createConfiguration(new Properties());
    }

    public static ServerConfiguration createConfiguration(Properties properties) {
        return Main.createConfiguration(properties, properties);
    }

    public static ServerConfiguration createConfiguration(Properties serverProperties, Properties backendProperties) {
        String serverConfigFile = "etc/server.properties";
        String backendConfigFile = "etc/backend.properties";
        String log4j2ConfigFile = "etc/log4j2.xml";
        Properties finalServerProperties = Main.loadConfigFile(serverConfigFile);
        finalServerProperties.putAll((Map<?, ?>)System.getProperties());
        finalServerProperties.putAll((Map<?, ?>)serverProperties);
        Properties finalBackendProperties = Main.loadConfigFile(backendConfigFile);
        finalBackendProperties.putAll((Map<?, ?>)System.getProperties());
        finalBackendProperties.putAll((Map<?, ?>)backendProperties);
        Main.configLogging(log4j2ConfigFile, finalServerProperties);
        return new ServerConfiguration(finalServerProperties, finalBackendProperties);
    }

    public static CommonLdapServer createServerInstance(ServerConfiguration config) {
        return new CommonLdapServer(config);
    }

    private static void configLogging(String configFile, Properties properties) {
        String logLevel = properties.getProperty("log.level");
        URI configLocation = Files.exists(Paths.get(configFile, new String[0]), new LinkOption[0]) ? new File(configFile).toURI() : URI.create(configFile);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.setConfigLocation(configLocation);
        context.updateLoggers();
        if (logLevel != null) {
            context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            config.getLoggerConfig("").setLevel(Level.getLevel((String)logLevel.toUpperCase()));
            context.updateLoggers();
        }
    }

    private static Properties loadConfigFile(String configFile) {
        Properties properties;
        block25: {
            properties = new Properties();
            try {
                if (Files.exists(Paths.get(configFile, new String[0]), new LinkOption[0])) {
                    try (FileInputStream fis = new FileInputStream(configFile);
                         InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                        properties.load(isr);
                        break block25;
                    }
                }
                try (InputStream is = Main.class.getClassLoader().getResourceAsStream(configFile);){
                    if (is == null) {
                        throw new IllegalArgumentException("Cannot load resource " + configFile);
                    }
                    try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                        properties.load(isr);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return properties;
    }
}

