/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter;

import de.aservo.ldap.adapter.ServerConfiguration;
import de.aservo.ldap.adapter.api.directory.DirectoryBackend;
import de.aservo.ldap.adapter.api.directory.NestedDirectoryBackend;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class DirectoryBackendFactory {
    private final ServerConfiguration config;
    private final NestedDirectoryBackend directoryBackend;

    public DirectoryBackendFactory(ServerConfiguration config) {
        this.config = config;
        List<String> directoryBackendClasses = config.getPermanentDirectoryBackendClasses();
        if (directoryBackendClasses.isEmpty()) {
            throw new IndexOutOfBoundsException("Expect non empty sequence of directory backend classes.");
        }
        try {
            NestedDirectoryBackend innerDirectoryBackend = (NestedDirectoryBackend)Class.forName(directoryBackendClasses.get(0)).getConstructor(ServerConfiguration.class).newInstance(config);
            for (int i = 1; i < directoryBackendClasses.size(); ++i) {
                innerDirectoryBackend = (NestedDirectoryBackend)Class.forName(directoryBackendClasses.get(i)).getConstructor(ServerConfiguration.class, NestedDirectoryBackend.class).newInstance(config, innerDirectoryBackend);
            }
            this.directoryBackend = innerDirectoryBackend;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Missing class in permanent directory backend definition", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate permanent directory backend.", e);
        }
    }

    public DirectoryBackend getPermanentDirectory() {
        return this.directoryBackend;
    }

    public <T> T withSession(Function<DirectoryBackend, T> block) {
        NestedDirectoryBackend directory = this.createSessionSpecificDirectory();
        return (T)directory.withReadAccess(() -> block.apply(directory));
    }

    public void withSession(Consumer<DirectoryBackend> block) {
        this.withSession((DirectoryBackend x) -> {
            block.accept((DirectoryBackend)x);
            return null;
        });
    }

    public void startup() {
        this.directoryBackend.startup();
    }

    public void shutdown() {
        this.directoryBackend.shutdown();
    }

    private NestedDirectoryBackend createSessionSpecificDirectory() {
        List<String> directoryBackendClasses = this.config.getSessionDirectoryBackendClasses();
        NestedDirectoryBackend innerDirectoryBackend = this.directoryBackend;
        try {
            for (int i = 0; i < directoryBackendClasses.size(); ++i) {
                innerDirectoryBackend = (NestedDirectoryBackend)Class.forName(directoryBackendClasses.get(i)).getConstructor(ServerConfiguration.class, NestedDirectoryBackend.class).newInstance(this.config, innerDirectoryBackend);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Missing class in session specific directory backend definition", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate session specific directory backend.", e);
        }
        return innerDirectoryBackend;
    }
}

