/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter;

import de.aservo.ldap.adapter.DirectoryBackendFactory;
import de.aservo.ldap.adapter.api.LdapUtils;
import de.aservo.ldap.adapter.api.directory.DirectoryBackend;
import de.aservo.ldap.adapter.api.directory.exception.DirectoryAccessFailureException;
import de.aservo.ldap.adapter.api.directory.exception.EntityNotFoundException;
import de.aservo.ldap.adapter.api.directory.exception.SecurityProblemException;
import de.aservo.ldap.adapter.api.entity.UserEntity;
import de.aservo.ldap.adapter.api.exception.InternalServerException;
import java.nio.charset.StandardCharsets;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAuthenticator
extends AbstractAuthenticator {
    private final Logger logger = LoggerFactory.getLogger(CommonAuthenticator.class);
    private final DirectoryBackendFactory directoryBackendFactory;
    private final SchemaManager schemaManager;

    public CommonAuthenticator(DirectoryBackendFactory directoryBackendFactory, SchemaManager schemaManager) {
        super(AuthenticationLevel.SIMPLE);
        this.directoryBackendFactory = directoryBackendFactory;
        this.schemaManager = schemaManager;
    }

    public LdapPrincipal authenticate(BindOperationContext context) throws LdapException {
        DirectoryBackend directory = this.directoryBackendFactory.getPermanentDirectory();
        try {
            String userId = LdapUtils.getUserIdFromDn(this.schemaManager, context.getDn().getName(), directory.getId());
            if (userId == null) {
                throw new LdapInvalidDnException("Cannot handle unexpected DN=" + context.getDn());
            }
            String password = new String(context.getCredentials(), StandardCharsets.UTF_8);
            UserEntity user = directory.getAuthenticatedUser(userId, password);
            this.logger.info("[{}] - The user {} with DN={} has been successfully authenticated.", new Object[]{context.getIoSession().getRemoteAddress(), user.getId(), context.getDn()});
            return new LdapPrincipal(this.schemaManager, context.getDn(), AuthenticationLevel.SIMPLE);
        }
        catch (LdapInvalidDnException e) {
            this.logger.info("[{}] - Authentication with incorrect DN={} could not be performed.", (Object)context.getIoSession().getRemoteAddress(), (Object)context.getDn());
            this.logger.debug("Authentication failed.", (Throwable)e);
            throw new LdapAuthenticationException(e.getMessage());
        }
        catch (DirectoryAccessFailureException | EntityNotFoundException | SecurityProblemException e) {
            this.logger.info("[{}] - Authentication with DN={} could not be performed.", (Object)context.getIoSession().getRemoteAddress(), (Object)context.getDn());
            this.logger.debug("Authentication failed.", (Throwable)e);
            throw new LdapAuthenticationException(e.getMessage());
        }
        catch (Exception e) {
            this.logger.error("The authenticator caught an exception.", (Throwable)e);
            throw new InternalServerException("The authenticator has detected an internal server error.");
        }
    }
}

