/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.backend;

import de.aservo.ldap.adapter.ServerConfiguration;
import de.aservo.ldap.adapter.api.cursor.MappableCursor;
import de.aservo.ldap.adapter.api.database.CloseableTransaction;
import de.aservo.ldap.adapter.api.database.QueryDefFactory;
import de.aservo.ldap.adapter.api.database.Row;
import de.aservo.ldap.adapter.api.database.result.CursorResult;
import de.aservo.ldap.adapter.api.database.result.IgnoredResult;
import de.aservo.ldap.adapter.api.database.result.IndexedSeqResult;
import de.aservo.ldap.adapter.api.database.result.SingleOptResult;
import de.aservo.ldap.adapter.api.database.result.SingleResult;
import de.aservo.ldap.adapter.api.directory.NestedDirectoryBackend;
import de.aservo.ldap.adapter.api.directory.exception.EntityNotFoundException;
import de.aservo.ldap.adapter.api.entity.EntityType;
import de.aservo.ldap.adapter.api.entity.GroupEntity;
import de.aservo.ldap.adapter.api.entity.MembershipEntity;
import de.aservo.ldap.adapter.api.entity.UserEntity;
import de.aservo.ldap.adapter.api.query.QueryExpression;
import de.aservo.ldap.adapter.backend.CachedDirectoryBackend;
import de.aservo.ldap.adapter.sql.impl.DatabaseService;
import de.aservo.ldap.adapter.sql.impl.QueryGenerator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedWithPersistenceDirectoryBackend
extends CachedDirectoryBackend {
    public static final String CONFIG_DB_DRIVER = "database.jdbc.driver";
    public static final String CONFIG_DB_URL = "database.jdbc.connection.url";
    public static final String CONFIG_DB_USER = "database.jdbc.connection.user";
    public static final String CONFIG_DB_PW = "database.jdbc.connection.password";
    public static final String CONFIG_DB_MIN_IDLE = "database.jdbc.connection.min-idle";
    public static final String CONFIG_DB_MAX_IDLE = "database.jdbc.connection.max-idle";
    public static final String CONFIG_DB_MAX_TOTAL = "database.jdbc.connection.max-total";
    public static final String CONFIG_DB_MAX_OPEN_STMT = "database.jdbc.connection.max-open-prepared-statements";
    public static final String CONFIG_DB_ISO_LEVEL = "database.jdbc.connection.isolation-level";
    public static final String CONFIG_TRANSACTION_TIMEOUT = "persistence.transaction-timeout";
    public static final String CONFIG_APPLY_NATIVE_SQL = "persistence.apply-native-sql";
    public static final String CONFIG_USE_MATERIALIZED_VIEWS = "persistence.use-materialized-views";
    public static final String CONFIG_PASS_ACTIVE_USERS_ONLY = "persistence.pass-active-users-only";
    public static final String CONFIG_ACQUIREDBLOCK_WAIT_TIME = "persistence.acquiredblock-wait-time";
    public static final String CONFIG_ACQUIREDBLOCK_RECHECK_TIME = "persistence.acquiredblock-recheck-time";
    private final Logger logger = LoggerFactory.getLogger(CachedWithPersistenceDirectoryBackend.class);
    private final Map<Long, QueryDefFactory> queryDefFactories = Collections.synchronizedMap(new HashMap());
    private final Map<String, CloseableTransactionWrapper> closeableTransactions = Collections.synchronizedMap(new HashMap());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final DatabaseService dbService;
    private final int transactionTimeout;
    private final boolean applyNativeSql;
    private final boolean useMaterializedViews;
    private final boolean activeUsersOnly;
    private final int acquireDbLockWaitTime;
    private final int acquireDbLockRecheckTime;

    public CachedWithPersistenceDirectoryBackend(ServerConfiguration config, NestedDirectoryBackend directoryBackend) {
        super(config, directoryBackend);
        int isolationLevel;
        Properties properties = config.getBackendProperties();
        String driver = properties.getProperty(CONFIG_DB_DRIVER);
        String url = properties.getProperty(CONFIG_DB_URL);
        String user = properties.getProperty(CONFIG_DB_USER);
        String password = properties.getProperty(CONFIG_DB_PW);
        String minIdleValue = properties.getProperty(CONFIG_DB_MIN_IDLE);
        String maxIdleValue = properties.getProperty(CONFIG_DB_MAX_IDLE);
        String maxTotalValue = properties.getProperty(CONFIG_DB_MAX_TOTAL);
        String maxOpenPreparedStatementsValue = properties.getProperty(CONFIG_DB_MAX_OPEN_STMT);
        String isolationLevelValue = properties.getProperty(CONFIG_DB_ISO_LEVEL);
        String transactionTimeoutValue = properties.getProperty(CONFIG_TRANSACTION_TIMEOUT);
        if (transactionTimeoutValue == null) {
            throw new IllegalArgumentException("Missing value for persistence.transaction-timeout");
        }
        this.transactionTimeout = Integer.parseInt(transactionTimeoutValue);
        this.applyNativeSql = Boolean.parseBoolean(properties.getProperty(CONFIG_APPLY_NATIVE_SQL, "false"));
        this.useMaterializedViews = Boolean.parseBoolean(properties.getProperty(CONFIG_USE_MATERIALIZED_VIEWS, "false"));
        this.activeUsersOnly = Boolean.parseBoolean(properties.getProperty(CONFIG_PASS_ACTIVE_USERS_ONLY, "true"));
        this.acquireDbLockWaitTime = Integer.parseInt(properties.getProperty(CONFIG_ACQUIREDBLOCK_WAIT_TIME, "3"));
        this.acquireDbLockRecheckTime = Integer.parseInt(properties.getProperty(CONFIG_ACQUIREDBLOCK_RECHECK_TIME, "1"));
        if (driver == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.driver");
        }
        if (url == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.url");
        }
        if (user == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.user");
        }
        if (password == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.password");
        }
        if (minIdleValue == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.min-idle");
        }
        if (maxIdleValue == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.max-idle");
        }
        if (maxTotalValue == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.max-total");
        }
        if (maxOpenPreparedStatementsValue == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.max-open-prepared-statements");
        }
        if (isolationLevelValue == null) {
            throw new IllegalArgumentException("Missing value for database.jdbc.connection.isolation-level");
        }
        int minIdle = Integer.parseInt(minIdleValue);
        int maxIdle = Integer.parseInt(maxIdleValue);
        int maxTotal = Integer.parseInt(maxTotalValue);
        int maxOpenPreparedStatements = Integer.parseInt(maxOpenPreparedStatementsValue);
        if (minIdle < 1 || maxIdle < 1 || maxTotal < 1 || maxOpenPreparedStatements < 1) {
            throw new IllegalArgumentException("Expect connection pool limits greater than one.");
        }
        if (isolationLevelValue.equalsIgnoreCase("NONE")) {
            isolationLevel = 0;
        } else if (isolationLevelValue.equalsIgnoreCase("READ_UNCOMMITTED")) {
            isolationLevel = 1;
        } else if (isolationLevelValue.equalsIgnoreCase("READ_COMMITTED")) {
            isolationLevel = 2;
        } else if (isolationLevelValue.equalsIgnoreCase("REPEATABLE_READ")) {
            isolationLevel = 4;
        } else if (isolationLevelValue.equalsIgnoreCase("SERIALIZABLE")) {
            isolationLevel = 8;
        } else {
            throw new IllegalArgumentException("Expect valid isolation level.");
        }
        this.dbService = new DatabaseService(this.logger, driver, url, user, password, minIdle, maxIdle, maxTotal, maxOpenPreparedStatements, isolationLevel, this.applyNativeSql);
    }

    @Override
    public void startup() {
        super.startup();
        this.dbService.startup();
        this.scheduler.scheduleAtFixedRate(this::clearCloseableTransaction, 3L, 4L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        this.dbService.shutdown();
        super.shutdown();
    }

    @Override
    public <T> T withReadAccess(Supplier<T> block) {
        return this.processTransaction(true, block);
    }

    @Override
    public void withReadAccess(Runnable block) {
        this.withReadAccess(() -> {
            block.run();
            return null;
        });
    }

    @Override
    public <T> T withWriteAccess(Supplier<T> block) {
        return (T)this.processTransaction(false, () -> {
            Object result = block.get();
            if (this.useMaterializedViews) {
                QueryDefFactory factory = this.getCurrentQueryDefFactory();
                this.logger.debug("Starting materialized views refresh.");
                factory.queryById("refresh_materialized_view_for_transitive_group_memberships").execute(IgnoredResult.class);
                factory.queryById("refresh_materialized_view_for_transitive_user_memberships").execute(IgnoredResult.class);
                this.logger.debug("Finished materialized views refresh.");
            }
            return result;
        });
    }

    @Override
    public void withWriteAccess(Runnable block) {
        this.withWriteAccess(() -> {
            block.run();
            return null;
        });
    }

    @Override
    public boolean requireReset() {
        return this.dbService.hasUpdatedSchema();
    }

    @Override
    public void upsertGroup(String id) {
        super.upsertGroup(id);
        try {
            GroupEntity entity = this.directoryBackend.getGroup(id);
            QueryDefFactory factory = this.getCurrentQueryDefFactory();
            factory.queryById("create_or_update_group").on("id", entity.getId()).on("name", entity.getName()).on("description", Optional.ofNullable(entity.getDescription())).execute(IgnoredResult.class);
        }
        catch (EntityNotFoundException e) {
            this.logger.warn("The group entity no longer exists.", (Throwable)e);
        }
    }

    @Override
    public int upsertAllGroups(int startIndex, int maxResults) {
        super.upsertAllGroups(startIndex, maxResults);
        Set<GroupEntity> entities = this.directoryBackend.getAllGroups(startIndex, maxResults);
        entities.forEach(entity -> {
            QueryDefFactory factory = this.getCurrentQueryDefFactory();
            factory.queryById("create_or_update_group").on("id", entity.getId()).on("name", entity.getName()).on("description", Optional.ofNullable(entity.getDescription())).execute(IgnoredResult.class);
        });
        return entities.size();
    }

    @Override
    public int upsertAllGroups() {
        super.upsertAllGroups();
        Set<GroupEntity> entities = this.directoryBackend.getAllGroups();
        entities.forEach(entity -> {
            QueryDefFactory factory = this.getCurrentQueryDefFactory();
            factory.queryById("create_or_update_group").on("id", entity.getId()).on("name", entity.getName()).on("description", Optional.ofNullable(entity.getDescription())).execute(IgnoredResult.class);
        });
        return entities.size();
    }

    @Override
    public void upsertUser(String id) {
        super.upsertUser(id);
        try {
            UserEntity entity = this.directoryBackend.getUser(id);
            QueryDefFactory factory = this.getCurrentQueryDefFactory();
            factory.queryById("create_or_update_user").on("id", entity.getId()).on("username", entity.getUsername()).on("last_name", Optional.ofNullable(entity.getLastName())).on("first_name", Optional.ofNullable(entity.getFirstName())).on("display_name", Optional.ofNullable(entity.getDisplayName())).on("email", Optional.ofNullable(entity.getEmail())).on("active", entity.isActive()).execute(IgnoredResult.class);
        }
        catch (EntityNotFoundException e) {
            this.logger.warn("The user entity no longer exists.", (Throwable)e);
        }
    }

    @Override
    public void upsertUser(String id, String idOther) {
        super.upsertUser(id, idOther);
        this.upsertUser(id);
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        this.getDirectGroupsOfUser(idOther).forEach(group -> factory.queryById("create_user_membership_if_not_exists").on("parent_group_id", group.getName()).on("member_user_id", id).execute(IgnoredResult.class));
    }

    @Override
    public int upsertAllUsers(int startIndex, int maxResults) {
        super.upsertAllUsers(startIndex, maxResults);
        Set<UserEntity> entities = this.directoryBackend.getAllUsers(startIndex, maxResults);
        entities.forEach(entity -> {
            QueryDefFactory factory = this.getCurrentQueryDefFactory();
            factory.queryById("create_or_update_user").on("id", entity.getId()).on("username", entity.getUsername()).on("last_name", Optional.ofNullable(entity.getLastName())).on("first_name", Optional.ofNullable(entity.getFirstName())).on("display_name", Optional.ofNullable(entity.getDisplayName())).on("email", Optional.ofNullable(entity.getEmail())).on("active", entity.isActive()).execute(IgnoredResult.class);
        });
        return entities.size();
    }

    @Override
    public int upsertAllUsers() {
        super.upsertAllUsers();
        Set<UserEntity> entities = this.directoryBackend.getAllUsers();
        entities.forEach(entity -> {
            QueryDefFactory factory = this.getCurrentQueryDefFactory();
            factory.queryById("create_or_update_user").on("id", entity.getId()).on("username", entity.getUsername()).on("last_name", Optional.ofNullable(entity.getLastName())).on("first_name", Optional.ofNullable(entity.getFirstName())).on("display_name", Optional.ofNullable(entity.getDisplayName())).on("email", Optional.ofNullable(entity.getEmail())).on("active", entity.isActive()).execute(IgnoredResult.class);
        });
        return entities.size();
    }

    @Override
    public void upsertMembership(MembershipEntity membership) {
        super.upsertMembership(membership);
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        membership.getMemberGroupIds().forEach(id -> factory.queryById("create_group_membership_if_not_exists").on("parent_group_id", membership.getParentGroupId()).on("member_group_id", id).execute(IgnoredResult.class));
        membership.getMemberUserIds().forEach(id -> factory.queryById("create_user_membership_if_not_exists").on("parent_group_id", membership.getParentGroupId()).on("member_user_id", id).execute(IgnoredResult.class));
    }

    @Override
    public void dropGroup(String id) {
        super.dropGroup(id);
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        factory.queryById("remove_group_if_exists").on("id", id).execute(IgnoredResult.class);
    }

    @Override
    public void dropAllGroups() {
        super.dropAllGroups();
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        factory.queryById("remove_all_groups").execute(IgnoredResult.class);
    }

    @Override
    public void dropUser(String id) {
        super.dropUser(id);
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        factory.queryById("remove_user_if_exists").on("id", id).execute(IgnoredResult.class);
    }

    @Override
    public void dropAllUsers() {
        super.dropAllUsers();
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        factory.queryById("remove_all_users").execute(IgnoredResult.class);
    }

    @Override
    public void dropMembership(MembershipEntity membership) {
        super.dropMembership(membership);
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        membership.getMemberGroupIds().forEach(id -> factory.queryById("remove_group_membership_if_exists").on("parent_group_id", membership.getParentGroupId()).on("member_group_id", id).execute(IgnoredResult.class));
        membership.getMemberUserIds().forEach(id -> factory.queryById("remove_user_membership_if_exists").on("parent_group_id", membership.getParentGroupId()).on("member_user_id", id).execute(IgnoredResult.class));
    }

    @Override
    public MappableCursor<Row> runQueryExpression(String txId, SchemaManager schemaManager, QueryExpression expression, EntityType entityType) {
        QueryGenerator generator = new QueryGenerator(schemaManager, this.getId(), this.config.isFlatteningEnabled(), this.activeUsersOnly, this.useMaterializedViews);
        return this.addCursorCleanup(txId, generator.generate(entityType, this.getCloseableTransaction(txId).getQueryDefFactory(), expression).execute(CursorResult.class).transform(Function.identity()));
    }

    @Override
    public GroupEntity getGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return factory.queryById("find_group").on("id", id).execute(SingleOptResult.class).transform(this::mapGroupEntity).orElseThrow(() -> new EntityNotFoundException("Cannot find group in persistent cache."));
    }

    @Override
    public UserEntity getUser(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return factory.queryById("find_user").on("id", id).on("active_only", this.activeUsersOnly).execute(SingleOptResult.class).transform(this::mapUserEntity).orElseThrow(() -> new EntityNotFoundException("Cannot find user in persistent cache."));
    }

    @Override
    public Set<GroupEntity> getAllGroups() {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return new HashSet<GroupEntity>(factory.queryById("find_all_groups").execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public Set<UserEntity> getAllUsers() {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return new HashSet<UserEntity>(factory.queryById("find_all_users").on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapUserEntity));
    }

    @Override
    public Set<UserEntity> getDirectUsersOfGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return new HashSet<UserEntity>(factory.queryById("find_direct_users_of_group").on("group_id", id).on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapUserEntity));
    }

    @Override
    public Set<GroupEntity> getDirectGroupsOfUser(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return new HashSet<GroupEntity>(factory.queryById("find_direct_groups_of_user").on("user_id", id).on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public Set<GroupEntity> getDirectChildGroupsOfGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return new HashSet<GroupEntity>(factory.queryById("find_direct_child_groups_of_group").on("group_id", id).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public Set<GroupEntity> getDirectParentGroupsOfGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        return new HashSet<GroupEntity>(factory.queryById("find_direct_parent_groups_of_group").on("group_id", id).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public Set<UserEntity> getTransitiveUsersOfGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        if (this.useMaterializedViews) {
            return new HashSet<UserEntity>(factory.queryById("find_transitive_users_of_group").on("group_id", id).on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapUserEntity));
        }
        return new HashSet<UserEntity>(factory.queryById("find_transitive_users_of_group_non_materialized").on("group_id", id).on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapUserEntity));
    }

    @Override
    public Set<GroupEntity> getTransitiveGroupsOfUser(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        if (this.useMaterializedViews) {
            return new HashSet<GroupEntity>(factory.queryById("find_transitive_groups_of_user").on("user_id", id).on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
        }
        return new HashSet<GroupEntity>(factory.queryById("find_transitive_groups_of_user_non_materialized").on("user_id", id).on("active_only", this.activeUsersOnly).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public Set<GroupEntity> getTransitiveChildGroupsOfGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        if (this.useMaterializedViews) {
            return new HashSet<GroupEntity>(factory.queryById("find_transitive_child_groups_of_group").on("group_id", id).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
        }
        return new HashSet<GroupEntity>(factory.queryById("find_transitive_child_groups_of_group_non_materialized").on("group_id", id).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public Set<GroupEntity> getTransitiveParentGroupsOfGroup(String id) throws EntityNotFoundException {
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        if (this.useMaterializedViews) {
            return new HashSet<GroupEntity>(factory.queryById("find_transitive_parent_groups_of_group").on("group_id", id).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
        }
        return new HashSet<GroupEntity>(factory.queryById("find_transitive_parent_groups_of_group_non_materialized").on("group_id", id).execute(IndexedSeqResult.class).transform(this::mapGroupEntity));
    }

    @Override
    public boolean acquireDbLock(int lockId) {
        boolean locked = false;
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        long timeToGiveUp = System.currentTimeMillis() + (long)this.acquireDbLockWaitTime * 1000L;
        while (!locked && System.currentTimeMillis() < timeToGiveUp) {
            locked = Boolean.TRUE.equals(factory.queryById("pg_acquireLock").on("lock_id", lockId).execute(SingleResult.class).transform(this::mapAcquireDbLockResult));
            if (locked) continue;
            this.logger.info("Waiting for sync dblock....");
            try {
                Thread.sleep((long)this.acquireDbLockRecheckTime * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return locked;
    }

    @Override
    public void releaseDbLock(int lockId) {
        boolean unlocked = false;
        QueryDefFactory factory = this.getCurrentQueryDefFactory();
        try {
            unlocked = Boolean.TRUE.equals(factory.queryById("pg_releaseLock").on("lock_id", lockId).executeWithAutoCommit(SingleResult.class).transform(this::mapReleaseDbLockResult));
            if (!unlocked) {
                this.logger.warn("Release of sync dblock failed, probably lock no longer exists.");
            } else {
                this.logger.info("syncdblock released.");
            }
        }
        catch (Exception e) {
            this.logger.error("An error occurred when releasing the syncdblock", (Throwable)e);
        }
    }

    private <T> T processTransaction(boolean readOnly, Supplier<T> block) {
        return (T)this.dbService.withTransaction(factory -> {
            Object result;
            long id = Thread.currentThread().getId();
            this.logger.debug("[Thread ID {}] - Bind query definition factory to thread.", (Object)id);
            this.queryDefFactories.put(id, (QueryDefFactory)factory);
            try {
                result = readOnly ? super.withReadAccess(block) : super.withWriteAccess(block);
            }
            finally {
                this.queryDefFactories.remove(id);
            }
            return result;
        });
    }

    private void clearCloseableTransaction() {
        new HashMap<String, CloseableTransactionWrapper>(this.closeableTransactions).forEach((txId, transaction) -> {
            if (System.currentTimeMillis() - transaction.timestamp > (long)this.transactionTimeout) {
                try {
                    transaction.closeUnchecked(new TimeoutException("A transaction was terminated after timeout."));
                }
                catch (Exception e) {
                    this.logger.warn("A transaction cleanup was performed.", (Throwable)e);
                }
                finally {
                    this.closeableTransactions.remove(txId);
                }
            }
        });
    }

    private CloseableTransaction getCloseableTransaction(String txId) {
        if (this.closeableTransactions.containsKey(txId)) {
            this.closeableTransactions.get((Object)txId).counter.incrementAndGet();
        } else {
            this.closeableTransactions.put(txId, new CloseableTransactionWrapper(this.dbService.getCloseableTransaction()));
        }
        return this.closeableTransactions.get(txId);
    }

    private QueryDefFactory getCurrentQueryDefFactory() {
        return this.queryDefFactories.get(Thread.currentThread().getId());
    }

    private MappableCursor<Row> addCursorCleanup(final String txId, final MappableCursor<Row> rows) {
        return new MappableCursor<Row>(){

            @Override
            public boolean next() {
                return rows.next();
            }

            @Override
            public Row get() {
                return (Row)rows.get();
            }

            @Override
            public void close() throws IOException {
                CloseableTransactionWrapper transaction = CachedWithPersistenceDirectoryBackend.this.closeableTransactions.get(txId);
                int count = transaction.counter.decrementAndGet();
                rows.close();
                if (count == 0) {
                    CachedWithPersistenceDirectoryBackend.this.logger.debug("[Thread ID {}] - Close async transaction.", (Object)Thread.currentThread().getId());
                    try {
                        transaction.close();
                    }
                    finally {
                        CachedWithPersistenceDirectoryBackend.this.closeableTransactions.remove(txId);
                    }
                }
            }
        };
    }

    private GroupEntity mapGroupEntity(Row row) {
        return new GroupEntity(row.apply("name", String.class), row.apply("description", String.class));
    }

    private UserEntity mapUserEntity(Row row) {
        return new UserEntity(row.apply("username", String.class), row.apply("last_name", String.class), row.apply("first_name", String.class), row.apply("display_name", String.class), row.apply("email", String.class), row.apply("active", Boolean.class));
    }

    private Boolean mapAcquireDbLockResult(Row row) {
        return row.apply("pg_try_advisory_lock", Boolean.class);
    }

    private Boolean mapReleaseDbLockResult(Row row) {
        return row.apply("pg_advisory_unlock", Boolean.class);
    }

    private static class CloseableTransactionWrapper
    implements CloseableTransaction {
        private final CloseableTransaction transaction;
        public final AtomicInteger counter = new AtomicInteger(1);
        public final long timestamp = System.currentTimeMillis();

        public CloseableTransactionWrapper(CloseableTransaction transaction) {
            this.transaction = transaction;
        }

        @Override
        public QueryDefFactory getQueryDefFactory() {
            return this.transaction.getQueryDefFactory();
        }

        @Override
        public void close(Exception cause) throws IOException {
            this.transaction.close(cause);
        }

        @Override
        public void close() throws IOException {
            this.transaction.close();
        }
    }
}

