/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class ServerConfiguration {
    public static final String CONFIG_DS_CACHE_DIR = "ds-cache-directory";
    public static final String CONFIG_BIND_ADDRESS = "bind.address";
    public static final String CONFIG_SSL_ENABLED = "ssl.enabled";
    public static final String CONFIG_SSL_KEY_STORE_FILE = "ssl.key-store-file";
    public static final String CONFIG_SSL_KEY_STORE_PW = "ssl.key-store-password";
    public static final String CONFIG_MODE_FLATTENING = "mode.flattening";
    public static final String CONFIG_RESPONSE_MAX_SIZE_LIMIT = "mode.response.max-size-limit";
    public static final String CONFIG_RESPONSE_MAX_TIME_LIMIT = "mode.response.max-time-limit";
    public static final String CONFIG_CONNECTION_BACK_LOG = "mode.connection.back-log";
    public static final String CONFIG_CONNECTION_ACTIVE_THREADS = "mode.connection.active-threads";
    public static final String CONFIG_DIRECTORY_BACKEND_PERMANENT = "directory-backend.permanent";
    public static final String CONFIG_DIRECTORY_BACKEND_SESSION = "directory-backend.session";
    public static final String CONFIG_ABBREVIATE_SN_ATTRIBUTE = "attribute.sn.abbreviate";
    public static final String CONFIG_ABBREVIATE_GN_ATTRIBUTE = "attribute.gn.abbreviate";
    public static final String CONFIG_BASE_DN_DESCRIPTION = "base-dn.description";
    public static final String CONFIG_BASE_DN_GROUPS_DESCRIPTION = "base-dn-groups.description";
    public static final String CONFIG_BASE_DN_USERS_DESCRIPTION = "base-dn-users.description";
    private final Properties backendProperties;
    private final Path cacheDir;
    private final String host;
    private final int port;
    private final boolean sslEnabled;
    private final Path keyStoreFile;
    private final String keyStorePassword;
    private final boolean flattening;
    private final int responseMaxSizeLimit;
    private final int responseMaxTimeLimit;
    private final int connectionBackLog;
    private final int connectionActiveThreads;
    private final List<String> permanentDirectoryBackendClasses;
    private final List<String> sessionDirectoryBackendClasses;
    private final boolean abbreviateSn;
    private final boolean abbreviateGn;
    private final String baseDnDescription;
    private final String baseDnGroupsDescription;
    private final String baseDnUsersDescription;

    public ServerConfiguration(Properties serverProperties, Properties backendProperties) {
        this.backendProperties = this.copyProperties(backendProperties);
        this.cacheDir = Paths.get(serverProperties.getProperty(CONFIG_DS_CACHE_DIR, "./cache"), new String[0]).toAbsolutePath().normalize();
        String bindAddressValue = serverProperties.getProperty(CONFIG_BIND_ADDRESS, "localhost:10389");
        String[] bindAddressParts = bindAddressValue.split(":");
        if (bindAddressParts.length != 2 || bindAddressParts[0].isEmpty() || bindAddressParts[1].isEmpty()) {
            throw new IllegalArgumentException("Cannot parse value for bind.address");
        }
        this.host = bindAddressParts[0];
        this.port = Integer.parseInt(bindAddressParts[1]);
        this.sslEnabled = Boolean.parseBoolean(serverProperties.getProperty(CONFIG_SSL_ENABLED, "false"));
        if (this.sslEnabled) {
            String keyStoreFileValue = serverProperties.getProperty(CONFIG_SSL_KEY_STORE_FILE);
            if (keyStoreFileValue == null) {
                throw new IllegalArgumentException("Missing value for ssl.key-store-file");
            }
            this.keyStoreFile = Paths.get(keyStoreFileValue, new String[0]).toAbsolutePath().normalize();
            this.keyStorePassword = serverProperties.getProperty(CONFIG_SSL_KEY_STORE_PW);
            if (this.keyStorePassword == null) {
                throw new IllegalArgumentException("Missing value for ssl.key-store-password");
            }
        } else {
            this.keyStoreFile = null;
            this.keyStorePassword = null;
        }
        this.flattening = Boolean.parseBoolean(serverProperties.getProperty(CONFIG_MODE_FLATTENING, "true"));
        this.responseMaxSizeLimit = Integer.parseInt(serverProperties.getProperty(CONFIG_RESPONSE_MAX_SIZE_LIMIT, "50000"));
        this.responseMaxTimeLimit = Integer.parseInt(serverProperties.getProperty(CONFIG_RESPONSE_MAX_SIZE_LIMIT, "1000"));
        this.connectionBackLog = Integer.parseInt(serverProperties.getProperty(CONFIG_CONNECTION_BACK_LOG, "100"));
        this.connectionActiveThreads = Integer.parseInt(serverProperties.getProperty(CONFIG_CONNECTION_ACTIVE_THREADS, "20"));
        if (this.responseMaxSizeLimit <= 0) {
            throw new IllegalArgumentException("Expect value for mode.response.max-size-limit greater than zero.");
        }
        String permanentDirectoryBackendClassesValue = serverProperties.getProperty(CONFIG_DIRECTORY_BACKEND_PERMANENT);
        String sessionDirectoryBackendClassesValue = serverProperties.getProperty(CONFIG_DIRECTORY_BACKEND_SESSION);
        if (permanentDirectoryBackendClassesValue == null || permanentDirectoryBackendClassesValue.isEmpty()) {
            throw new IllegalArgumentException("Missing value for directory-backend.permanent");
        }
        if (sessionDirectoryBackendClassesValue == null) {
            throw new IllegalArgumentException("Missing value for directory-backend.session");
        }
        this.permanentDirectoryBackendClasses = Arrays.stream(permanentDirectoryBackendClassesValue.split(",")).map(x -> x.trim()).filter(x -> !x.isEmpty()).collect(Collectors.toList());
        this.sessionDirectoryBackendClasses = Arrays.stream(sessionDirectoryBackendClassesValue.split(",")).map(x -> x.trim()).filter(x -> !x.isEmpty()).collect(Collectors.toList());
        this.abbreviateSn = Boolean.parseBoolean(serverProperties.getProperty(CONFIG_ABBREVIATE_SN_ATTRIBUTE, "false"));
        this.abbreviateGn = Boolean.parseBoolean(serverProperties.getProperty(CONFIG_ABBREVIATE_GN_ATTRIBUTE, "false"));
        this.baseDnDescription = serverProperties.getProperty(CONFIG_BASE_DN_DESCRIPTION, "");
        this.baseDnGroupsDescription = serverProperties.getProperty(CONFIG_BASE_DN_GROUPS_DESCRIPTION, "");
        this.baseDnUsersDescription = serverProperties.getProperty(CONFIG_BASE_DN_USERS_DESCRIPTION, "");
    }

    public Properties getBackendProperties() {
        return this.copyProperties(this.backendProperties);
    }

    public Path getDsCacheDir() {
        return this.cacheDir;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public Path getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean isFlatteningEnabled() {
        return this.flattening;
    }

    public int getResponseMaxSizeLimit() {
        return this.responseMaxSizeLimit;
    }

    public int getResponseMaxTimeLimit() {
        return this.responseMaxTimeLimit;
    }

    public int getConnectionBackLog() {
        return this.connectionBackLog;
    }

    public int getConnectionActiveThreads() {
        return this.connectionActiveThreads;
    }

    public List<String> getPermanentDirectoryBackendClasses() {
        return new ArrayList<String>(this.permanentDirectoryBackendClasses);
    }

    public List<String> getSessionDirectoryBackendClasses() {
        return new ArrayList<String>(this.sessionDirectoryBackendClasses);
    }

    public boolean isAbbreviateSnAttribute() {
        return this.abbreviateSn;
    }

    public boolean isAbbreviateGnAttribute() {
        return this.abbreviateGn;
    }

    public String getBaseDnDescription() {
        return this.baseDnDescription;
    }

    public String getBaseDnGroupsDescription() {
        return this.baseDnGroupsDescription;
    }

    public String getBaseDnUsersDescription() {
        return this.baseDnUsersDescription;
    }

    private Properties copyProperties(Properties properties) {
        Properties result = new Properties();
        if (properties != null) {
            result.putAll((Map<?, ?>)properties);
        }
        return result;
    }
}

