/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.api.query;

import de.aservo.ldap.adapter.api.query.OperatorExpression;
import java.util.Objects;

public abstract class BinaryOperator<T extends BinaryOperator<?>>
implements OperatorExpression<T> {
    private final String attribute;
    private final boolean negated;
    private final boolean ignoreCase;

    public BinaryOperator(String attribute, boolean negated, boolean ignoreCase) {
        this.attribute = attribute;
        this.negated = negated;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    public abstract String getValue();

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        if (this.ignoreCase) {
            return this.getAttribute().equalsIgnoreCase(((BinaryOperator)that).getAttribute()) && this.getValue().equalsIgnoreCase(((BinaryOperator)that).getValue());
        }
        return this.getAttribute().equals(((BinaryOperator)that).getAttribute()) && this.getValue().equals(((BinaryOperator)that).getValue());
    }

    public int hashCode() {
        if (this.ignoreCase) {
            return Objects.hash(this.getClass().getSimpleName(), this.getAttribute().toLowerCase(), this.getValue().toLowerCase());
        }
        return Objects.hash(this.getClass().getSimpleName(), this.getAttribute(), this.getValue());
    }
}

