/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter.api.cursor.apacheds;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;

public class EntryFilteringWrapperCursor
extends AbstractCursor<Entry>
implements EntryFilteringCursor {
    private final Cursor<Entry> entries;
    private final SearchOperationContext operationContext;
    private final List<EntryFilter> filters;

    public EntryFilteringWrapperCursor(Cursor<Entry> entries, SearchOperationContext operationContext) {
        this.entries = entries;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
    }

    public boolean addEntryFilter(EntryFilter filter) {
        return this.filters.add(filter);
    }

    public List<EntryFilter> getEntryFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public SearchOperationContext getOperationContext() {
        return this.operationContext;
    }

    public void before(Entry attributes) throws LdapException, CursorException {
        this.entries.before((Object)attributes);
    }

    public void after(Entry attributes) throws LdapException, CursorException {
        this.entries.after((Object)attributes);
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.entries.beforeFirst();
    }

    public void afterLast() throws LdapException, CursorException {
        this.entries.afterLast();
    }

    public boolean first() throws LdapException, CursorException {
        return this.entries.first();
    }

    public boolean last() throws LdapException, CursorException {
        return this.entries.last();
    }

    public boolean previous() throws LdapException, CursorException {
        return this.entries.previous();
    }

    public boolean available() {
        return this.entries.available();
    }

    public void close() throws IOException {
        super.close();
        this.entries.close();
    }

    public void close(Exception cause) throws IOException {
        super.close(cause);
        this.entries.close(cause);
    }

    public boolean next() throws LdapException, CursorException {
        return this.entries.next();
    }

    public Entry get() throws InvalidCursorPositionException {
        Entry entry;
        try {
            entry = (Entry)this.entries.get();
        }
        catch (CursorException e) {
            throw new InvalidCursorPositionException(e.getMessage());
        }
        if (!(entry instanceof ClonedServerEntry)) {
            entry = new ClonedServerEntry(entry);
        }
        return entry;
    }
}

