/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter;

import de.aservo.ldap.adapter.DirectoryBackendFactory;
import de.aservo.ldap.adapter.ServerConfiguration;
import de.aservo.ldap.adapter.SimpleReadOnlyPartition;
import de.aservo.ldap.adapter.api.LdapUtils;
import de.aservo.ldap.adapter.api.cursor.MappableCursor;
import de.aservo.ldap.adapter.api.cursor.apacheds.EntryFilteringWrapperCursor;
import de.aservo.ldap.adapter.api.cursor.apacheds.IterableEntryCursor;
import de.aservo.ldap.adapter.api.database.Row;
import de.aservo.ldap.adapter.api.database.exception.UnknownColumnException;
import de.aservo.ldap.adapter.api.entity.DomainEntity;
import de.aservo.ldap.adapter.api.entity.EntityType;
import de.aservo.ldap.adapter.api.entity.GroupUnitEntity;
import de.aservo.ldap.adapter.api.entity.UserUnitEntity;
import de.aservo.ldap.adapter.api.query.AndLogicExpression;
import de.aservo.ldap.adapter.api.query.BooleanValue;
import de.aservo.ldap.adapter.api.query.EqualOperator;
import de.aservo.ldap.adapter.api.query.QueryExpression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.SingletonCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPartition
extends SimpleReadOnlyPartition {
    private final Logger logger = LoggerFactory.getLogger(CommonPartition.class);
    private final DirectoryBackendFactory directoryFactory;
    private final ServerConfiguration serverConfig;
    private DomainEntity domainEntity;
    private GroupUnitEntity groupUnitEntity;
    private UserUnitEntity userUnitEntity;

    public CommonPartition(ServerConfiguration serverConfig, DirectoryBackendFactory directoryFactory) {
        this.serverConfig = serverConfig;
        this.directoryFactory = directoryFactory;
        this.setId(directoryFactory.getPermanentDirectory().getId());
    }

    protected void doInit() throws LdapException {
        this.setSuffixDn(LdapUtils.createDn(this.schemaManager, EntityType.DOMAIN, this.getId()));
        this.domainEntity = new DomainEntity(this.directoryFactory.getPermanentDirectory().getId(), this.serverConfig.getBaseDnDescription());
        this.groupUnitEntity = new GroupUnitEntity(this.serverConfig.getBaseDnGroupsDescription());
        this.userUnitEntity = new UserUnitEntity(this.serverConfig.getBaseDnUsersDescription());
    }

    @Override
    protected void doDestroy() throws LdapException {
    }

    public ClonedServerEntry lookup(LookupOperationContext context) throws LdapException {
        this.logger.info("[{}] - Perform lookup operation for entry with DN={}", (Object)context.getSession().getClientAddress(), (Object)context.getDn().getName());
        PartitionTxn transaction = context.getTransaction();
        BooleanValue expression = BooleanValue.trueValue();
        Set<String> attributes = LdapUtils.getAttributes((FilteringOperationContext)context);
        MappableCursor<Entry> entries = this.findEntries(expression, context.getDn(), attributes, transaction, false);
        if (!entries.next()) {
            entries.closeUnchecked();
            this.logger.debug("Could not find cached entry with DN={}", (Object)context.getDn().getName());
            return null;
        }
        Entry entry = entries.get();
        entries.closeUnchecked();
        this.logger.debug("Could find cached entry with DN={}", (Object)context.getDn().getName());
        return new ClonedServerEntry(entry);
    }

    public boolean hasEntry(HasEntryOperationContext context) throws LdapException {
        this.logger.info("[{}] - Perform check for existence of entry with DN={}", (Object)context.getSession().getClientAddress(), (Object)context.getDn().getName());
        PartitionTxn transaction = context.getTransaction();
        BooleanValue expression = BooleanValue.trueValue();
        Set<String> attributes = Collections.emptySet();
        MappableCursor<Entry> entries = this.findEntries(expression, context.getDn(), attributes, transaction, false);
        boolean exists = entries.next();
        entries.closeUnchecked();
        return exists;
    }

    @Override
    protected boolean compare(CompareOperationContext context) throws LdapException {
        this.logger.info("[{}] - Perform compare action with DN={} compare={}:{}", new Object[]{context.getSession().getClientAddress(), context.getDn().getName(), context.getOid(), context.getValue().getString()});
        PartitionTxn transaction = context.getTransaction();
        EqualOperator expression = new EqualOperator(context.getOid(), context.getValue().getString());
        Set<String> attributes = Collections.emptySet();
        MappableCursor<Entry> entries = this.findEntries(expression, context.getDn(), attributes, transaction, true);
        boolean exists = entries.next();
        entries.closeUnchecked();
        return exists;
    }

    @Override
    protected EntryFilteringCursor findOne(SearchOperationContext context) throws LdapException {
        this.logger.debug("Perform search for a single entry with DN={}", (Object)context.getDn().getName());
        PartitionTxn transaction = context.getTransaction();
        QueryExpression expression = LdapUtils.createQueryExpression(context.getFilter());
        Set<String> attributes = LdapUtils.getAttributes((FilteringOperationContext)context);
        MappableCursor<Entry> entries = this.findEntries(expression, context.getDn(), attributes, transaction, false);
        if (!entries.next()) {
            entries.closeUnchecked();
            return new EntryFilteringCursorImpl((Cursor)new EmptyCursor(), context, this.schemaManager);
        }
        Entry entry = entries.get();
        entries.closeUnchecked();
        return new EntryFilteringCursorImpl((Cursor)new SingletonCursor((Object)entry), context, this.schemaManager);
    }

    @Override
    protected EntryFilteringCursor findManyOnFirstLevel(SearchOperationContext context) throws LdapException {
        this.logger.debug("Perform search for entries with DN={}", (Object)context.getDn().getName());
        PartitionTxn transaction = context.getTransaction();
        QueryExpression expression = LdapUtils.createQueryExpression(context.getFilter());
        Set<String> attributes = LdapUtils.getAttributes((FilteringOperationContext)context);
        MappableCursor<Entry> entries = this.findEntries(expression, context.getDn(), attributes, transaction, true);
        return new EntryFilteringWrapperCursor((Cursor<Entry>)new IterableEntryCursor(this.logger, entries), context);
    }

    @Override
    protected EntryFilteringCursor findManyOnMultipleLevels(SearchOperationContext context) throws LdapException {
        return this.findManyOnFirstLevel(context);
    }

    private MappableCursor<Entry> findEntries(QueryExpression expression, Dn queryDn, Set<String> attributes, PartitionTxn transaction, boolean multiple) {
        Dn rootDn = LdapUtils.createDn(this.schemaManager, EntityType.DOMAIN, this.getId());
        Dn groupsDn = LdapUtils.createDn(this.schemaManager, EntityType.GROUP_UNIT, this.getId());
        Dn usersDn = LdapUtils.createDn(this.schemaManager, EntityType.USER_UNIT, this.getId());
        if (!(transaction instanceof SimpleReadOnlyPartition.ReadTransaction)) {
            throw new IllegalArgumentException("Cannot process unexpected transaction type");
        }
        String txId = ((SimpleReadOnlyPartition.ReadTransaction)transaction).getId();
        return this.directoryFactory.withSession(directory -> {
            ArrayList<MappableCursor<Row>> cursors = new ArrayList<MappableCursor<Row>>();
            if (queryDn.equals((Object)groupsDn)) {
                if (LdapUtils.evaluateExpression(LdapUtils.preEvaluateExpression(expression, this.groupUnitEntity))) {
                    cursors.add(MappableCursor.fromIterable(Collections.singleton(this.groupUnitEntity)));
                }
                if (multiple) {
                    cursors.add(directory.runQueryExpression(txId, this.schemaManager, expression, EntityType.GROUP));
                }
            } else if (queryDn.getParent().equals((Object)groupsDn)) {
                String attribute = queryDn.getRdn().getType();
                String value = queryDn.getRdn().getValue();
                AndLogicExpression expr = new AndLogicExpression(Arrays.asList(new EqualOperator(attribute, value), expression));
                cursors.add(directory.runQueryExpression(txId, this.schemaManager, expr, EntityType.GROUP));
            } else if (queryDn.equals((Object)usersDn)) {
                if (LdapUtils.evaluateExpression(LdapUtils.preEvaluateExpression(expression, this.userUnitEntity))) {
                    cursors.add(MappableCursor.fromIterable(Collections.singleton(this.userUnitEntity)));
                }
                if (multiple) {
                    cursors.add(directory.runQueryExpression(txId, this.schemaManager, expression, EntityType.USER));
                }
            } else if (queryDn.getParent().equals((Object)usersDn)) {
                String attribute = queryDn.getRdn().getType();
                String value = queryDn.getRdn().getValue();
                AndLogicExpression expr = new AndLogicExpression(Arrays.asList(new EqualOperator(attribute, value), expression));
                cursors.add(directory.runQueryExpression(txId, this.schemaManager, expr, EntityType.USER));
            } else if (queryDn.equals((Object)rootDn)) {
                if (LdapUtils.evaluateExpression(LdapUtils.preEvaluateExpression(expression, this.domainEntity))) {
                    cursors.add(MappableCursor.fromIterable(Collections.singleton(this.domainEntity)));
                }
                if (multiple) {
                    if (LdapUtils.evaluateExpression(LdapUtils.preEvaluateExpression(expression, this.groupUnitEntity))) {
                        cursors.add(MappableCursor.fromIterable(Collections.singleton(this.groupUnitEntity)));
                    }
                    if (LdapUtils.evaluateExpression(LdapUtils.preEvaluateExpression(expression, this.userUnitEntity))) {
                        cursors.add(MappableCursor.fromIterable(Collections.singleton(this.userUnitEntity)));
                    }
                    cursors.add(directory.runQueryExpression(txId, this.schemaManager, expression, EntityType.GROUP));
                    cursors.add(directory.runQueryExpression(txId, this.schemaManager, expression, EntityType.USER));
                }
            } else if (queryDn.getParent().equals((Object)rootDn) && multiple) {
                String attribute = queryDn.getRdn().getType();
                String value = queryDn.getRdn().getValue();
                AndLogicExpression expr = new AndLogicExpression(Arrays.asList(new EqualOperator(attribute, value), expression));
                cursors.add(directory.runQueryExpression(txId, this.schemaManager, expr, EntityType.GROUP));
                cursors.add(directory.runQueryExpression(txId, this.schemaManager, expr, EntityType.USER));
            }
            return this.createEntries(MappableCursor.flatten(cursors), attributes);
        });
    }

    private Entry createEntry(Row entity, Set<String> attributes) {
        EntityType entityType = EntityType.fromString(entity.apply("type", String.class));
        switch (entityType) {
            case DOMAIN: {
                String id = entity.apply("id", String.class);
                String description = entity.apply("description", String.class);
                Dn dn = LdapUtils.createDn(this.schemaManager, entityType, id, this.getId());
                DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
                if (attributes.isEmpty() || attributes.contains("2.5.4.0")) {
                    entry.put("objectClass", new String[]{"top", "domain"});
                }
                if (attributes.isEmpty() || attributes.contains("dc")) {
                    entry.put("dc", new String[]{id});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.13")) {
                    entry.put("description", new String[]{description});
                }
                return entry;
            }
            case GROUP_UNIT: {
                String id = entity.apply("id", String.class);
                String description = entity.apply("description", String.class);
                Dn dn = LdapUtils.createDn(this.schemaManager, entityType, id, this.getId());
                DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
                if (attributes.isEmpty() || attributes.contains("2.5.4.0")) {
                    entry.put("objectClass", new String[]{"top", "organizationalUnit"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.11")) {
                    entry.put("ou", new String[]{"groups"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.13")) {
                    entry.put("description", new String[]{description});
                }
                return entry;
            }
            case USER_UNIT: {
                String id = entity.apply("id", String.class);
                String description = entity.apply("description", String.class);
                Dn dn = LdapUtils.createDn(this.schemaManager, entityType, id, this.getId());
                DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
                if (attributes.isEmpty() || attributes.contains("2.5.4.0")) {
                    entry.put("objectClass", new String[]{"top", "organizationalUnit"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.11")) {
                    entry.put("ou", new String[]{"users"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.13")) {
                    entry.put("description", new String[]{description});
                }
                return entry;
            }
            case GROUP: {
                String name = entity.apply("name", String.class);
                String description = entity.apply("description", String.class);
                Dn dn = LdapUtils.createDn(this.schemaManager, entityType, name, this.getId());
                DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
                if (attributes.isEmpty() || attributes.contains("2.5.4.0")) {
                    entry.put("objectClass", new String[]{"top", "groupOfNames", "groupOfUniqueNames"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.11")) {
                    entry.put("ou", new String[]{"groups"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.3")) {
                    entry.put("cn", new String[]{name});
                }
                if ((attributes.isEmpty() || attributes.contains("2.5.4.13")) && description != null && !description.isEmpty()) {
                    entry.put("description", new String[]{description});
                }
                return entry;
            }
            case USER: {
                String id = entity.apply("id", String.class);
                String username = entity.apply("username", String.class);
                String lastName = entity.apply("last_name", String.class);
                String firstName = entity.apply("first_name", String.class);
                String displayName = entity.apply("display_name", String.class);
                String email = entity.apply("email", String.class);
                Dn dn = LdapUtils.createDn(this.schemaManager, entityType, username, this.getId());
                DefaultEntry entry = new DefaultEntry(this.schemaManager, dn);
                if (attributes.isEmpty() || attributes.contains("2.5.4.0")) {
                    entry.put("objectClass", new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.11")) {
                    entry.put("ou", new String[]{"users"});
                }
                if (attributes.isEmpty() || attributes.contains("0.9.2342.19200300.100.1.1")) {
                    entry.put("uid", new String[]{id});
                }
                if (attributes.isEmpty() || attributes.contains("2.5.4.3")) {
                    entry.put("cn", new String[]{username});
                }
                if ((attributes.isEmpty() || attributes.contains("2.5.4.4")) && lastName != null && !lastName.isEmpty()) {
                    if (this.serverConfig.isAbbreviateSnAttribute()) {
                        entry.put("sn", new String[]{lastName});
                    } else {
                        entry.put("surname", new String[]{lastName});
                    }
                }
                if ((attributes.isEmpty() || attributes.contains("2.5.4.42")) && firstName != null && !firstName.isEmpty()) {
                    if (this.serverConfig.isAbbreviateGnAttribute()) {
                        entry.put("gn", new String[]{firstName});
                    } else {
                        entry.put("givenName", new String[]{firstName});
                    }
                }
                if ((attributes.isEmpty() || attributes.contains("2.16.840.1.113730.3.1.241")) && displayName != null && !displayName.isEmpty()) {
                    entry.put("displayName", new String[]{displayName});
                }
                if ((attributes.isEmpty() || attributes.contains("0.9.2342.19200300.100.1.3")) && email != null && !email.isEmpty()) {
                    entry.put("mail", new String[]{email});
                }
                return entry;
            }
        }
        throw new IllegalArgumentException("Cannot create entry for with unknown type " + entityType);
    }

    private void addRelationshipToEntries(Entry entry, Row entity, Set<String> attributes) {
        EntityType entityType = EntityType.fromString(entity.apply("type", String.class));
        try {
            switch (entityType) {
                case GROUP: {
                    Dn dn;
                    if (attributes.isEmpty() || attributes.contains("2.5.4.31")) {
                        if (!this.serverConfig.isFlatteningEnabled()) {
                            String memberNameGroup = null;
                            try {
                                memberNameGroup = entity.apply("member_group_name", String.class);
                            }
                            catch (UnknownColumnException e) {
                                this.logger.trace("Cannot find column member_group_name in group row.");
                            }
                            if (memberNameGroup != null) {
                                dn = LdapUtils.createDn(this.schemaManager, EntityType.GROUP, memberNameGroup, this.getId());
                                entry.add("member", new String[]{dn.getName()});
                            }
                        }
                        String memberNameUser = null;
                        try {
                            memberNameUser = entity.apply("member_user_username", String.class);
                        }
                        catch (UnknownColumnException e) {
                            this.logger.trace("Cannot find column member_user_username in group row.");
                        }
                        if (memberNameUser != null) {
                            dn = LdapUtils.createDn(this.schemaManager, EntityType.USER, memberNameUser, this.getId());
                            entry.add("member", new String[]{dn.getName()});
                        }
                    }
                    if (!attributes.isEmpty() && !attributes.contains("1.2.840.113556.1.2.102") || this.serverConfig.isFlatteningEnabled()) break;
                    String memberOfName = null;
                    try {
                        memberOfName = entity.apply("parent_group_name", String.class);
                    }
                    catch (UnknownColumnException e) {
                        this.logger.trace("Cannot find column parent_group_name in group row.");
                    }
                    if (memberOfName != null) {
                        dn = LdapUtils.createDn(this.schemaManager, EntityType.GROUP, memberOfName, this.getId());
                        entry.add("memberOf", new String[]{dn.getName()});
                    }
                    break;
                }
                case USER: {
                    if (!attributes.isEmpty() && !attributes.contains("1.2.840.113556.1.2.102")) break;
                    String memberOfName = null;
                    try {
                        memberOfName = entity.apply("parent_group_name", String.class);
                    }
                    catch (UnknownColumnException e) {
                        this.logger.trace("Cannot find column parent_group_name in user row.");
                    }
                    if (memberOfName != null) {
                        Dn dn = LdapUtils.createDn(this.schemaManager, EntityType.GROUP, memberOfName, this.getId());
                        entry.add("memberOf", new String[]{dn.getName()});
                    }
                    break;
                }
            }
        }
        catch (LdapException e) {
            throw new IllegalArgumentException("Cannot handle attributes correctly.", e);
        }
    }

    private MappableCursor<Entry> createEntries(final MappableCursor<Row> cursor, final Set<String> attributes) {
        return new MappableCursor<Entry>(){
            private boolean initialized = false;
            private String nextId;
            private Entry nextEntry;
            private Entry currentEntry;

            @Override
            public boolean next() {
                if (!this.initialized) {
                    this.initialized = true;
                    if (cursor.next()) {
                        this.nextId = ((Row)cursor.get()).apply("id", String.class);
                        this.nextEntry = CommonPartition.this.createEntry((Row)cursor.get(), attributes);
                        CommonPartition.this.addRelationshipToEntries(this.nextEntry, (Row)cursor.get(), attributes);
                    }
                }
                this.currentEntry = this.nextEntry;
                while (cursor.next()) {
                    if (((Row)cursor.get()).apply("id", String.class).equals(this.nextId)) {
                        CommonPartition.this.addRelationshipToEntries(this.currentEntry, (Row)cursor.get(), attributes);
                        continue;
                    }
                    this.nextId = ((Row)cursor.get()).apply("id", String.class);
                    this.nextEntry = CommonPartition.this.createEntry((Row)cursor.get(), attributes);
                    CommonPartition.this.addRelationshipToEntries(this.nextEntry, (Row)cursor.get(), attributes);
                    break;
                }
                if (this.currentEntry == this.nextEntry) {
                    this.nextId = null;
                    this.nextEntry = null;
                }
                return this.currentEntry != null;
            }

            @Override
            public Entry get() {
                return this.currentEntry;
            }

            @Override
            public void close() throws IOException {
                cursor.close();
            }
        };
    }
}

