/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.ldap.adapter;

import de.aservo.ldap.adapter.CommonAuthenticator;
import de.aservo.ldap.adapter.CommonPartition;
import de.aservo.ldap.adapter.CompareRequestHandler;
import de.aservo.ldap.adapter.DirectoryBackendFactory;
import de.aservo.ldap.adapter.ServerConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schema.loader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.LdapResponseHandler;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.response.CompareResponseHandler;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonLdapServer {
    private final Logger logger = LoggerFactory.getLogger(CommonLdapServer.class);
    private final ServerConfiguration serverConfig;
    private final DirectoryBackendFactory directoryBackendFactory;
    private final DirectoryService directoryService;

    public CommonLdapServer(ServerConfiguration serverConfig) {
        this.serverConfig = serverConfig;
        this.directoryBackendFactory = new DirectoryBackendFactory(serverConfig);
        try {
            if (Files.exists(serverConfig.getDsCacheDir(), new LinkOption[0])) {
                FileUtils.deleteDirectory((File)serverConfig.getDsCacheDir().toFile());
            }
            Files.createDirectories(serverConfig.getDsCacheDir(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.createNewLoaders();
        this.directoryService = this.initDirectoryService();
    }

    public ServerConfiguration getServerConfig() {
        return this.serverConfig;
    }

    public DirectoryBackendFactory getDirectoryBackendFactory() {
        return this.directoryBackendFactory;
    }

    public void startup() {
        try {
            this.directoryBackendFactory.startup();
            this.directoryService.startup();
            LdapServer server = new LdapServer();
            TcpTransport transport = new TcpTransport(this.serverConfig.getHost(), this.serverConfig.getPort());
            if (this.serverConfig.isSslEnabled()) {
                transport.setEnableSSL(true);
                server.setKeystoreFile(this.serverConfig.getKeyStoreFile().toString());
                server.setCertificatePassword(this.serverConfig.getKeyStorePassword());
                server.addExtendedOperationHandler((ExtendedOperationHandler)new StartTlsHandler());
            }
            transport.setBackLog(this.serverConfig.getConnectionBackLog());
            transport.setNbThreads(this.serverConfig.getConnectionActiveThreads());
            server.setTransports(new Transport[]{transport});
            server.setDirectoryService(this.directoryService);
            server.setMaxSizeLimit((long)this.serverConfig.getResponseMaxSizeLimit());
            server.setMaxTimeLimit(this.serverConfig.getResponseMaxTimeLimit());
            server.setCompareHandlers((LdapRequestHandler)new CompareRequestHandler(), (LdapResponseHandler)new CompareResponseHandler());
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        try {
            this.directoryService.shutdown();
            this.directoryBackendFactory.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isStarted() {
        return this.directoryService.isStarted();
    }

    private void copyStream(String resourcePath, Path outputFile) throws IOException {
        if (outputFile.toFile().exists()) {
            return;
        }
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
             FileOutputStream out = new FileOutputStream(outputFile.toFile());){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    private void createNewLoaders() {
        try {
            DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(this.serverConfig.getDsCacheDir().toFile());
            extractor.extractOrCopy(true);
            Path attributeTypesDir = this.serverConfig.getDsCacheDir().resolve("schema/ou=schema/cn=other/ou=attributetypes");
            Files.createDirectories(attributeTypesDir, new FileAttribute[0]);
            Path memberOfLDIF = attributeTypesDir.resolve("m-oid=1.2.840.113556.1.2.102.ldif");
            this.copyStream("de/aservo/ldap/adapter/memberof.ldif", memberOfLDIF);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void initSchemaPartition(DirectoryService directoryService) {
        try {
            File schemaRepository = this.serverConfig.getDsCacheDir().resolve("schema").toFile();
            LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
            DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
            schemaManager.loadAllEnabled();
            directoryService.setSchemaManager((SchemaManager)schemaManager);
            SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
            directoryService.setSchemaPartition(schemaPartition);
            LdifPartition ldifPartition = new LdifPartition(directoryService.getSchemaManager(), directoryService.getDnFactory());
            ldifPartition.setPartitionPath(schemaRepository.toURI());
            schemaPartition.setWrappedPartition((Partition)ldifPartition);
            directoryService.setInstanceLayout(new InstanceLayout(this.serverConfig.getDsCacheDir().toFile()));
            schemaManager.loadAllEnabled();
            List errors = schemaManager.getErrors();
            if (!errors.isEmpty()) {
                throw new IOException(MessageFormat.format("Schema load failed: {0}", errors));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DirectoryService initDirectoryService() {
        try {
            DefaultDirectoryService service = new DefaultDirectoryService();
            this.initSchemaPartition((DirectoryService)service);
            JdbmPartition partition = new JdbmPartition(service.getSchemaManager(), service.getDnFactory());
            partition.setId("system");
            partition.setPartitionPath(this.serverConfig.getDsCacheDir().resolve("system").toFile().toURI());
            partition.setSuffixDn(new Dn(new String[]{"ou=system"}));
            service.setSystemPartition((Partition)partition);
            service.getChangeLog().setEnabled(false);
            service.setDenormalizeOpAttrsEnabled(false);
            service.setAllowAnonymousAccess(false);
            List interceptors = service.getInterceptors();
            for (Interceptor interceptor : interceptors) {
                if (!(interceptor instanceof AuthenticationInterceptor)) continue;
                this.logger.debug("Interceptor: {}", (Object)interceptor.getName());
                AuthenticationInterceptor ai = (AuthenticationInterceptor)interceptor;
                HashSet<CommonAuthenticator> auths = new HashSet<CommonAuthenticator>();
                auths.add(new CommonAuthenticator(this.directoryBackendFactory, service.getSchemaManager()));
                ai.setAuthenticators(auths);
            }
            this.addPartition((DirectoryService)service);
            return service;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addPartition(DirectoryService directoryService) {
        try {
            CommonPartition partition = new CommonPartition(this.serverConfig, this.directoryBackendFactory);
            partition.setSchemaManager(directoryService.getSchemaManager());
            partition.initialize();
            directoryService.addPartition((Partition)partition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

