/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.crowd.model.TrustedProxiesBean;
import de.aservo.confapi.crowd.service.api.TrustedProxiesService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={TrustedProxiesService.class})
public class TrustedProxiesServiceImpl
implements TrustedProxiesService {
    @ComponentImport
    private final TrustedProxyManager trustedProxyManager;

    @Inject
    public TrustedProxiesServiceImpl(TrustedProxyManager trustedProxyManager) {
        this.trustedProxyManager = trustedProxyManager;
    }

    @Override
    public TrustedProxiesBean getTrustedProxies() {
        return new TrustedProxiesBean(this.trustedProxyManager.getAddresses().stream().sorted().collect(Collectors.toList()));
    }

    @Override
    public TrustedProxiesBean setTrustedProxies(TrustedProxiesBean trustedProxiesBean) {
        for (String trustedProxy : trustedProxiesBean.getTrustedProxies()) {
            if (this.trustedProxyManager.isTrusted(trustedProxy)) continue;
            this.trustedProxyManager.addAddress(trustedProxy);
        }
        for (String trustedProxy : this.trustedProxyManager.getAddresses()) {
            if (trustedProxiesBean.getTrustedProxies().contains(trustedProxy)) continue;
            this.trustedProxyManager.removeAddress(trustedProxy);
        }
        return this.getTrustedProxies();
    }

    @Override
    public TrustedProxiesBean addTrustedProxy(String trustedProxy) {
        this.trustedProxyManager.addAddress(trustedProxy);
        return this.getTrustedProxies();
    }

    @Override
    public TrustedProxiesBean removeTrustedProxy(String trustedProxy) {
        this.trustedProxyManager.removeAddress(trustedProxy);
        return this.getTrustedProxies();
    }
}

