/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.crowd.model.MailTemplatesBean;
import de.aservo.confapi.crowd.service.api.MailTemplatesService;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={MailTemplatesService.class})
public class MailTemplatesServiceImpl
implements MailTemplatesService {
    private final PropertyManager propertyManager;

    @Inject
    public MailTemplatesServiceImpl(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    @Override
    public MailTemplatesBean getMailTemplates() {
        MailTemplatesBean mailTemplatesBean = new MailTemplatesBean();
        try {
            mailTemplatesBean.setForgottenPassword(this.propertyManager.getProperty("mailserver.message.template"));
            mailTemplatesBean.setForgottenUsername(this.propertyManager.getProperty("email.template.forgotten.username"));
            mailTemplatesBean.setPasswordExpirationReminder(this.propertyManager.getProperty("email.template.password.expiration.reminder"));
            mailTemplatesBean.setEmailChangeValidation(this.propertyManager.getProperty("email.template.email.change.validation"));
            mailTemplatesBean.setEmailChangeInfo(this.propertyManager.getProperty("email.template.email.change.info"));
        }
        catch (ObjectNotFoundException e) {
            throw new NotFoundException(e.getMessage());
        }
        return mailTemplatesBean;
    }

    @Override
    public MailTemplatesBean setMailTemplates(MailTemplatesBean mailTemplatesBean) {
        if (mailTemplatesBean.getForgottenPassword() != null) {
            this.propertyManager.setProperty("mailserver.message.template", mailTemplatesBean.getForgottenPassword());
        }
        if (mailTemplatesBean.getForgottenUsername() != null) {
            this.propertyManager.setProperty("email.template.forgotten.username", mailTemplatesBean.getForgottenUsername());
        }
        if (mailTemplatesBean.getPasswordExpirationReminder() != null) {
            this.propertyManager.setProperty("email.template.password.expiration.reminder", mailTemplatesBean.getPasswordExpirationReminder());
        }
        if (mailTemplatesBean.getEmailChangeValidation() != null) {
            this.propertyManager.setProperty("email.template.email.change.validation", mailTemplatesBean.getEmailChangeValidation());
        }
        if (mailTemplatesBean.getEmailChangeInfo() != null) {
            this.propertyManager.setProperty("email.template.email.change.info", mailTemplatesBean.getEmailChangeInfo());
        }
        return this.getMailTemplates();
    }
}

