/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.manager.mail.MailConfiguration;
import com.atlassian.crowd.manager.mail.MailConfigurationService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.model.MailServerPopBean;
import de.aservo.confapi.commons.model.MailServerSmtpBean;
import de.aservo.confapi.commons.service.api.MailServerService;
import de.aservo.confapi.crowd.model.util.MailServerSmtpBeanUtil;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={MailServerService.class})
public class MailServerServiceImpl
implements MailServerService {
    @ComponentImport
    private final MailConfigurationService mailConfigurationService;

    @Inject
    public MailServerServiceImpl(MailConfigurationService mailConfigurationService) {
        this.mailConfigurationService = mailConfigurationService;
    }

    @Override
    public MailServerSmtpBean getMailServerSmtp() {
        if (this.mailConfigurationService.isConfigured()) {
            return MailServerSmtpBeanUtil.toMailServerSmtpBean(this.mailConfigurationService.getMailConfiguration());
        }
        return null;
    }

    @Override
    public MailServerSmtpBean setMailServerSmtp(MailServerSmtpBean mailServerSmtpBean) {
        MailConfiguration mailConfiguration = this.mailConfigurationService.getMailConfiguration();
        this.mailConfigurationService.saveConfiguration(MailServerSmtpBeanUtil.toMailConfiguration(mailServerSmtpBean, mailConfiguration));
        return this.getMailServerSmtp();
    }

    @Override
    public MailServerPopBean getMailServerPop() {
        throw new UnsupportedOperationException("Getting POP mail server is not supported by Crowd");
    }

    @Override
    public MailServerPopBean setMailServerPop(MailServerPopBean mailServerPopBean) {
        throw new UnsupportedOperationException("Setting POP mail server is not supported by Crowd");
    }
}

