/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.rest;

import com.sun.jersey.spi.container.ResourceFilters;
import de.aservo.confapi.commons.model.GroupBean;
import de.aservo.confapi.crowd.filter.SysadminOnlyResourceFilter;
import de.aservo.confapi.crowd.model.GroupsBean;
import de.aservo.confapi.crowd.rest.api.GroupsResource;
import de.aservo.confapi.crowd.service.api.GroupsService;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="groups")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@Component
public class GroupsResourceImpl
implements GroupsResource {
    private final GroupsService groupsService;

    @Inject
    public GroupsResourceImpl(GroupsService groupsService) {
        this.groupsService = groupsService;
    }

    @Override
    public Response getGroup(long directoryId, String groupName) {
        GroupBean groupBean = this.groupsService.getGroup(directoryId, groupName);
        return Response.ok((Object)groupBean).build();
    }

    @Override
    public Response createGroup(long directoryId, GroupBean groupBean) {
        GroupBean resultGroupBean = this.groupsService.createGroup(directoryId, groupBean);
        return Response.ok((Object)resultGroupBean).build();
    }

    @Override
    public Response updateGroup(long directoryId, String groupName, GroupBean groupBean) {
        GroupBean resultGroupBean = this.groupsService.updateGroup(directoryId, groupName, groupBean);
        return Response.ok((Object)resultGroupBean).build();
    }

    @Override
    public Response setGroups(long directoryId, GroupsBean groupBeans) {
        GroupsBean resultGroupsBean = this.groupsService.setGroups(directoryId, groupBeans);
        return Response.ok((Object)resultGroupsBean).build();
    }
}

