/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.model.util;

import com.atlassian.crowd.manager.mail.MailConfiguration;
import com.atlassian.crowd.util.mail.SMTPServer;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.model.MailServerSmtpBean;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailServerSmtpBeanUtil {
    @Nullable
    public static MailServerSmtpBean toMailServerSmtpBean(@Nullable MailConfiguration mailConfiguration) {
        SMTPServer mailConfigurationSmtp;
        if (mailConfiguration == null || mailConfiguration.getSmtpServer() == null) {
            return null;
        }
        MailServerSmtpBean mailServerSmtpBean = new MailServerSmtpBean();
        if (mailConfiguration.getNotificationEmails() != null && !mailConfiguration.getNotificationEmails().isEmpty()) {
            mailServerSmtpBean.setAdminContact((String)mailConfiguration.getNotificationEmails().get(0));
        }
        if ((mailConfigurationSmtp = mailConfiguration.getSmtpServer()).getFrom() != null) {
            mailServerSmtpBean.setFrom(mailConfigurationSmtp.getFrom().toString());
        }
        mailServerSmtpBean.setPrefix(mailConfigurationSmtp.getPrefix());
        mailServerSmtpBean.setHost(mailConfigurationSmtp.getHost());
        mailServerSmtpBean.setPort(mailConfigurationSmtp.getPort());
        mailServerSmtpBean.setUsername(mailConfigurationSmtp.getUsername());
        mailServerSmtpBean.setTimeout(Long.valueOf(mailConfigurationSmtp.getTimeout()));
        return mailServerSmtpBean;
    }

    @Nullable
    public static MailConfiguration toMailConfiguration(@Nullable MailServerSmtpBean mailServerSmtpBean) {
        return MailServerSmtpBeanUtil.toMailConfiguration(mailServerSmtpBean, null);
    }

    @Nullable
    public static MailConfiguration toMailConfiguration(@Nullable MailServerSmtpBean mailServerSmtpBean, @Nullable MailConfiguration mailConfiguration) {
        SMTPServer.Builder smtpServerBuilder;
        MailConfiguration.Builder mailConfigurationBuilder;
        if (mailServerSmtpBean == null) {
            return null;
        }
        if (mailConfiguration != null) {
            mailConfigurationBuilder = MailConfiguration.builder((MailConfiguration)mailConfiguration);
            smtpServerBuilder = mailConfiguration.getSmtpServer() != null ? SMTPServer.builder((SMTPServer)mailConfiguration.getSmtpServer()) : SMTPServer.builder();
        } else {
            mailConfigurationBuilder = MailConfiguration.builder();
            smtpServerBuilder = SMTPServer.builder();
        }
        if (mailServerSmtpBean.getAdminContact() != null) {
            mailConfigurationBuilder.setNotificationEmails(Collections.singletonList(mailServerSmtpBean.getAdminContact()));
        }
        if (mailServerSmtpBean.getFrom() != null) {
            try {
                smtpServerBuilder.setFrom(new InternetAddress(mailServerSmtpBean.getFrom()));
            }
            catch (AddressException e) {
                throw new BadRequestException(e.getMessage());
            }
        }
        if (mailServerSmtpBean.getPrefix() != null) {
            smtpServerBuilder.setPrefix(mailServerSmtpBean.getPrefix());
        }
        if (mailServerSmtpBean.getHost() != null) {
            smtpServerBuilder.setHost(mailServerSmtpBean.getHost());
        }
        if (mailServerSmtpBean.getPort() != null) {
            smtpServerBuilder.setPort(mailServerSmtpBean.getPort().intValue());
        }
        if (mailServerSmtpBean.getUsername() != null) {
            smtpServerBuilder.setUsername(mailServerSmtpBean.getUsername());
        }
        if (mailServerSmtpBean.getPassword() != null) {
            smtpServerBuilder.setPassword(mailServerSmtpBean.getPassword());
        }
        if (mailServerSmtpBean.getTimeout() != null) {
            smtpServerBuilder.setTimeout(mailServerSmtpBean.getTimeout().intValue());
        }
        smtpServerBuilder.setStartTLS(mailServerSmtpBean.getUseTls());
        mailConfigurationBuilder.setSmtpServer(smtpServerBuilder.build());
        return mailConfigurationBuilder.build();
    }

    private MailServerSmtpBeanUtil() {
    }
}

