/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.model.util;

import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.ldap.LdapSecureMode;
import com.atlassian.crowd.directory.monitor.poller.PollerConfig;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import de.aservo.confapi.commons.model.AbstractDirectoryBean;
import de.aservo.confapi.commons.model.DirectoryCrowdBean;
import de.aservo.confapi.commons.model.DirectoryDelegatingBean;
import de.aservo.confapi.commons.model.DirectoryGenericBean;
import de.aservo.confapi.commons.model.DirectoryInternalBean;
import de.aservo.confapi.commons.model.DirectoryLdapBean;
import de.aservo.confapi.commons.model.type.DirectoryPermissions;
import de.aservo.confapi.crowd.util.AttributeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class DirectoryBeanUtil {
    public static final String ATTRIBUTE_USE_NESTED_GROUPS = "useNestedGroups";
    private static final Set<Class<? extends AbstractDirectoryBean>> SUPPORTED_DIRECTORY_BEAN_TYPES;

    @Nonnull
    public static AbstractDirectoryBean toDirectoryBean(@Nonnull Directory directory) {
        if (directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            return DirectoryBeanUtil.toDirectoryInternalBean(directory);
        }
        if (directory.getType().equals((Object)DirectoryType.DELEGATING)) {
            return DirectoryBeanUtil.toDirectoryDelegatingBean(directory);
        }
        return DirectoryBeanUtil.toDirectoryGenericBean(directory);
    }

    @Nonnull
    public static DirectoryInternalBean toDirectoryInternalBean(@Nonnull Directory directory) {
        DirectoryInternalBean directoryBean = new DirectoryInternalBean();
        DirectoryBeanUtil.setDirectoryBeanDetails(directoryBean, directory);
        HashMap attributes = new HashMap(directory.getAttributes());
        directoryBean.setCredentialPolicy(new DirectoryInternalBean.DirectoryInternalCredentialPolicy());
        directoryBean.getCredentialPolicy().setPasswordRegex((String)attributes.get("password_regex"));
        directoryBean.getCredentialPolicy().setPasswordComplexityMessage((String)attributes.get("password_complexity_message"));
        directoryBean.getCredentialPolicy().setPasswordMaxAttempts(AttributeUtil.toLong((String)attributes.get("password_max_attempts")));
        directoryBean.getCredentialPolicy().setPasswordHistoryCount(AttributeUtil.toLong((String)attributes.get("password_history_count")));
        directoryBean.getCredentialPolicy().setPasswordMaxChangeTime(AttributeUtil.toLong((String)attributes.get("password_max_change_time")));
        directoryBean.getCredentialPolicy().setPasswordExpiryNotificationDays(AttributeUtil.toIntegerList((String)attributes.get("password_expiration_notification_periods")));
        directoryBean.getCredentialPolicy().setPasswordEncryptionMethod((String)attributes.get("user_encryption_method"));
        directoryBean.setAdvanced(new DirectoryInternalBean.DirectoryInternalAdvanced());
        directoryBean.getAdvanced().setEnableNestedGroups(AttributeUtil.toBoolean(attributes.getOrDefault(ATTRIBUTE_USE_NESTED_GROUPS, "false")));
        DirectoryBeanUtil.setDirectoryBeanPermissions(directoryBean, directory);
        return directoryBean;
    }

    @Nonnull
    public static DirectoryDelegatingBean toDirectoryDelegatingBean(@Nonnull Directory directory) {
        DirectoryDelegatingBean directoryBean = new DirectoryDelegatingBean();
        DirectoryBeanUtil.setDirectoryBeanDetails(directoryBean, directory);
        directoryBean.setConnector(new DirectoryDelegatingBean.DirectoryDelegatingConnector());
        directoryBean.getConnector().setType(DirectoryBeanUtil.toDirectoryDelegatingConnectorType(directory));
        directoryBean.getConnector().setUrl((String)directory.getAttributes().get("ldap.url"));
        directoryBean.getConnector().setSsl(DirectoryBeanUtil.toDirectoryDelegatingConnectorSslType(directory));
        directoryBean.getConnector().setUseNodeReferrals(AttributeUtil.toBoolean((String)directory.getAttributes().get("ldap.referral")));
        directoryBean.getConnector().setNestedGroupsDisabled(AttributeUtil.toBoolean((String)directory.getAttributes().get("ldap.nestedgroups.disabled")));
        directoryBean.getConnector().setSynchronizeUsers(AttributeUtil.toBoolean((String)directory.getAttributes().get("crowd.delegated.directory.auto.create.user")));
        directoryBean.getConnector().setSynchronizeUserDetails(AttributeUtil.toBoolean((String)directory.getAttributes().get("crowd.delegated.directory.auto.update.user")));
        directoryBean.getConnector().setSynchronizeGroupMemberships(AttributeUtil.toBoolean((String)directory.getAttributes().get("crowd.delegated.directory.importGroups")));
        directoryBean.getConnector().setUseUserMembershipAttribute(AttributeUtil.toBoolean((String)directory.getAttributes().get("ldap.usermembership.use")));
        directoryBean.getConnector().setUsePagedResults(AttributeUtil.toBoolean((String)directory.getAttributes().get("ldap.pagedresults")));
        directoryBean.getConnector().setPagedResultsSize(AttributeUtil.toLong((String)directory.getAttributes().get("ldap.pagedresults.size")));
        directoryBean.getConnector().setReadTimeoutInMillis(AttributeUtil.toLong((String)directory.getAttributes().get("ldap.read.timeout")));
        directoryBean.getConnector().setSearchTimeoutInMillis(AttributeUtil.toLong((String)directory.getAttributes().get("ldap.search.timelimit")));
        directoryBean.getConnector().setConnectionTimeoutInMillis(AttributeUtil.toLong((String)directory.getAttributes().get("ldap.connection.timeout")));
        directoryBean.getConnector().setBaseDn((String)directory.getAttributes().get("ldap.basedn"));
        directoryBean.getConnector().setUsername((String)directory.getAttributes().get("ldap.userdn"));
        directoryBean.setConfiguration(new DirectoryDelegatingBean.DirectoryDelegatingConfiguration());
        directoryBean.getConfiguration().setUserDn((String)directory.getAttributes().get("ldap.user.dn"));
        directoryBean.getConfiguration().setUserObjectClass((String)directory.getAttributes().get("ldap.user.objectclass"));
        directoryBean.getConfiguration().setUserObjectFilter((String)directory.getAttributes().get("ldap.user.filter"));
        directoryBean.getConfiguration().setUserNameAttribute((String)directory.getAttributes().get("ldap.user.username"));
        directoryBean.getConfiguration().setUserNameRdnAttribute((String)directory.getAttributes().get("ldap.user.username.rdn"));
        directoryBean.getConfiguration().setUserFirstNameAttribute((String)directory.getAttributes().get("ldap.user.firstname"));
        directoryBean.getConfiguration().setUserLastNameAttribute((String)directory.getAttributes().get("ldap.user.lastname"));
        directoryBean.getConfiguration().setUserDisplayNameAttribute((String)directory.getAttributes().get("ldap.user.displayname"));
        directoryBean.getConfiguration().setUserEmailAttribute((String)directory.getAttributes().get("ldap.user.email"));
        directoryBean.getConfiguration().setUserGroupAttribute((String)directory.getAttributes().get("ldap.user.group"));
        directoryBean.getConfiguration().setUserUniqueIdAttribute((String)directory.getAttributes().get("ldap.external.id"));
        directoryBean.getConfiguration().setGroupDn((String)directory.getAttributes().get("ldap.group.dn"));
        directoryBean.getConfiguration().setGroupObjectClass((String)directory.getAttributes().get("ldap.group.objectclass"));
        directoryBean.getConfiguration().setGroupObjectFilter((String)directory.getAttributes().get("ldap.group.filter"));
        directoryBean.getConfiguration().setGroupNameAttribute((String)directory.getAttributes().get("ldap.group.name"));
        directoryBean.getConfiguration().setGroupDescriptionAttribute((String)directory.getAttributes().get("ldap.group.description"));
        directoryBean.getConfiguration().setGroupMembersAttribute((String)directory.getAttributes().get("ldap.group.usernames"));
        DirectoryBeanUtil.setDirectoryBeanPermissions(directoryBean, directory);
        return directoryBean;
    }

    @Nonnull
    private static DirectoryDelegatingBean.DirectoryDelegatingConnector.SslType toDirectoryDelegatingConnectorSslType(@Nonnull Directory directory) {
        String ldapSecure = (String)directory.getAttributes().get("ldap.secure");
        LdapSecureMode ldapSecureMode = LdapSecureMode.fromString((String)ldapSecure);
        return DirectoryDelegatingBean.DirectoryDelegatingConnector.SslType.valueOf(ldapSecureMode.name().toUpperCase());
    }

    @Nonnull
    private static DirectoryGenericBean toDirectoryGenericBean(@Nonnull Directory directory) {
        DirectoryGenericBean directoryBean = new DirectoryGenericBean();
        DirectoryBeanUtil.setDirectoryBeanDetails(directoryBean, directory);
        return directoryBean;
    }

    @Nonnull
    public static Directory toDirectory(@Nonnull AbstractDirectoryBean directoryBean) throws UnsupportedDirectoryBeanException {
        ImmutableDirectory.Builder directoryBuilder = ImmutableDirectory.builder((String)directoryBean.getName(), (DirectoryType)DirectoryBeanUtil.toDirectoryType(directoryBean), (String)DirectoryBeanUtil.toDirectoryImplClass(directoryBean));
        return DirectoryBeanUtil.toDirectory(directoryBean, (Directory)directoryBuilder.build());
    }

    @Nonnull
    public static Directory toDirectory(@Nonnull AbstractDirectoryBean directoryBean, @Nonnull Directory directory) throws UnsupportedDirectoryBeanException {
        if (!SUPPORTED_DIRECTORY_BEAN_TYPES.contains(directoryBean.getClass())) {
            throw new UnsupportedDirectoryBeanException(directoryBean.getClass());
        }
        ImmutableDirectory.Builder directoryBuilder = ImmutableDirectory.builder((Directory)directory);
        if (directoryBean.getId() != null) {
            directoryBuilder.setId(directoryBean.getId());
        }
        if (directoryBean.getName() != null) {
            directoryBuilder.setName(directoryBean.getName());
        }
        if (directoryBean.getDescription() != null) {
            directoryBuilder.setDescription(directoryBean.getDescription());
        }
        if (directoryBean.getActive() != null) {
            directoryBuilder.setActive(directoryBean.getActive().booleanValue());
        }
        HashMap<String, String> attributes = new HashMap<String, String>(directory.getAttributes());
        HashSet<OperationType> allowedOperations = new HashSet<OperationType>(directory.getAllowedOperations());
        if (DirectoryInternalBean.class.equals(directoryBean.getClass())) {
            DirectoryInternalBean directoryInternalBean = (DirectoryInternalBean)directoryBean;
            DirectoryBeanUtil.setDirectoryAttributes(attributes, directoryInternalBean);
            DirectoryBeanUtil.setDirectoryAllowedOperations(allowedOperations, directoryInternalBean);
        } else if (DirectoryDelegatingBean.class.equals(directoryBean.getClass())) {
            DirectoryDelegatingBean directoryDelegatingBean = (DirectoryDelegatingBean)directoryBean;
            DirectoryBeanUtil.setDirectoryAttributes(attributes, directoryDelegatingBean);
            DirectoryBeanUtil.setDirectoryAllowedOperations(allowedOperations, directoryDelegatingBean);
        }
        return directoryBuilder.setAttributes(attributes).setAllowedOperations(allowedOperations).build();
    }

    private static void setDirectoryBeanDetails(@Nonnull AbstractDirectoryBean directoryBean, @Nonnull Directory directory) {
        directoryBean.setId(directory.getId());
        directoryBean.setName(directory.getName());
        directoryBean.setDescription(directory.getDescription());
        directoryBean.setActive(directory.isActive());
        directoryBean.setCreatedDate(directory.getCreatedDate());
        directoryBean.setUpdatedDate(directory.getUpdatedDate());
    }

    private static void setDirectoryBeanPermissions(@Nonnull AbstractDirectoryBean directoryBean, @Nonnull Directory directory) {
        DirectoryPermissions permissions = DirectoryBeanUtil.toDirectoryPermissions(directory);
        if (DirectoryInternalBean.class.equals(directoryBean.getClass())) {
            DirectoryInternalBean directoryInternalBean = (DirectoryInternalBean)directoryBean;
            directoryInternalBean.setPermissions(permissions);
        } else if (DirectoryDelegatingBean.class.equals(directoryBean.getClass())) {
            DirectoryDelegatingBean directoryDelegatingBean = (DirectoryDelegatingBean)directoryBean;
            directoryDelegatingBean.setPermissions(permissions);
        }
    }

    @Nonnull
    private static DirectoryPermissions toDirectoryPermissions(@Nonnull Directory directory) {
        Set allowedOperations = directory.getAllowedOperations();
        DirectoryPermissions permissions = new DirectoryPermissions();
        permissions.setAddGroup(allowedOperations.contains(OperationType.CREATE_GROUP));
        permissions.setAddUser(allowedOperations.contains(OperationType.CREATE_USER));
        permissions.setModifyGroup(allowedOperations.contains(OperationType.UPDATE_GROUP));
        permissions.setModifyUser(allowedOperations.contains(OperationType.UPDATE_USER));
        permissions.setModifyGroupAttributes(allowedOperations.contains(OperationType.UPDATE_GROUP_ATTRIBUTE));
        permissions.setModifyUserAttributes(allowedOperations.contains(OperationType.UPDATE_USER_ATTRIBUTE));
        permissions.setRemoveGroup(allowedOperations.contains(OperationType.DELETE_GROUP));
        permissions.setRemoveUser(allowedOperations.contains(OperationType.DELETE_USER));
        return permissions;
    }

    @Nullable
    private static DirectoryDelegatingBean.DirectoryDelegatingConnector.ConnectorType toDirectoryDelegatingConnectorType(@Nonnull Directory directory) {
        DirectoryDelegatingConnectorTypeImplClass implClass;
        String implementationClass = (String)directory.getAttributes().get("crowd.delegated.directory.type");
        if (implementationClass != null && (implClass = DirectoryDelegatingConnectorTypeImplClass.fromImplClass(implementationClass)) != null) {
            return DirectoryDelegatingBean.DirectoryDelegatingConnector.ConnectorType.valueOf(implClass.name().toUpperCase());
        }
        return null;
    }

    @Nonnull
    private static DirectoryType toDirectoryType(@Nonnull AbstractDirectoryBean directoryBean) {
        if (DirectoryInternalBean.class.equals(directoryBean.getClass())) {
            return DirectoryType.INTERNAL;
        }
        if (DirectoryCrowdBean.class.equals(directoryBean.getClass())) {
            return DirectoryType.CROWD;
        }
        if (DirectoryLdapBean.class.equals(directoryBean.getClass())) {
            return DirectoryType.AZURE_AD;
        }
        if (DirectoryDelegatingBean.class.equals(directoryBean.getClass())) {
            return DirectoryType.DELEGATING;
        }
        return DirectoryType.UNKNOWN;
    }

    @Nullable
    private static String toDirectoryImplClass(@Nonnull AbstractDirectoryBean directoryBean) {
        if (DirectoryDelegatingBean.class.equals(directoryBean.getClass())) {
            return DelegatedAuthenticationDirectory.class.getCanonicalName();
        }
        if (DirectoryInternalBean.class.equals(directoryBean.getClass())) {
            return InternalDirectory.class.getCanonicalName();
        }
        return null;
    }

    @Nullable
    private static String toDirectoryDelegatedConnectorTypeClass(@Nullable DirectoryDelegatingBean.DirectoryDelegatingConnector.ConnectorType connectorType) {
        if (connectorType == null) {
            return null;
        }
        return DirectoryDelegatingConnectorTypeImplClass.valueOf(connectorType.name()).getImplClass();
    }

    @Nullable
    private static String toDirectoryDelegatingConnectorSecureModeName(@Nullable DirectoryDelegatingBean.DirectoryDelegatingConnector.SslType sslType) {
        if (sslType == null) {
            return null;
        }
        return LdapSecureMode.valueOf((String)sslType.name()).getName();
    }

    private static void setDirectoryAttributes(@Nonnull Map<String, String> attributes, @Nonnull DirectoryInternalBean directoryInternalBean) {
        DirectoryInternalBean.DirectoryInternalAdvanced advanced;
        DirectoryInternalBean.DirectoryInternalCredentialPolicy credentialPolicy = directoryInternalBean.getCredentialPolicy();
        if (credentialPolicy != null) {
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "password_regex", credentialPolicy.getPasswordRegex());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "password_complexity_message", credentialPolicy.getPasswordComplexityMessage());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "password_max_attempts", AttributeUtil.fromLong(credentialPolicy.getPasswordMaxAttempts()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "password_history_count", AttributeUtil.fromLong(credentialPolicy.getPasswordHistoryCount()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "password_max_change_time", AttributeUtil.fromLong(credentialPolicy.getPasswordMaxChangeTime()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "password_expiration_notification_periods", AttributeUtil.fromIntegerCollection(credentialPolicy.getPasswordExpiryNotificationDays()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "user_encryption_method", credentialPolicy.getPasswordEncryptionMethod());
        }
        if ((advanced = directoryInternalBean.getAdvanced()) != null) {
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, ATTRIBUTE_USE_NESTED_GROUPS, AttributeUtil.fromBoolean(advanced.getEnableNestedGroups()));
        }
    }

    private static void setDirectoryAttributes(@Nonnull Map<String, String> attributes, @Nonnull DirectoryDelegatingBean directoryDelegatingBean) {
        DirectoryDelegatingBean.DirectoryDelegatingConfiguration configuration;
        DirectoryDelegatingBean.DirectoryDelegatingConnector connector = directoryDelegatingBean.getConnector();
        if (connector != null) {
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "crowd.delegated.directory.type", DirectoryBeanUtil.toDirectoryDelegatedConnectorTypeClass(connector.getType()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.url", connector.getUrl());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.secure", DirectoryBeanUtil.toDirectoryDelegatingConnectorSecureModeName(connector.getSsl()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.referral", AttributeUtil.fromBoolean(connector.getUseNodeReferrals()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.nestedgroups.disabled", AttributeUtil.fromBoolean(connector.getNestedGroupsDisabled()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "crowd.delegated.directory.auto.create.user", AttributeUtil.fromBoolean(connector.getSynchronizeUsers()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "crowd.delegated.directory.auto.update.user", AttributeUtil.fromBoolean(connector.getSynchronizeUserDetails()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "crowd.delegated.directory.importGroups", AttributeUtil.fromBoolean(connector.getSynchronizeGroupMemberships()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.usermembership.use", AttributeUtil.fromBoolean(connector.getUseUserMembershipAttribute()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.pagedresults", AttributeUtil.fromBoolean(connector.getUsePagedResults()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.pagedresults.size", AttributeUtil.fromLong(connector.getPagedResultsSize()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.read.timeout", AttributeUtil.fromLong(connector.getReadTimeoutInMillis()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.search.timelimit", AttributeUtil.fromLong(connector.getSearchTimeoutInMillis()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.connection.timeout", AttributeUtil.fromLong(connector.getConnectionTimeoutInMillis()));
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.basedn", connector.getBaseDn());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.userdn", connector.getUsername());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.password", connector.getPassword());
        }
        if ((configuration = directoryDelegatingBean.getConfiguration()) != null) {
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.dn", configuration.getUserDn());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.objectclass", configuration.getUserObjectClass());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.filter", configuration.getUserObjectFilter());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.username", configuration.getUserNameAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.username.rdn", configuration.getUserNameRdnAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.firstname", configuration.getUserFirstNameAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.lastname", configuration.getUserLastNameAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.displayname", configuration.getUserDisplayNameAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.email", configuration.getUserEmailAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.user.group", configuration.getUserGroupAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.external.id", configuration.getUserUniqueIdAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.group.dn", configuration.getGroupDn());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.group.objectclass", configuration.getGroupObjectClass());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.group.filter", configuration.getGroupObjectFilter());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.group.name", configuration.getGroupNameAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.group.description", configuration.getGroupDescriptionAttribute());
            DirectoryBeanUtil.setAttributeIfNotNull(attributes, "ldap.group.usernames", configuration.getGroupMembersAttribute());
        }
        PollerConfig pollerConfig = new PollerConfig();
        attributes.putIfAbsent("localUserStatusEnabled", Boolean.toString(false));
        attributes.putIfAbsent("ldap.activedirectory.use_primary_groups", Boolean.toString(false));
        attributes.putIfAbsent("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.toString(false));
        attributes.putIfAbsent("ldap.filter.expiredUsers", Boolean.toString(false));
        attributes.putIfAbsent("ldap.pool.type", "JNDI");
        attributes.putIfAbsent("ldap.relaxed.dn.standardisation", Boolean.toString(false));
        attributes.putIfAbsent("ldap.usermembership.use.for.groups", Boolean.toString(false));
        attributes.putIfAbsent("ldap.local.groups", Boolean.toString(false));
        attributes.putIfAbsent("ldap.roles.disabled", Boolean.toString(true));
        attributes.putIfAbsent("crowd.sync.incremental.enabled", Boolean.toString(false));
        attributes.putIfAbsent("directory.cache.synchronise.cron", pollerConfig.getCronExpression());
        attributes.putIfAbsent("directory.cache.synchronise.interval", Long.toString(pollerConfig.getPollingIntervalInMin() * 60L));
        attributes.putIfAbsent("directory.cache.synchronise.type", pollerConfig.getSynchronisationType());
        attributes.putIfAbsent("crowd.sync.group.membership.after.successful.user.auth.enabled", SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.DEFAULT.getValue());
    }

    private static void setDirectoryAllowedOperations(@Nonnull Set<OperationType> allowedOperations, @Nonnull AbstractDirectoryBean directoryBean) {
        DirectoryPermissions permissions = DirectoryInternalBean.class.equals(directoryBean.getClass()) ? ((DirectoryInternalBean)directoryBean).getPermissions() : (DirectoryDelegatingBean.class.equals(directoryBean.getClass()) ? ((DirectoryDelegatingBean)directoryBean).getPermissions() : null);
        if (permissions != null) {
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.CREATE_GROUP, permissions.getAddGroup());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.CREATE_USER, permissions.getAddUser());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.UPDATE_GROUP, permissions.getModifyGroup());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.UPDATE_USER, permissions.getModifyUser());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.UPDATE_GROUP_ATTRIBUTE, permissions.getModifyGroupAttributes());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.UPDATE_USER_ATTRIBUTE, permissions.getModifyUserAttributes());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.DELETE_GROUP, permissions.getRemoveGroup());
            DirectoryBeanUtil.setAllowedOperationIfNotNull(allowedOperations, OperationType.DELETE_USER, permissions.getRemoveUser());
        }
    }

    private static void setAttributeIfNotNull(Map<String, String> attributes, String attribute, String value) {
        if (value != null) {
            attributes.put(attribute, value);
        }
    }

    private static void setAllowedOperationIfNotNull(Set<OperationType> allowedOperations, OperationType operationType, Boolean permission) {
        if (permission != null) {
            allowedOperations.remove(operationType);
            if (Boolean.TRUE.equals(permission)) {
                allowedOperations.add(operationType);
            }
        }
    }

    private DirectoryBeanUtil() {
    }

    static {
        HashSet<Class> supportedDirectoryBeanTypes = new HashSet<Class>();
        supportedDirectoryBeanTypes.add(DirectoryInternalBean.class);
        supportedDirectoryBeanTypes.add(DirectoryDelegatingBean.class);
        SUPPORTED_DIRECTORY_BEAN_TYPES = Collections.unmodifiableSet(supportedDirectoryBeanTypes);
    }

    public static class UnsupportedDirectoryBeanException
    extends Exception {
        public UnsupportedDirectoryBeanException(Class<? extends AbstractDirectoryBean> directoryBeanClass) {
            super(directoryBeanClass.getName());
        }
    }

    static enum DirectoryDelegatingConnectorTypeImplClass {
        MICROSOFT_ACTIVE_DIRECTORY(MicrosoftActiveDirectory.class.getCanonicalName());

        private final String implClass;

        private DirectoryDelegatingConnectorTypeImplClass(String implClass) {
            this.implClass = implClass;
        }

        public static DirectoryDelegatingConnectorTypeImplClass fromImplClass(String implClass) {
            for (DirectoryDelegatingConnectorTypeImplClass directoryDelegatingConnectorTypeImplClass : DirectoryDelegatingConnectorTypeImplClass.values()) {
                if (!directoryDelegatingConnectorTypeImplClass.getImplClass().equals(implClass)) continue;
                return directoryDelegatingConnectorTypeImplClass;
            }
            return null;
        }

        @Generated
        public String getImplClass() {
            return this.implClass;
        }
    }
}

