/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.filter;

import com.atlassian.crowd.manager.permission.UserPermissionService;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.atlassian.plugins.rest.common.security.AuthorisationException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import javax.inject.Inject;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Provider
@Component
public class SysadminOnlyResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserPermissionService userPermissionService;

    @Inject
    public SysadminOnlyResourceFilter(UserManager userManager, UserPermissionService userPermissionService) {
        this.userManager = userManager;
        this.userPermissionService = userPermissionService;
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    public ContainerRequest filter(ContainerRequest containerRequest) {
        UserProfile loggedInUser = this.userManager.getRemoteUser();
        if (loggedInUser == null) {
            throw new AuthenticationRequiredException();
        }
        if (!this.isSystemAdministrator(loggedInUser)) {
            throw new AuthorisationException("Client must be authenticated as an system administrator to access this resource.");
        }
        return containerRequest;
    }

    public boolean isSystemAdministrator(UserProfile userProfile) {
        return this.userPermissionService.hasPermission(userProfile.getUsername(), UserPermission.SYS_ADMIN);
    }
}

