/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest.api;

import de.aservo.confapi.commons.model.ErrorCollection;
import de.aservo.confapi.commons.model.GadgetBean;
import de.aservo.confapi.commons.model.GadgetsBean;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public interface GadgetsResource {
    @GET
    @Produces(value={"application/json"})
    @Operation(tags={"gadgets"}, summary="Get all gadgets", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GadgetsBean.class))}, description="Returns all gadgets."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getGadgets();

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Operation(tags={"gadgets"}, summary="Get a gadget", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GadgetBean.class))}, description="Returns the requested gadget."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response getGadget(@PathParam(value="id") long var1);

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"gadgets"}, summary="Set or update a list of gadgets", description="NOTE: This will only create gadgets that does not exist yet as there is no real 'update'.", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GadgetsBean.class))}, description="Returns all gadgets."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setGadgets(@NotNull GadgetsBean var1);

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"gadgets"}, summary="Update a gadget", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GadgetBean.class))}, description="Returns the updated gadget."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response setGadget(@PathParam(value="id") long var1, @NotNull GadgetBean var3);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(tags={"gadgets"}, summary="Add a gadget", description="Upon successful request, returns a `GadgetBean` object of the created gadget.", responses={@ApiResponse(responseCode="200", content={@Content(schema=@Schema(implementation=GadgetBean.class))}, description="Returns the added gadget."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response addGadget(@NotNull GadgetBean var1);

    @DELETE
    @Operation(tags={"gadgets"}, summary="Delete all gadgets", description="NOTE: The 'force' parameter must be set to 'true' in order to execute this request.", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteGadgets(@QueryParam(value="force") boolean var1);

    @DELETE
    @Path(value="{id}")
    @Operation(tags={"gadgets"}, summary="Delete a gadget", responses={@ApiResponse(responseCode="200", description="Returns an empty body."), @ApiResponse(responseCode="default", content={@Content(schema=@Schema(implementation=ErrorCollection.class))}, description="Returns a list of error messages.")})
    public Response deleteGadget(@PathParam(value="id") long var1);
}

