/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.model.SettingsBean;
import de.aservo.confapi.commons.service.api.SettingsService;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={SettingsService.class})
public class SettingsServiceImpl
implements SettingsService {
    private final PropertyManager propertyManager;

    @Inject
    public SettingsServiceImpl(@ComponentImport PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    @Override
    public SettingsBean getSettings() {
        SettingsBean settingsBean = new SettingsBean();
        try {
            settingsBean.setBaseUrl(this.propertyManager.getBaseUrl());
            settingsBean.setTitle(this.propertyManager.getDeploymentTitle());
        }
        catch (PropertyManagerException e) {
            throw new InternalServerErrorException(e);
        }
        return settingsBean;
    }

    @Override
    public SettingsBean setSettings(SettingsBean settingsBean) {
        if (settingsBean.getBaseUrl() != null) {
            this.propertyManager.setBaseUrl(settingsBean.getBaseUrl());
        }
        if (settingsBean.getTitle() != null) {
            this.propertyManager.setDeploymentTitle(settingsBean.getTitle());
        }
        return this.getSettings();
    }
}

