/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.ApplicationAlreadyExistsException;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.application.DefaultGroupMembershipService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.application.ImmutableApplicationDirectoryMapping;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.commons.exception.NotFoundException;
import de.aservo.confapi.crowd.model.ApplicationBean;
import de.aservo.confapi.crowd.model.ApplicationsBean;
import de.aservo.confapi.crowd.model.util.ApplicationBeanUtil;
import de.aservo.confapi.crowd.service.api.ApplicationsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ApplicationsService.class})
public class ApplicationsServiceImpl
implements ApplicationsService {
    private final ApplicationManager applicationManager;
    private final DefaultGroupMembershipService defaultGroupMembershipService;
    private final DirectoryManager directoryManager;

    @Inject
    public ApplicationsServiceImpl(@ComponentImport ApplicationManager applicationManager, @ComponentImport DefaultGroupMembershipService defaultGroupMembershipService, @ComponentImport DirectoryManager directoryManager) {
        this.applicationManager = applicationManager;
        this.defaultGroupMembershipService = defaultGroupMembershipService;
        this.directoryManager = directoryManager;
    }

    @Override
    public ApplicationsBean getApplications() {
        return new ApplicationsBean(this.applicationManager.findAll().stream().map(application -> ApplicationBeanUtil.toApplicationBean(application, this.defaultGroupMembershipService)).collect(Collectors.toList()));
    }

    @Override
    public ApplicationBean getApplication(long id) {
        try {
            return ApplicationBeanUtil.toApplicationBean(this.applicationManager.findById(id), this.defaultGroupMembershipService);
        }
        catch (ApplicationNotFoundException e) {
            throw new NotFoundException(e);
        }
    }

    @Override
    public ApplicationsBean setApplications(ApplicationsBean applicationsBean) {
        ArrayList<ApplicationBean> applicationBeans = new ArrayList<ApplicationBean>();
        for (ApplicationBean applicationBean : applicationsBean.getApplications()) {
            try {
                Application application = this.applicationManager.findByName(applicationBean.getName());
                applicationBeans.add(this.setApplication(application.getId(), applicationBean));
            }
            catch (ApplicationNotFoundException ignored) {
                applicationBeans.add(this.addApplication(applicationBean));
            }
        }
        return new ApplicationsBean(applicationBeans);
    }

    @Override
    public ApplicationBean addApplication(ApplicationBean applicationBean) {
        try {
            Application createdApplication = this.applicationManager.add(ApplicationBeanUtil.toApplication(applicationBean));
            this.persistApplicationDirectoryMappings(createdApplication, applicationBean);
            this.persistApplicationBeanAuthenticationGroups(createdApplication, applicationBean);
            this.persistApplicationBeanAutoAssignmentGroups(createdApplication, applicationBean);
            return this.getApplication(createdApplication.getId());
        }
        catch (ApplicationAlreadyExistsException | InvalidCredentialException e) {
            throw new BadRequestException(e);
        }
    }

    @Override
    public ApplicationBean setApplication(long id, ApplicationBean applicationBean) {
        try {
            Application existingApplication = this.applicationManager.findById(id);
            Application modifiedApplication = ApplicationBeanUtil.toApplication(applicationBean, existingApplication);
            Application updatedApplication = this.applicationManager.update(modifiedApplication);
            this.persistApplicationDirectoryMappings(updatedApplication, applicationBean);
            this.persistApplicationBeanAuthenticationGroups(updatedApplication, applicationBean);
            this.persistApplicationBeanAutoAssignmentGroups(updatedApplication, applicationBean);
            return this.getApplication(updatedApplication.getId());
        }
        catch (ApplicationNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (ApplicationManagerException e) {
            throw new InternalServerErrorException(e);
        }
    }

    @Override
    public void deleteApplications(boolean force) {
        if (!force) {
            throw new BadRequestException("Set 'force' query param to true in order to delete all applications");
        }
        this.applicationManager.findAll().stream().filter(a -> !a.isPermanent()).forEach(a -> this.deleteApplication(a.getId()));
    }

    @Override
    public void deleteApplication(long id) {
        try {
            Application application = this.applicationManager.findById(id);
            this.applicationManager.remove(application);
        }
        catch (ApplicationNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (ApplicationManagerException e) {
            throw new InternalServerErrorException(e);
        }
    }

    void persistApplicationDirectoryMappings(Application application, ApplicationBean applicationBean) {
        if (applicationBean.getDirectoryMappings() == null) {
            return;
        }
        Map applicationDirectoryMappingsByDirectoryName = application.getApplicationDirectoryMappings().stream().collect(Collectors.toMap(adm -> adm.getDirectory().getName(), Function.identity()));
        Map applicationBeanDirectoryMappingsByDirectoryName = applicationBean.getDirectoryMappings().stream().collect(Collectors.toMap(ApplicationBean.ApplicationDirectoryMapping::getDirectoryName, Function.identity()));
        ArrayList<ApplicationDirectoryMapping> applicationDirectoryMappingsToCreate = new ArrayList<ApplicationDirectoryMapping>();
        ArrayList<ApplicationDirectoryMapping> applicationDirectoryMappingsToUpdate = new ArrayList<ApplicationDirectoryMapping>();
        for (ApplicationDirectoryMapping applicationDirectoryMapping : this.toApplicationDirectoryMappings(applicationBeanDirectoryMappingsByDirectoryName.values())) {
            if (!applicationDirectoryMappingsByDirectoryName.containsKey(applicationDirectoryMapping.getDirectory().getName())) {
                applicationDirectoryMappingsToCreate.add(applicationDirectoryMapping);
                continue;
            }
            applicationDirectoryMappingsToUpdate.add(applicationDirectoryMapping);
        }
        for (ApplicationDirectoryMapping applicationDirectoryMapping : applicationDirectoryMappingsToCreate) {
            this.addApplicationDirectoryMapping(application, applicationDirectoryMapping);
        }
        for (ApplicationDirectoryMapping applicationDirectoryMapping : applicationDirectoryMappingsToUpdate) {
            this.updateApplicationDirectoryMapping(application, applicationDirectoryMapping);
        }
        for (ApplicationDirectoryMapping applicationDirectoryMapping : applicationDirectoryMappingsByDirectoryName.values()) {
            if (applicationBeanDirectoryMappingsByDirectoryName.containsKey(applicationDirectoryMapping.getDirectory().getName())) continue;
            this.removeApplicationDirectoryMapping(application, applicationDirectoryMapping);
        }
    }

    void persistApplicationBeanAuthenticationGroups(Application application, ApplicationBean applicationBean) {
        if (applicationBean.getDirectoryMappings() == null) {
            return;
        }
        Map<String, Collection> authenticationGroupsByDirectoryName = applicationBean.getDirectoryMappings().stream().collect(Collectors.toMap(ApplicationBean.ApplicationDirectoryMapping::getDirectoryName, ApplicationBean.ApplicationDirectoryMapping::getAuthenticationGroups));
        for (ApplicationDirectoryMapping applicationDirectoryMapping : application.getApplicationDirectoryMappings()) {
            HashSet authenticationGroups = new HashSet(authenticationGroupsByDirectoryName.getOrDefault(applicationDirectoryMapping.getDirectory().getName(), Collections.emptySet()));
            Set currentAuthenticationGroups = applicationDirectoryMapping.getAuthorisedGroupNames();
            HashSet<String> authenticationGroupsToAdd = new HashSet<String>(authenticationGroups);
            authenticationGroupsToAdd.removeAll(currentAuthenticationGroups);
            this.addAuthenticationGroups(application, applicationDirectoryMapping.getDirectory(), authenticationGroupsToAdd);
            HashSet<String> authenticationGroupsToRemove = new HashSet<String>(currentAuthenticationGroups);
            authenticationGroupsToRemove.removeAll(authenticationGroups);
            this.removeAuthenticationGroups(application, applicationDirectoryMapping.getDirectory(), authenticationGroupsToRemove);
        }
    }

    void persistApplicationBeanAutoAssignmentGroups(Application application, ApplicationBean applicationBean) {
        if (applicationBean.getDirectoryMappings() == null) {
            return;
        }
        Map<String, Collection> autoAssignmentGroupsByDirectoryName = applicationBean.getDirectoryMappings().stream().collect(Collectors.toMap(ApplicationBean.ApplicationDirectoryMapping::getDirectoryName, ApplicationBean.ApplicationDirectoryMapping::getAutoAssignmentGroups));
        for (ApplicationDirectoryMapping applicationDirectoryMapping : application.getApplicationDirectoryMappings()) {
            HashSet currentAutoAssignmentGroups;
            Collection autoAssignmentGroups = autoAssignmentGroupsByDirectoryName.getOrDefault(applicationDirectoryMapping.getDirectory().getName(), Collections.emptyList());
            try {
                currentAutoAssignmentGroups = new HashSet(this.defaultGroupMembershipService.listAll(application, applicationDirectoryMapping));
            }
            catch (OperationFailedException e) {
                throw new InternalServerErrorException(e);
            }
            HashSet autoAssignmentGroupSet = new HashSet(autoAssignmentGroups);
            HashSet<String> autoAssignmentGroupsToAdd = new HashSet<String>(autoAssignmentGroupSet);
            autoAssignmentGroupsToAdd.removeAll(currentAutoAssignmentGroups);
            this.addAutoAssignmentGroups(application, applicationDirectoryMapping, autoAssignmentGroupsToAdd, this.defaultGroupMembershipService);
            HashSet<String> autoAssignmentGroupsToRemove = new HashSet<String>(currentAutoAssignmentGroups);
            autoAssignmentGroupsToRemove.removeAll(autoAssignmentGroupSet);
            this.removeAutoAssignmentGroups(application, applicationDirectoryMapping, autoAssignmentGroupsToRemove, this.defaultGroupMembershipService);
        }
    }

    @Nonnull
    Collection<ApplicationDirectoryMapping> toApplicationDirectoryMappings(@Nonnull Collection<ApplicationBean.ApplicationDirectoryMapping> applicationBeanDirectoryMappings) {
        return applicationBeanDirectoryMappings.stream().map(this::toApplicationDirectoryMapping).collect(Collectors.toList());
    }

    @Nonnull
    ApplicationDirectoryMapping toApplicationDirectoryMapping(@Nonnull ApplicationBean.ApplicationDirectoryMapping applicationBeanDirectoryMapping) {
        if (applicationBeanDirectoryMapping.getDirectoryName() == null || applicationBeanDirectoryMapping.getDirectoryName().isEmpty()) {
            throw new BadRequestException("Application directory mapping must contain a directory name");
        }
        ImmutableApplicationDirectoryMapping.Builder applicationDirectoryMappingBuilder = ImmutableApplicationDirectoryMapping.builder();
        applicationDirectoryMappingBuilder.setDirectory(ApplicationsServiceImpl.findDirectory(applicationBeanDirectoryMapping.getDirectoryName(), this.directoryManager));
        if (applicationBeanDirectoryMapping.getAuthenticationAllowAll() != null) {
            applicationDirectoryMappingBuilder.setAllowAllToAuthenticate(applicationBeanDirectoryMapping.getAuthenticationAllowAll().booleanValue());
        }
        if (applicationBeanDirectoryMapping.getAuthenticationGroups() != null) {
            applicationDirectoryMappingBuilder.setAuthorisedGroupNames(new HashSet<String>(applicationBeanDirectoryMapping.getAuthenticationGroups()));
        }
        if (applicationBeanDirectoryMapping.getAllowedOperations() != null) {
            applicationDirectoryMappingBuilder.setAllowedOperations(new HashSet<OperationType>(applicationBeanDirectoryMapping.getAllowedOperations()));
        }
        return applicationDirectoryMappingBuilder.build();
    }

    void addApplicationDirectoryMapping(Application application, ApplicationDirectoryMapping applicationDirectoryMapping) {
        try {
            this.applicationManager.addDirectoryMapping(application, applicationDirectoryMapping.getDirectory(), applicationDirectoryMapping.isAllowAllToAuthenticate(), applicationDirectoryMapping.getAllowedOperations().toArray(new OperationType[0]));
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }

    void updateApplicationDirectoryMapping(Application application, ApplicationDirectoryMapping applicationDirectoryMapping) {
        try {
            this.applicationManager.updateDirectoryMapping(application, applicationDirectoryMapping.getDirectory(), applicationDirectoryMapping.isAllowAllToAuthenticate(), applicationDirectoryMapping.getAllowedOperations());
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            throw new InternalServerErrorException(e);
        }
    }

    void removeApplicationDirectoryMapping(Application application, ApplicationDirectoryMapping applicationDirectoryMapping) {
        try {
            this.applicationManager.removeDirectoryFromApplication(applicationDirectoryMapping.getDirectory(), application);
        }
        catch (ApplicationManagerException e) {
            throw new InternalServerErrorException(e);
        }
    }

    void addAuthenticationGroups(Application application, Directory directory, Collection<String> authenticationGroupsToAdd) {
        for (String authenticationGroupToAdd : authenticationGroupsToAdd) {
            try {
                this.applicationManager.addGroupMapping(application, directory, authenticationGroupToAdd);
            }
            catch (ApplicationNotFoundException e) {
                throw new InternalServerErrorException(e);
            }
        }
    }

    void removeAuthenticationGroups(Application application, Directory directory, Collection<String> authenticationGroupsToRemove) {
        for (String authenticationGroupToRemove : authenticationGroupsToRemove) {
            try {
                this.applicationManager.removeGroupMapping(application, directory, authenticationGroupToRemove);
            }
            catch (ApplicationNotFoundException e) {
                throw new InternalServerErrorException(e);
            }
        }
    }

    void addAutoAssignmentGroups(Application application, ApplicationDirectoryMapping applicationDirectoryMapping, Collection<String> autoAssignmentGroupsToAdd, DefaultGroupMembershipService defaultGroupMembershipService) {
        for (String autoAssignmentGroupToAdd : autoAssignmentGroupsToAdd) {
            try {
                defaultGroupMembershipService.add(application, applicationDirectoryMapping, autoAssignmentGroupToAdd);
            }
            catch (OperationFailedException e) {
                throw new InternalServerErrorException(e);
            }
        }
    }

    void removeAutoAssignmentGroups(Application application, ApplicationDirectoryMapping applicationDirectoryMapping, Collection<String> autoAssignmentGroupsToRemove, DefaultGroupMembershipService defaultGroupMembershipService) {
        for (String autoAssignmentGroupToRemove : autoAssignmentGroupsToRemove) {
            try {
                defaultGroupMembershipService.remove(application, applicationDirectoryMapping, autoAssignmentGroupToRemove);
            }
            catch (OperationFailedException e) {
                throw new InternalServerErrorException(e);
            }
        }
    }

    @Nonnull
    private static Directory findDirectory(String directoryName, DirectoryManager directoryManager) {
        try {
            return directoryManager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            throw new BadRequestException(e);
        }
    }
}

