/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.crowd.model.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.DefaultGroupMembershipService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import de.aservo.confapi.commons.exception.BadRequestException;
import de.aservo.confapi.commons.exception.InternalServerErrorException;
import de.aservo.confapi.crowd.model.ApplicationBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationBeanUtil {
    public static ApplicationBean toApplicationBean(Application application, DefaultGroupMembershipService defaultGroupMembershipService) {
        ApplicationBean applicationBean = new ApplicationBean();
        applicationBean.setId(application.getId());
        applicationBean.setName(application.getName());
        applicationBean.setDescription(application.getDescription());
        applicationBean.setActive(application.isActive());
        applicationBean.setType(ApplicationBeanUtil.toApplicationBeanType(application.getType()));
        applicationBean.setCachedDirectoriesAuthenticationOrderOptimisationEnabled(application.isCachedDirectoriesAuthenticationOrderOptimisationEnabled());
        applicationBean.setDirectoryMappings(ApplicationBeanUtil.toApplicationBeanDirectoryMappings(application, defaultGroupMembershipService));
        applicationBean.setAccessBasedSynchronisation(ApplicationBeanUtil.toApplicationBeanAccessBasedSynchronisation(application));
        applicationBean.setMembershipAggregationEnabled(application.isMembershipAggregationEnabled());
        applicationBean.setRemoteAddresses(ApplicationBeanUtil.toStringCollection(application.getRemoteAddresses()));
        applicationBean.setAliasingEnabled(application.isAliasingEnabled());
        applicationBean.setLowercaseOutputEnabled(application.isLowerCaseOutput());
        applicationBean.setAuthenticationWithoutPasswordEnabled(application.isAuthenticationWithoutPasswordEnabled());
        return applicationBean;
    }

    public static Application toApplication(ApplicationBean applicationBean, Application existingApplication) {
        ImmutableApplication.Builder applicationBuilder = new ImmutableApplication.Builder(existingApplication);
        return ApplicationBeanUtil.toApplicationInternal(applicationBean, applicationBuilder);
    }

    public static Application toApplication(ApplicationBean applicationBean) {
        ImmutableApplication.Builder applicationBuilder = ImmutableApplication.builder((String)applicationBean.getName(), (ApplicationType)ApplicationBeanUtil.toApplicationType(applicationBean.getType()));
        return ApplicationBeanUtil.toApplicationInternal(applicationBean, applicationBuilder);
    }

    private static Application toApplicationInternal(ApplicationBean applicationBean, ImmutableApplication.Builder applicationBuilder) {
        if (applicationBean.getId() != null) {
            applicationBuilder.setId(applicationBean.getId());
        }
        if (applicationBean.getName() != null) {
            applicationBuilder.setName(applicationBean.getName());
        }
        if (applicationBean.getDescription() != null) {
            applicationBuilder.setDescription(applicationBean.getDescription());
        }
        if (applicationBean.getActive() != null) {
            applicationBuilder.setActive(applicationBean.getActive().booleanValue());
        }
        if (applicationBean.getPassword() != null) {
            applicationBuilder.setPasswordCredential(PasswordCredential.unencrypted((String)applicationBean.getPassword()));
        }
        if (applicationBean.getCachedDirectoriesAuthenticationOrderOptimisationEnabled() != null) {
            applicationBuilder.setCachedDirectoriesAuthenticationOrderOptimisationEnabled(applicationBean.getCachedDirectoriesAuthenticationOrderOptimisationEnabled().booleanValue());
        }
        if (applicationBean.getAccessBasedSynchronisation() != null) {
            applicationBuilder.setFilteringGroupsWithAccessEnabled(applicationBean.getAccessBasedSynchronisation() == ApplicationBean.AccessBasedSynchronisation.USER_AND_GROUP_FILTERING);
            applicationBuilder.setFilteringUsersWithAccessEnabled(applicationBean.getAccessBasedSynchronisation() == ApplicationBean.AccessBasedSynchronisation.USER_AND_GROUP_FILTERING || applicationBean.getAccessBasedSynchronisation() == ApplicationBean.AccessBasedSynchronisation.USER_ONLY_FILTERING);
        }
        if (applicationBean.getMembershipAggregationEnabled() != null) {
            applicationBuilder.setMembershipAggregationEnabled(applicationBean.getMembershipAggregationEnabled().booleanValue());
        }
        if (applicationBean.getRemoteAddresses() != null) {
            applicationBuilder.setRemoteAddresses(ApplicationBeanUtil.toAddressSet(applicationBean.getRemoteAddresses()));
        }
        if (applicationBean.getAliasingEnabled() != null) {
            applicationBuilder.setAliasingEnabled(applicationBean.getAliasingEnabled().booleanValue());
        }
        if (applicationBean.getLowercaseOutputEnabled() != null) {
            applicationBuilder.setLowercaseOutput(applicationBean.getLowercaseOutputEnabled().booleanValue());
        }
        if (applicationBean.getAuthenticationWithoutPasswordEnabled() != null) {
            applicationBuilder.setAuthenticationWithoutPasswordEnabled(applicationBean.getAuthenticationWithoutPasswordEnabled().booleanValue());
        }
        ImmutableApplication application = applicationBuilder.build();
        if (applicationBean.getType() != null && application.getType() != ApplicationBeanUtil.toApplicationType(applicationBean.getType())) {
            throw new BadRequestException("Changing the application type is not allowed");
        }
        return application;
    }

    @Nullable
    public static ApplicationBean.ApplicationType toApplicationBeanType(ApplicationType applicationType) {
        if (ApplicationType.GENERIC_APPLICATION.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.GENERIC;
        }
        if (ApplicationType.PLUGIN.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.PLUGIN;
        }
        if (ApplicationType.CROWD.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.CROWD;
        }
        if (ApplicationType.JIRA.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.JIRA;
        }
        if (ApplicationType.CONFLUENCE.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.CONFLUENCE;
        }
        if (ApplicationType.STASH.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.BITBUCKET;
        }
        if (ApplicationType.FISHEYE.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.FISHEYE;
        }
        if (ApplicationType.CRUCIBLE.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.CRUCIBLE;
        }
        if (ApplicationType.BAMBOO.equals((Object)applicationType)) {
            return ApplicationBean.ApplicationType.BAMBOO;
        }
        return null;
    }

    @Nullable
    public static ApplicationType toApplicationType(ApplicationBean.ApplicationType applicationBeanType) {
        if (ApplicationBean.ApplicationType.GENERIC.equals((Object)applicationBeanType)) {
            return ApplicationType.GENERIC_APPLICATION;
        }
        if (ApplicationBean.ApplicationType.PLUGIN.equals((Object)applicationBeanType)) {
            return ApplicationType.PLUGIN;
        }
        if (ApplicationBean.ApplicationType.CROWD.equals((Object)applicationBeanType)) {
            return ApplicationType.CROWD;
        }
        if (ApplicationBean.ApplicationType.JIRA.equals((Object)applicationBeanType)) {
            return ApplicationType.JIRA;
        }
        if (ApplicationBean.ApplicationType.CONFLUENCE.equals((Object)applicationBeanType)) {
            return ApplicationType.CONFLUENCE;
        }
        if (ApplicationBean.ApplicationType.BITBUCKET.equals((Object)applicationBeanType)) {
            return ApplicationType.STASH;
        }
        if (ApplicationBean.ApplicationType.FISHEYE.equals((Object)applicationBeanType)) {
            return ApplicationType.FISHEYE;
        }
        if (ApplicationBean.ApplicationType.CRUCIBLE.equals((Object)applicationBeanType)) {
            return ApplicationType.CRUCIBLE;
        }
        if (ApplicationBean.ApplicationType.BAMBOO.equals((Object)applicationBeanType)) {
            return ApplicationType.BAMBOO;
        }
        return null;
    }

    @Nonnull
    static Collection<ApplicationBean.ApplicationDirectoryMapping> toApplicationBeanDirectoryMappings(@Nonnull Application application, @Nonnull DefaultGroupMembershipService defaultGroupMembershipService) {
        List applicationDirectoryMappings = application.getApplicationDirectoryMappings();
        ArrayList<ApplicationBean.ApplicationDirectoryMapping> applicationBeanDirectoryMappings = new ArrayList<ApplicationBean.ApplicationDirectoryMapping>();
        for (ApplicationDirectoryMapping applicationDirectoryMapping : applicationDirectoryMappings) {
            ApplicationBean.ApplicationDirectoryMapping applicationBeanDirectoryMapping = new ApplicationBean.ApplicationDirectoryMapping();
            applicationBeanDirectoryMapping.setDirectoryName(applicationDirectoryMapping.getDirectory().getName());
            applicationBeanDirectoryMapping.setAuthenticationAllowAll(applicationDirectoryMapping.isAllowAllToAuthenticate());
            if (!applicationDirectoryMapping.isAllowAllToAuthenticate()) {
                applicationBeanDirectoryMapping.setAuthenticationGroups(applicationDirectoryMapping.getAuthorisedGroupNames());
            } else {
                applicationBeanDirectoryMapping.setAuthenticationGroups(Collections.emptyList());
            }
            try {
                applicationBeanDirectoryMapping.setAutoAssignmentGroups(defaultGroupMembershipService.listAll(application, applicationDirectoryMapping).stream().sorted().collect(Collectors.toList()));
            }
            catch (OperationFailedException e) {
                throw new InternalServerErrorException(e);
            }
            applicationBeanDirectoryMapping.setAllowedOperations(applicationDirectoryMapping.getAllowedOperations().stream().sorted().collect(Collectors.toList()));
            applicationBeanDirectoryMappings.add(applicationBeanDirectoryMapping);
        }
        return applicationBeanDirectoryMappings;
    }

    static ApplicationBean.AccessBasedSynchronisation toApplicationBeanAccessBasedSynchronisation(Application application) {
        if (application.isFilteringGroupsWithAccessEnabled() && application.isFilteringUsersWithAccessEnabled()) {
            return ApplicationBean.AccessBasedSynchronisation.USER_AND_GROUP_FILTERING;
        }
        if (application.isFilteringUsersWithAccessEnabled()) {
            return ApplicationBean.AccessBasedSynchronisation.USER_ONLY_FILTERING;
        }
        return ApplicationBean.AccessBasedSynchronisation.NO_FILTERING;
    }

    @Nonnull
    static Set<RemoteAddress> toAddressSet(@Nullable Collection<String> remoteAddresses) {
        if (remoteAddresses == null) {
            return new HashSet<RemoteAddress>();
        }
        return remoteAddresses.stream().map(RemoteAddress::new).collect(Collectors.toSet());
    }

    @Nonnull
    public static Collection<String> toStringCollection(@Nonnull Set<RemoteAddress> remoteAddresses) {
        return remoteAddresses.stream().map(RemoteAddress::getAddress).sorted().collect(Collectors.toList());
    }

    private ApplicationBeanUtil() {
    }
}

