/*
 * Decompiled with CFR 0.152.
 */
package de.aservo.confapi.commons.rest;

import de.aservo.confapi.commons.model.SettingsBrandingColorSchemeBean;
import de.aservo.confapi.commons.rest.api.SettingsBrandingResource;
import de.aservo.confapi.commons.service.api.SettingsBrandingService;
import java.io.InputStream;
import javax.ws.rs.core.Response;

public abstract class AbstractSettingsBrandingResourceImpl
implements SettingsBrandingResource {
    private final SettingsBrandingService brandingService;

    public AbstractSettingsBrandingResourceImpl(SettingsBrandingService brandingService) {
        this.brandingService = brandingService;
    }

    @Override
    public Response getBrandingColorScheme() {
        SettingsBrandingColorSchemeBean colourSchemeBean = this.brandingService.getColourScheme();
        return Response.ok((Object)colourSchemeBean).build();
    }

    @Override
    public Response setBrandingColorScheme(SettingsBrandingColorSchemeBean bean) {
        SettingsBrandingColorSchemeBean colourSchemeBean = this.brandingService.setColourScheme(bean);
        return Response.ok((Object)colourSchemeBean).build();
    }

    @Override
    public Response getBrandingLogo() {
        InputStream logo = this.brandingService.getLogo();
        return Response.ok((Object)logo).build();
    }

    @Override
    public Response setBrandingLogo(InputStream binaryInputStream) {
        this.brandingService.setLogo(binaryInputStream);
        return Response.ok().build();
    }

    @Override
    public Response getBrandingFavicon() {
        InputStream favicon = this.brandingService.getFavicon();
        return Response.ok((Object)favicon).build();
    }

    @Override
    public Response setBrandingFavicon(InputStream binaryInputStream) {
        this.brandingService.setFavicon(binaryInputStream);
        return Response.ok().build();
    }
}

